/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.observation.filter;

import java.util.LinkedList;
import org.apache.jackrabbit.guava.common.collect.Lists;
import org.apache.jackrabbit.oak.commons.PathUtils;

public class GlobbingPathHelper {
    public static String globPathAsRegex(String pathWithGlobs) {
        int size;
        boolean endsWithStarStar;
        if (pathWithGlobs == null) {
            return null;
        }
        if (!pathWithGlobs.contains("*")) {
            return pathWithGlobs;
        }
        LinkedList elements = Lists.newLinkedList((Iterable)PathUtils.elements((String)pathWithGlobs));
        StringBuffer sb = new StringBuffer();
        sb.append("\\Q");
        if (pathWithGlobs.startsWith("/")) {
            sb.append("/");
        }
        if (((String)elements.get(0)).equals("**")) {
            sb.append("\\E[^/]*(/[^/]*)*\\Q");
            elements.remove(0);
        }
        boolean bl = endsWithStarStar = (size = elements.size()) == 0 ? false : ((String)elements.get(size - 1)).equals("**");
        if (endsWithStarStar) {
            elements.remove(size - 1);
        }
        boolean addSlash = false;
        for (int i = 0; i < elements.size(); ++i) {
            String pathElem = (String)elements.get(i);
            if (addSlash) {
                sb.append("/");
            }
            if (pathElem.equals("**")) {
                addSlash = false;
                sb.append("\\E([^/]*/)*\\Q");
                continue;
            }
            sb.append(pathElem.replace("*", "\\E[^/]*\\Q"));
            addSlash = true;
        }
        if (endsWithStarStar) {
            sb.append("\\E(/[^/]*)*");
        } else if (pathWithGlobs.endsWith("/")) {
            sb.append("/\\E");
        } else {
            sb.append("\\E");
        }
        return sb.toString();
    }
}

