/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.inventory;

import java.io.PrintWriter;
import org.apache.felix.inventory.Format;
import org.apache.felix.inventory.InventoryPrinter;
import org.apache.jackrabbit.oak.commons.json.JsopBuilder;
import org.apache.jackrabbit.oak.commons.json.JsopWriter;
import org.apache.jackrabbit.oak.json.Base64BlobSerializer;
import org.apache.jackrabbit.oak.json.BlobSerializer;
import org.apache.jackrabbit.oak.json.JsonSerializer;
import org.apache.jackrabbit.oak.plugins.index.IndexPathService;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.jackrabbit.oak.spi.state.NodeStateUtils;
import org.apache.jackrabbit.oak.spi.state.NodeStore;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={InventoryPrinter.class}, property={"felix.inventory.printer.name=oak-index-defn", "felix.inventory.printer.title=Oak Index Definitions", "felix.inventory.printer.format=JSON"})
public class IndexDefinitionPrinter
implements InventoryPrinter {
    @Reference
    private IndexPathService indexPathService;
    @Reference
    private NodeStore nodeStore;
    private String filter = "{\"properties\":[\"*\", \"-:childOrder\"],\"nodes\":[\"*\", \"-:*\"]}";

    public IndexDefinitionPrinter() {
    }

    public IndexDefinitionPrinter(NodeStore nodeStore, IndexPathService indexPathService) {
        this.indexPathService = indexPathService;
        this.nodeStore = nodeStore;
    }

    public void print(PrintWriter printWriter, Format format, boolean isZip) {
        if (format == Format.JSON) {
            NodeState root = this.nodeStore.getRoot();
            JsopBuilder json = new JsopBuilder();
            json.object();
            for (String indexPath : this.indexPathService.getIndexPaths()) {
                json.key(indexPath);
                NodeState idxState = NodeStateUtils.getNode((NodeState)root, (String)indexPath);
                this.createSerializer(json).serialize(idxState);
            }
            json.endObject();
            printWriter.print(JsopBuilder.prettyPrint((String)json.toString()));
        }
    }

    public void setFilter(String filter) {
        this.filter = filter;
    }

    private JsonSerializer createSerializer(JsopBuilder json) {
        return new JsonSerializer((JsopWriter)json, this.filter, (BlobSerializer)new Base64BlobSerializer());
    }
}

