/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment;

import org.apache.jackrabbit.oak.segment.Cache;
import org.apache.jackrabbit.oak.stats.CounterStats;
import org.apache.jackrabbit.oak.stats.StatisticsProvider;
import org.apache.jackrabbit.oak.stats.StatsOptions;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CacheAccessTracker<K, V>
implements Cache<K, V> {
    private final Cache<K, V> delegate;
    private final CounterStats accessCount;
    private final CounterStats missCount;

    public CacheAccessTracker(@NotNull String name, @NotNull StatisticsProvider statisticsProvider, @NotNull Cache<K, V> delegate) {
        this.delegate = delegate;
        this.accessCount = statisticsProvider.getCounterStats(name + ".access-count", StatsOptions.DEFAULT);
        this.missCount = statisticsProvider.getCounterStats(name + ".miss-count", StatsOptions.DEFAULT);
    }

    @Override
    public void put(@NotNull K key, @NotNull V value) {
        this.delegate.put(key, value);
    }

    @Override
    public void put(@NotNull K key, @NotNull V value, byte cost) {
        this.delegate.put(key, value, cost);
    }

    @Override
    @Nullable
    public V get(@NotNull K key) {
        V v = this.delegate.get(key);
        this.accessCount.inc();
        if (v == null) {
            this.missCount.inc();
        }
        return v;
    }
}

