/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.kmax;

import java.util.ArrayList;
import java.util.Collection;
import javax.inject.Inject;
import javax.inject.Named;
import org.silverpeas.core.annotation.Provider;
import org.silverpeas.core.contribution.publication.model.PublicationDetail;
import org.silverpeas.core.contribution.publication.service.PublicationService;
import org.silverpeas.core.silverstatistics.volume.model.UserIdCountVolumeCouple;
import org.silverpeas.core.silverstatistics.volume.service.ComponentStatisticsProvider;

@Provider
@Named(value="kmaxStatistics")
public class KmaxStatistics
implements ComponentStatisticsProvider {
    @Inject
    private PublicationService publicationService;

    public Collection<UserIdCountVolumeCouple> getVolume(String spaceId, String componentId) {
        Collection<PublicationDetail> publications = this.getPublications(componentId);
        ArrayList<UserIdCountVolumeCouple> myArrayList = new ArrayList<UserIdCountVolumeCouple>(publications.size());
        for (PublicationDetail detail : publications) {
            UserIdCountVolumeCouple myCouple = new UserIdCountVolumeCouple();
            myCouple.setUserId(detail.getCreatorId());
            myCouple.setCountVolume(1L);
            myArrayList.add(myCouple);
        }
        return myArrayList;
    }

    private PublicationService getPublicationService() {
        return this.publicationService;
    }

    private Collection<PublicationDetail> getPublications(String componentId) {
        return this.getPublicationService().getAllPublications(componentId);
    }
}

