/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.simple.style;

import org.odftoolkit.odfdom.dom.attribute.fo.FoBreakAfterAttribute;
import org.odftoolkit.odfdom.dom.attribute.fo.FoBreakBeforeAttribute;
import org.odftoolkit.odfdom.dom.element.OdfStyleBase;
import org.odftoolkit.odfdom.dom.element.OdfStylePropertiesBase;
import org.odftoolkit.odfdom.dom.element.style.StyleTablePropertiesElement;
import org.odftoolkit.odfdom.dom.style.props.OdfStylePropertiesSet;

public class TableProperties {
    StyleTablePropertiesElement mElement;

    protected TableProperties() {
    }

    protected TableProperties(StyleTablePropertiesElement properties) {
        this.mElement = properties;
    }

    public void setBreak(String breakPosition, String breakAttribute) {
        if (breakPosition == null) {
            return;
        }
        if (breakAttribute == null) {
            if (breakPosition.equals("before")) {
                this.mElement.removeAttribute(FoBreakBeforeAttribute.ATTRIBUTE_NAME.getQName());
            } else if (breakPosition.equals("after")) {
                this.mElement.removeAttribute(FoBreakAfterAttribute.ATTRIBUTE_NAME.getQName());
            }
        } else if (breakPosition.equals("before")) {
            this.mElement.setFoBreakBeforeAttribute(breakAttribute);
        } else if (breakPosition.equals("after")) {
            this.mElement.setFoBreakAfterAttribute(breakAttribute);
        }
    }

    public String getBreakBefore() {
        return this.mElement.getFoBreakBeforeAttribute();
    }

    public String getBreakAfter() {
        return this.mElement.getFoBreakAfterAttribute();
    }

    public int getPageNumber() {
        try {
            return this.mElement.getStylePageNumberAttribute();
        }
        catch (NullPointerException e) {
            return 0;
        }
    }

    public void setPageNumber(int pageNumber) {
        if (pageNumber > 0) {
            this.mElement.setStylePageNumberAttribute(Integer.valueOf(pageNumber));
        } else {
            this.mElement.removeAttribute("style:page-number");
        }
    }

    public static TableProperties getOrCreateTableProperties(OdfStyleBase style) {
        OdfStylePropertiesBase properties = style.getOrCreatePropertiesElement(OdfStylePropertiesSet.TableProperties);
        return new TableProperties((StyleTablePropertiesElement)properties);
    }

    public static TableProperties getTableProperties(OdfStyleBase style) {
        OdfStylePropertiesBase properties = style.getPropertiesElement(OdfStylePropertiesSet.TableProperties);
        if (properties != null) {
            return new TableProperties((StyleTablePropertiesElement)properties);
        }
        return null;
    }
}

