/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.codecs.StoredFieldsReader;
import org.apache.lucene.codecs.StoredFieldsWriter;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.index.DocumentsWriterPerThread;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.IndexableFieldType;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.index.Sorter;
import org.apache.lucene.index.StoredFieldVisitor;
import org.apache.lucene.index.StoredFieldsConsumer;
import org.apache.lucene.index.TrackingTmpOutputDirectoryWrapper;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.IOUtils;

final class SortingStoredFieldsConsumer
extends StoredFieldsConsumer {
    TrackingTmpOutputDirectoryWrapper tmpDirectory;

    SortingStoredFieldsConsumer(DocumentsWriterPerThread docWriter) {
        super(docWriter);
    }

    @Override
    protected void initStoredFieldsWriter() throws IOException {
        if (this.writer == null) {
            this.tmpDirectory = new TrackingTmpOutputDirectoryWrapper(this.docWriter.directory);
            this.writer = this.docWriter.codec.storedFieldsFormat().fieldsWriter(this.tmpDirectory, this.docWriter.getSegmentInfo(), IOContext.DEFAULT);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void flush(SegmentWriteState state, Sorter.DocMap sortMap) throws IOException {
        super.flush(state, sortMap);
        if (sortMap == null) {
            for (Map.Entry<String, String> entry : this.tmpDirectory.getTemporaryFiles().entrySet()) {
                this.tmpDirectory.rename(entry.getValue(), entry.getKey());
            }
            return;
        }
        StoredFieldsReader reader = this.docWriter.codec.storedFieldsFormat().fieldsReader(this.tmpDirectory, state.segmentInfo, state.fieldInfos, IOContext.DEFAULT);
        StoredFieldsReader mergeReader = reader.getMergeInstance();
        StoredFieldsWriter sortWriter = this.docWriter.codec.storedFieldsFormat().fieldsWriter(state.directory, state.segmentInfo, IOContext.DEFAULT);
        try {
            reader.checkIntegrity();
            CopyVisitor visitor = new CopyVisitor(sortWriter);
            for (int docID = 0; docID < state.segmentInfo.maxDoc(); ++docID) {
                sortWriter.startDocument();
                mergeReader.visitDocument(sortMap.newToOld(docID), visitor);
                sortWriter.finishDocument();
            }
            sortWriter.finish(state.fieldInfos, state.segmentInfo.maxDoc());
        }
        catch (Throwable throwable) {
            IOUtils.close(reader, sortWriter);
            IOUtils.deleteFiles((Directory)this.tmpDirectory, this.tmpDirectory.getTemporaryFiles().values());
            throw throwable;
        }
        IOUtils.close(reader, sortWriter);
        IOUtils.deleteFiles((Directory)this.tmpDirectory, this.tmpDirectory.getTemporaryFiles().values());
    }

    @Override
    void abort() {
        try {
            super.abort();
        }
        finally {
            IOUtils.deleteFilesIgnoringExceptions((Directory)this.tmpDirectory, this.tmpDirectory.getTemporaryFiles().values());
        }
    }

    private static class CopyVisitor
    extends StoredFieldVisitor
    implements IndexableField {
        final StoredFieldsWriter writer;
        BytesRef binaryValue;
        String stringValue;
        Number numericValue;
        FieldInfo currentField;

        CopyVisitor(StoredFieldsWriter writer) {
            this.writer = writer;
        }

        @Override
        public void binaryField(FieldInfo fieldInfo, byte[] value) throws IOException {
            this.reset(fieldInfo);
            this.binaryValue = new BytesRef(value);
            this.write();
        }

        @Override
        public void stringField(FieldInfo fieldInfo, byte[] value) throws IOException {
            this.reset(fieldInfo);
            this.stringValue = new String(value, StandardCharsets.UTF_8);
            this.write();
        }

        @Override
        public void intField(FieldInfo fieldInfo, int value) throws IOException {
            this.reset(fieldInfo);
            this.numericValue = value;
            this.write();
        }

        @Override
        public void longField(FieldInfo fieldInfo, long value) throws IOException {
            this.reset(fieldInfo);
            this.numericValue = value;
            this.write();
        }

        @Override
        public void floatField(FieldInfo fieldInfo, float value) throws IOException {
            this.reset(fieldInfo);
            this.numericValue = Float.valueOf(value);
            this.write();
        }

        @Override
        public void doubleField(FieldInfo fieldInfo, double value) throws IOException {
            this.reset(fieldInfo);
            this.numericValue = value;
            this.write();
        }

        @Override
        public StoredFieldVisitor.Status needsField(FieldInfo fieldInfo) throws IOException {
            return StoredFieldVisitor.Status.YES;
        }

        @Override
        public String name() {
            return this.currentField.name;
        }

        @Override
        public IndexableFieldType fieldType() {
            return StoredField.TYPE;
        }

        @Override
        public BytesRef binaryValue() {
            return this.binaryValue;
        }

        @Override
        public String stringValue() {
            return this.stringValue;
        }

        @Override
        public Number numericValue() {
            return this.numericValue;
        }

        @Override
        public Reader readerValue() {
            return null;
        }

        @Override
        public TokenStream tokenStream(Analyzer analyzer, TokenStream reuse) {
            return null;
        }

        void reset(FieldInfo field) {
            this.currentField = field;
            this.binaryValue = null;
            this.stringValue = null;
            this.numericValue = null;
        }

        void write() throws IOException {
            this.writer.writeField(this.currentField, this);
        }
    }
}

