/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.whitepages.control;

import java.lang.annotation.Annotation;
import java.sql.Connection;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.silverpeas.components.whitepages.WhitePagesException;
import org.silverpeas.components.whitepages.control.WhitePagesContentManager;
import org.silverpeas.components.whitepages.model.Card;
import org.silverpeas.components.whitepages.model.SilverCard;
import org.silverpeas.components.whitepages.model.WhitePagesCard;
import org.silverpeas.components.whitepages.record.UserRecord;
import org.silverpeas.core.WAPrimaryKey;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.admin.user.model.UserDetail;
import org.silverpeas.core.annotation.Service;
import org.silverpeas.core.contribution.content.form.Field;
import org.silverpeas.core.contribution.content.form.FormException;
import org.silverpeas.core.contribution.content.form.RecordSet;
import org.silverpeas.core.contribution.contentcontainer.content.ContentManagementEngine;
import org.silverpeas.core.contribution.contentcontainer.content.ContentManagementEngineProvider;
import org.silverpeas.core.contribution.contentcontainer.content.ContentManagerException;
import org.silverpeas.core.contribution.model.Contribution;
import org.silverpeas.core.contribution.template.publication.PublicationTemplate;
import org.silverpeas.core.contribution.template.publication.PublicationTemplateManager;
import org.silverpeas.core.index.indexing.model.FullIndexEntry;
import org.silverpeas.core.index.indexing.model.IndexEngineProxy;
import org.silverpeas.core.index.indexing.model.IndexEntryKey;
import org.silverpeas.core.pdc.pdc.model.PdcClassification;
import org.silverpeas.core.pdc.pdc.model.PdcException;
import org.silverpeas.core.pdc.pdc.service.PdcManager;
import org.silverpeas.core.persistence.jdbc.DBUtil;
import org.silverpeas.core.persistence.jdbc.bean.BeanCriteria;
import org.silverpeas.core.persistence.jdbc.bean.IdPK;
import org.silverpeas.core.persistence.jdbc.bean.PersistenceException;
import org.silverpeas.core.persistence.jdbc.bean.SilverpeasBeanDAO;
import org.silverpeas.core.persistence.jdbc.bean.SilverpeasBeanDAOFactory;
import org.silverpeas.core.persistence.jdbc.bean.SilverpeasEntityBean;
import org.silverpeas.core.util.DateUtil;
import org.silverpeas.core.util.ServiceProvider;
import org.silverpeas.kernel.logging.SilverLogger;

@Service
public class CardManager {
    private static final String INSTANCE_ID = "instanceId";
    private static final String HIDE_STATUS = "hideStatus";
    private static final String USER_ID = "userId";
    @Inject
    private WhitePagesContentManager contentManager;

    protected CardManager() {
    }

    private WhitePagesContentManager getWhitePagesContentManager() {
        return this.contentManager;
    }

    public static CardManager getInstance() {
        return (CardManager)ServiceProvider.getService(CardManager.class, (Annotation[])new Annotation[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long create(Card card, String creatorId, PdcClassification classification) throws WhitePagesException {
        long id = -1L;
        Connection con = null;
        try {
            SilverpeasBeanDAO<Card> dao = this.getCardDAO();
            con = DBUtil.openConnection();
            con.setAutoCommit(false);
            card.setCreationDate(DateUtil.date2SQLDate((Date)new Date()));
            card.setCreatorId(Integer.parseInt(creatorId));
            WAPrimaryKey pk = dao.add(con, (SilverpeasEntityBean)card);
            id = Long.parseLong(pk.getId());
            card.setPK(pk);
            int silverContentId = this.getWhitePagesContentManager().createSilverContent(con, card);
            this.indexCard(card);
            con.commit();
            if (classification != null && !classification.isEmpty()) {
                SilverCard silverCard = new SilverCard(card, silverContentId);
                classification.classifyContent((Contribution)silverCard);
            }
        }
        catch (Exception e) {
            this.rollback(con, e);
        }
        finally {
            this.closeConnection(con);
        }
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(Collection<String> ids) throws WhitePagesException {
        Connection con = null;
        if (ids != null) {
            try {
                con = DBUtil.openConnection();
                con.setAutoCommit(false);
                SilverpeasBeanDAO<Card> dao = this.getCardDAO();
                IdPK pk = new IdPK();
                String peasId = null;
                for (String id : ids) {
                    pk.setId(id);
                    if (peasId == null) {
                        Card card = this.getCard(Long.parseLong(pk.getId()));
                        if (card == null) continue;
                        peasId = card.getInstanceId();
                    }
                    dao.remove(con, (WAPrimaryKey)pk);
                    pk.setComponentName(peasId);
                    this.getWhitePagesContentManager().deleteSilverContent(con, pk);
                    con.commit();
                    this.deleteIndex((WAPrimaryKey)pk);
                }
            }
            catch (Exception e) {
                this.rollback(con, e);
            }
            finally {
                this.closeConnection(con);
            }
        }
    }

    public Card getCard(long id) throws WhitePagesException {
        Card result;
        IdPK pk = new IdPK();
        try {
            SilverpeasBeanDAO<Card> dao = this.getCardDAO();
            pk.setIdAsLong(id);
            result = (Card)dao.findByPrimaryKey((WAPrimaryKey)pk);
        }
        catch (PersistenceException e) {
            throw new WhitePagesException(e);
        }
        return result;
    }

    public Collection<Card> getCards(String instanceId) throws WhitePagesException {
        return this.getCardsByCondition(BeanCriteria.addCriterion((String)INSTANCE_ID, (Object)instanceId));
    }

    private Collection<Card> getCardsByCondition(BeanCriteria criteria) throws WhitePagesException {
        Collection cards;
        try {
            SilverpeasBeanDAO<Card> dao = this.getCardDAO();
            cards = dao.findBy(criteria);
        }
        catch (PersistenceException e) {
            throw new WhitePagesException(e);
        }
        return cards;
    }

    public Collection<Card> getCardsByIds(List<String> ids) throws WhitePagesException {
        Collection cards;
        try {
            BeanCriteria criteria = ids.isEmpty() ? BeanCriteria.emptyCriteria() : BeanCriteria.addCriterion((String)"id", (Collection)ids.stream().map(Integer::parseInt).collect(Collectors.toSet()));
            SilverpeasBeanDAO<Card> dao = this.getCardDAO();
            cards = dao.findBy(criteria);
        }
        catch (PersistenceException e) {
            throw new WhitePagesException(e);
        }
        return cards;
    }

    public Collection<Card> getVisibleCards(String instanceId) throws WhitePagesException {
        return this.getCardsByCondition(BeanCriteria.addCriterion((String)INSTANCE_ID, (Object)instanceId).and(HIDE_STATUS, (Object)0));
    }

    public List<WhitePagesCard> getUserCards(String userId, Collection<String> instanceIds) throws WhitePagesException {
        BeanCriteria criteria = BeanCriteria.addCriterion((String)USER_ID, (Object)userId).and(HIDE_STATUS, (Object)0);
        if (instanceIds != null && !instanceIds.isEmpty()) {
            criteria.and(INSTANCE_ID, instanceIds);
            return this.getWhitePagesCards(criteria);
        }
        return new ArrayList<WhitePagesCard>();
    }

    public List<WhitePagesCard> getHomeUserCards(String userId, Collection<String> instanceIds, String instanceId) throws WhitePagesException {
        BeanCriteria criteria = BeanCriteria.addCriterion((String)USER_ID, (Object)userId).and(BeanCriteria.addCriterion((String)INSTANCE_ID, (Object)instanceId).or(HIDE_STATUS, (Object)0));
        if (instanceIds != null && !instanceIds.isEmpty()) {
            criteria.and(INSTANCE_ID, instanceIds);
            return this.getWhitePagesCards(criteria);
        }
        return new ArrayList<WhitePagesCard>();
    }

    private List<WhitePagesCard> getWhitePagesCards(BeanCriteria criteria) throws WhitePagesException {
        ArrayList<WhitePagesCard> wpCards = new ArrayList<WhitePagesCard>();
        try {
            SilverpeasBeanDAO<Card> dao = this.getCardDAO();
            Collection cards = dao.findBy(criteria);
            if (cards != null) {
                for (Card card : cards) {
                    wpCards.add(new WhitePagesCard(Long.parseLong(card.getPK().getId()), card.getInstanceId()));
                }
            }
        }
        catch (PersistenceException e) {
            throw new WhitePagesException(e);
        }
        return wpCards;
    }

    public void setHideStatus(Collection<String> ids, int status) throws WhitePagesException {
        if (ids != null) {
            try {
                SilverpeasBeanDAO<Card> dao = this.getCardDAO();
                for (String sId : ids) {
                    long id = Long.parseLong(sId);
                    IdPK pk = new IdPK();
                    pk.setIdAsLong(id);
                    Card card = (Card)dao.findByPrimaryKey((WAPrimaryKey)pk);
                    card.setHideStatus(status);
                    dao.update((SilverpeasEntityBean)card);
                    card.getPK().setComponentName(card.getInstanceId());
                    this.getWhitePagesContentManager().updateSilverContentVisibility(card);
                }
            }
            catch (Exception e) {
                throw new WhitePagesException(e);
            }
        }
    }

    public void reverseHide(Collection<String> ids) throws WhitePagesException {
        if (ids != null) {
            try {
                SilverpeasBeanDAO<Card> dao = this.getCardDAO();
                for (String sId : ids) {
                    long id = Long.parseLong(sId);
                    IdPK pk = new IdPK();
                    pk.setIdAsLong(id);
                    Card card = (Card)dao.findByPrimaryKey((WAPrimaryKey)pk);
                    int status = card.getHideStatus();
                    status = status == 0 ? 1 : 0;
                    card.setHideStatus(status);
                    dao.update((SilverpeasEntityBean)card);
                    card.getPK().setComponentName(card.getInstanceId());
                    this.getWhitePagesContentManager().updateSilverContentVisibility(card);
                }
            }
            catch (Exception e) {
                throw new WhitePagesException(e);
            }
        }
    }

    public boolean existCard(String userId, String instanceId) throws WhitePagesException {
        boolean exist = false;
        try {
            BeanCriteria criteria = BeanCriteria.addCriterion((String)INSTANCE_ID, (Object)instanceId).and(USER_ID, (Object)userId);
            SilverpeasBeanDAO<Card> dao = this.getCardDAO();
            Collection cards = dao.findBy(criteria);
            if (cards != null && !cards.isEmpty()) {
                exist = true;
            }
        }
        catch (PersistenceException e) {
            throw new WhitePagesException(e);
        }
        return exist;
    }

    public boolean isPublicationClassifiedOnPDC(Card card) throws ContentManagerException, PdcException {
        ContentManagementEngine contentMgtEngine = ContentManagementEngineProvider.getContentManagementEngine();
        int contentId = contentMgtEngine.getSilverContentId(card.getPK().getId(), card.getInstanceId());
        PdcManager pdcManager = PdcManager.get();
        List positions = pdcManager.getPositions(contentId, card.getInstanceId());
        return !positions.isEmpty();
    }

    public Card getUserCard(String userId, String instanceId) throws WhitePagesException {
        Card card = null;
        try {
            SilverpeasBeanDAO<Card> dao = this.getCardDAO();
            BeanCriteria criteria = BeanCriteria.addCriterion((String)INSTANCE_ID, (Object)instanceId).and(USER_ID, (Object)userId);
            Collection cards = dao.findBy(criteria);
            if (cards != null && !cards.isEmpty()) {
                card = (Card)((Object)cards.iterator().next());
            }
        }
        catch (PersistenceException e) {
            throw new WhitePagesException(e);
        }
        return card;
    }

    public void indexCard(Card card) {
        WAPrimaryKey pk = card.getPK();
        String userName = this.extractUserName(card);
        String userMail = this.extractUserMail(card);
        FullIndexEntry indexEntry = new FullIndexEntry(new IndexEntryKey(card.getInstanceId(), "card", pk.getId()));
        indexEntry.setTitle(userName);
        indexEntry.setKeywords(userName);
        indexEntry.setPreview(userMail);
        try {
            indexEntry.setCreationDate(DateUtil.parse((String)card.getCreationDate()));
        }
        catch (ParseException e) {
            SilverLogger.getLogger((Object)this).warn((Throwable)e);
        }
        indexEntry.setCreationUser(Integer.toString(card.getCreatorId()));
        try {
            PublicationTemplate pub = PublicationTemplateManager.getInstance().getPublicationTemplate(card.getInstanceId());
            String xmlFormShortName = pub.getFileName().substring(pub.getFileName().indexOf("/") + 1, pub.getFileName().indexOf("."));
            RecordSet set = pub.getRecordSet();
            set.indexRecord(pk.getId(), xmlFormShortName, indexEntry);
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error("User card indexation failure", (Throwable)e);
        }
        IndexEngineProxy.addIndexEntry((FullIndexEntry)indexEntry);
    }

    private void deleteIndex(WAPrimaryKey pk) {
        IndexEngineProxy.removeIndexEntry((IndexEntryKey)new IndexEntryKey(pk.getComponentName(), "card", pk.getId()));
    }

    private String extractUserName(Card card) {
        StringBuilder text = new StringBuilder();
        UserRecord user = card.readUserRecord();
        if (user != null) {
            Field f;
            try {
                f = user.getField("FirstName");
                text.append(f.getStringValue());
                text.append(" ");
            }
            catch (FormException e) {
                SilverLogger.getLogger((Object)this).warn((Throwable)e);
            }
            try {
                f = user.getField("LastName");
                text.append(f.getStringValue());
            }
            catch (FormException e) {
                SilverLogger.getLogger((Object)this).warn((Throwable)e);
            }
        }
        return text.toString();
    }

    private String extractUserMail(Card card) {
        StringBuilder text = new StringBuilder();
        UserRecord record = card.readUserRecord();
        if (record != null) {
            User user = record.getUserDetail();
            if (user instanceof UserDetail && ((UserDetail)user).hasSensitiveData()) {
                return text.toString();
            }
            try {
                Field f = record.getField("Mail");
                text.append(f.getStringValue());
            }
            catch (FormException e) {
                SilverLogger.getLogger((Object)this).warn((Throwable)e);
            }
        }
        return text.toString();
    }

    private void rollback(Connection con, Exception e) throws WhitePagesException {
        try {
            con.rollback();
        }
        catch (Exception e1) {
            throw new WhitePagesException(e1);
        }
        throw new WhitePagesException(e);
    }

    private void closeConnection(Connection con) throws WhitePagesException {
        if (con != null) {
            try {
                con.close();
            }
            catch (SQLException e) {
                throw new WhitePagesException(e);
            }
        }
    }

    private SilverpeasBeanDAO<Card> getCardDAO() throws PersistenceException {
        return SilverpeasBeanDAOFactory.getDAO(Card.class);
    }
}

