/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.simple.common.navigation;

import java.io.InputStream;
import java.net.URI;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.odftoolkit.odfdom.dom.OdfDocumentNamespace;
import org.odftoolkit.odfdom.dom.OdfSchemaDocument;
import org.odftoolkit.odfdom.dom.element.draw.DrawFrameElement;
import org.odftoolkit.odfdom.dom.element.draw.DrawImageElement;
import org.odftoolkit.odfdom.dom.element.text.TextSElement;
import org.odftoolkit.odfdom.pkg.OdfElement;
import org.odftoolkit.odfdom.pkg.OdfFileDom;
import org.odftoolkit.odfdom.pkg.manifest.OdfFileEntry;
import org.odftoolkit.simple.common.TextExtractor;
import org.odftoolkit.simple.common.navigation.InvalidNavigationException;
import org.odftoolkit.simple.common.navigation.Selection;
import org.odftoolkit.simple.common.navigation.TextNavigation;
import org.odftoolkit.simple.common.navigation.TextSelection;
import org.odftoolkit.simple.draw.Image;
import org.odftoolkit.simple.style.StyleTypeDefinitions;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ImageSelection
extends Selection {
    private TextSelection textSelection;
    private DrawFrameElement imageContainer;
    private boolean mIsInserted;

    public Image replaceWithImage(Image image) {
        Image mImage = null;
        if (this.search instanceof TextNavigation) {
            TextNavigation textSearch = (TextNavigation)this.search;
            int leftLength = this.textSelection.getText().length();
            int index = this.textSelection.getIndex();
            this.mIsInserted = false;
            OdfElement parentElement = this.textSelection.getContainerElement();
            OdfFileDom ownerDom = (OdfFileDom)parentElement.getOwnerDocument();
            int nodeLength = TextExtractor.getText(this.textSelection.getContainerElement()).length();
            if (this.textSelection.getText().length() != nodeLength) {
                this.textSelection.setSelectionReplaced(true);
            }
            try {
                if (this.imageContainer == null) {
                    this.delete(index, leftLength, (Node)parentElement);
                    this.imageContainer = (DrawFrameElement)ownerDom.newOdfElement(DrawFrameElement.class);
                    this.insertOdfElement((OdfElement)this.imageContainer, index, (Node)parentElement);
                } else {
                    NodeList nodeImages = this.imageContainer.getElementsByTagName("draw:image");
                    Node nodeImage = nodeImages.item(0);
                    DrawImageElement im = (DrawImageElement)nodeImage;
                    Image oldimage = Image.getInstanceof(im);
                    oldimage.remove();
                    this.imageContainer = (DrawFrameElement)ownerDom.newOdfElement(DrawFrameElement.class);
                    this.insertOdfElement((OdfElement)this.imageContainer, index, (Node)parentElement);
                }
                DrawImageElement imageElement = this.imageContainer.newDrawImageElement();
                InputStream is = image.getImageInputStream();
                String internalPath = image.getInternalPath();
                String mediaType = OdfFileEntry.getMediaTypeString((String)internalPath);
                OdfSchemaDocument mOdfSchemaDoc = (OdfSchemaDocument)ownerDom.getDocument();
                String packagePath = Image.getPackagePath(mOdfSchemaDoc, internalPath);
                mOdfSchemaDoc.getPackage().insert(is, packagePath, mediaType);
                packagePath = packagePath.replaceFirst(ownerDom.getDocument().getDocumentPath(), "");
                Image.configureInsertedImage((OdfSchemaDocument)ownerDom.getDocument(), imageElement, packagePath, false);
                mImage = Image.getInstanceof(imageElement);
                mImage.getStyleHandler().setAchorType(StyleTypeDefinitions.AnchorType.AS_CHARACTER);
                mImage.setName("replace" + System.currentTimeMillis());
            }
            catch (Exception e) {
                Logger.getLogger(ImageSelection.class.getName()).log(Level.SEVERE, e.getMessage(), e);
            }
        }
        return mImage;
    }

    public Image replaceWithImage(URI imageUri) {
        Image mImage = null;
        if (this.search instanceof TextNavigation) {
            TextNavigation textSearch = (TextNavigation)this.search;
            int leftLength = this.textSelection.getText().length();
            int index = this.textSelection.getIndex();
            this.mIsInserted = false;
            OdfElement parentElement = this.textSelection.getContainerElement();
            OdfFileDom ownerDom = (OdfFileDom)parentElement.getOwnerDocument();
            int nodeLength = TextExtractor.getText(this.textSelection.getContainerElement()).length();
            if (this.textSelection.getText().length() != nodeLength) {
                this.textSelection.setSelectionReplaced(true);
            }
            try {
                if (this.imageContainer == null) {
                    this.delete(index, leftLength, (Node)parentElement);
                    this.imageContainer = (DrawFrameElement)ownerDom.newOdfElement(DrawFrameElement.class);
                    this.insertOdfElement((OdfElement)this.imageContainer, index, (Node)parentElement);
                } else {
                    NodeList nodeImages = this.imageContainer.getElementsByTagName("draw:image");
                    Node nodeImage = nodeImages.item(0);
                    DrawImageElement im = (DrawImageElement)nodeImage;
                    Image oldimage = Image.getInstanceof(im);
                    oldimage.remove();
                    this.imageContainer = (DrawFrameElement)ownerDom.newOdfElement(DrawFrameElement.class);
                    this.insertOdfElement((OdfElement)this.imageContainer, index, (Node)parentElement);
                }
                DrawImageElement imageElement = this.imageContainer.newDrawImageElement();
                String imageRef = imageUri.toString();
                String mediaType = OdfFileEntry.getMediaTypeString((String)imageRef);
                OdfSchemaDocument mOdfSchemaDoc = (OdfSchemaDocument)ownerDom.getDocument();
                String packagePath = Image.getPackagePath(mOdfSchemaDoc, imageRef);
                mOdfSchemaDoc.getPackage().insert(imageUri, packagePath, mediaType);
                packagePath = packagePath.replaceFirst(ownerDom.getDocument().getDocumentPath(), "");
                Image.configureInsertedImage((OdfSchemaDocument)ownerDom.getDocument(), imageElement, packagePath, false);
                mImage = Image.getInstanceof(imageElement);
                mImage.getStyleHandler().setAchorType(StyleTypeDefinitions.AnchorType.AS_CHARACTER);
                mImage.setName("replace" + System.currentTimeMillis());
            }
            catch (Exception e) {
                Logger.getLogger(ImageSelection.class.getName()).log(Level.SEVERE, e.getMessage(), e);
            }
        }
        return mImage;
    }

    private void delete(int fromIndex, int leftLength, Node pNode) {
        if (fromIndex == 0 && leftLength == 0) {
            return;
        }
        int nodeLength = 0;
        for (Node node = pNode.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (fromIndex == 0 && leftLength == 0) {
                return;
            }
            if (node.getNodeType() == 3) {
                nodeLength = node.getNodeValue().length();
            } else if (node.getNodeType() == 1) {
                if (node.getLocalName().equals("s")) {
                    try {
                        nodeLength = Integer.parseInt(((Element)node).getAttributeNS(OdfDocumentNamespace.TEXT.getUri(), "c"));
                    }
                    catch (Exception e) {
                        nodeLength = 1;
                    }
                } else {
                    nodeLength = node.getLocalName().equals("line-break") ? 1 : (node.getLocalName().equals("tab") ? 1 : TextExtractor.getText((OdfElement)node).length());
                }
            }
            if (nodeLength <= fromIndex) {
                fromIndex -= nodeLength;
                continue;
            }
            if (node.getNodeType() == 3) {
                String value = node.getNodeValue();
                StringBuffer buffer = new StringBuffer();
                buffer.append(value.substring(0, fromIndex));
                int endLength = fromIndex + leftLength;
                int nextLength = value.length() - endLength;
                fromIndex = 0;
                if (nextLength >= 0) {
                    buffer.append(value.substring(endLength, value.length()));
                    leftLength = 0;
                } else {
                    leftLength = endLength - value.length();
                }
                node.setNodeValue(buffer.toString());
                continue;
            }
            if (node.getNodeType() != 1) continue;
            if (node.getLocalName().equals("s")) {
                ((TextSElement)node).setTextCAttribute(new Integer(nodeLength - fromIndex));
                leftLength -= nodeLength - fromIndex;
                fromIndex = 0;
                continue;
            }
            if (node.getLocalName().equals("line-break") || node.getLocalName().equals("tab")) {
                fromIndex = 0;
                --leftLength;
                continue;
            }
            this.delete(fromIndex, leftLength, node);
            int length = fromIndex + leftLength - nodeLength;
            leftLength = length > 0 ? length : 0;
            fromIndex = 0;
        }
    }

    public ImageSelection(TextSelection selection) {
        this.textSelection = selection;
        this.search = this.textSelection.getTextNavigation();
        this.imageContainer = null;
    }

    @Override
    public void cut() throws InvalidNavigationException {
        this.textSelection.cut();
    }

    @Override
    public void pasteAtEndOf(Selection positionItem) throws InvalidNavigationException {
        this.textSelection.pasteAtEndOf(positionItem);
    }

    @Override
    public void pasteAtFrontOf(Selection positionItem) throws InvalidNavigationException {
        this.textSelection.pasteAtFrontOf(positionItem);
    }

    @Override
    protected void refresh(int offset) {
        this.textSelection.refresh(offset);
    }

    @Override
    protected void refreshAfterFrontalDelete(Selection deletedItem) {
        this.textSelection.refreshAfterFrontalDelete(deletedItem);
    }

    @Override
    protected void refreshAfterFrontalInsert(Selection insertedItem) {
        this.textSelection.refreshAfterFrontalInsert(insertedItem);
    }

    private void insertOdfElement(OdfElement odfElement, int fromIndex, Node pNode) {
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        if (fromIndex == 0 && this.mIsInserted) {
            return;
        }
        int nodeLength = 0;
        for (Node node = pNode.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (fromIndex <= 0 && this.mIsInserted) {
                return;
            }
            if (node.getNodeType() == 3) {
                nodeLength = node.getNodeValue().length();
                if (fromIndex != 0 && nodeLength < fromIndex) {
                    fromIndex -= nodeLength;
                    continue;
                }
                String value = node.getNodeValue();
                StringBuffer buffer = new StringBuffer();
                buffer.append(value.substring(0, fromIndex));
                node.setNodeValue(buffer.toString());
                Node nextNode = node.getNextSibling();
                Node parNode = node.getParentNode();
                Node newNode = node.cloneNode(true);
                newNode.setNodeValue(value.substring(fromIndex, value.length()));
                if (nextNode != null) {
                    parNode.insertBefore((Node)odfElement, nextNode);
                    parNode.insertBefore(newNode, nextNode);
                } else {
                    parNode.appendChild((Node)odfElement);
                    parNode.appendChild(newNode);
                }
                this.mIsInserted = true;
                return;
            }
            if (node.getNodeType() != 1) continue;
            if (node.getLocalName().equals("s")) {
                try {
                    nodeLength = Integer.parseInt(((Element)node).getAttributeNS(OdfDocumentNamespace.TEXT.getUri(), "c"));
                }
                catch (Exception e) {
                    nodeLength = 1;
                }
                fromIndex -= nodeLength;
                continue;
            }
            if (node.getLocalName().equals("line-break")) {
                nodeLength = 1;
                --fromIndex;
                continue;
            }
            if (node.getLocalName().equals("tab")) {
                nodeLength = 1;
                --fromIndex;
                continue;
            }
            nodeLength = TextExtractor.getText((OdfElement)node).length();
            this.insertOdfElement(odfElement, fromIndex, node);
            fromIndex -= nodeLength;
        }
    }
}

