/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.kmelia;

import org.silverpeas.components.kmelia.service.KmeliaHelper;
import org.silverpeas.core.admin.service.OrganizationControllerProvider;
import org.silverpeas.core.admin.user.model.SilverpeasRole;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.node.model.NodePK;
import org.silverpeas.kernel.util.StringUtil;

public class KmeliaPublicationHelper {
    private KmeliaPublicationHelper() {
    }

    public static boolean isUserConsideredAsOwner(String instanceId, String currentUserId, String profile, User ownerDetail) {
        if (KmeliaPublicationHelper.hasWritePrivilege(currentUserId, profile, ownerDetail)) {
            return true;
        }
        if ("writer".equals(profile)) {
            return StringUtil.getBooleanValue((String)KmeliaPublicationHelper.getParameterValue(instanceId, "coWriting"));
        }
        return false;
    }

    public static boolean isRemovable(String instanceId, String currentUserId, String profile, User ownerDetail) {
        if (KmeliaPublicationHelper.hasWritePrivilege(currentUserId, profile, ownerDetail)) {
            boolean removeOnlyForAdmin = StringUtil.getBooleanValue((String)KmeliaPublicationHelper.getParameterValue(instanceId, "suppressionOnlyForAdmin"));
            return !removeOnlyForAdmin || SilverpeasRole.ADMIN.getName().equals(profile);
        }
        return false;
    }

    public static boolean isCanBeCut(String instanceId, String currentUserId, String profile, User ownerDetail) {
        return !KmeliaHelper.isKmax(instanceId) && KmeliaPublicationHelper.isUserConsideredAsOwner(instanceId, currentUserId, profile, ownerDetail);
    }

    public static boolean isCreationAllowed(NodePK pk, String profile) {
        boolean publicationsInTopic = !pk.isRoot() || pk.isRoot() && (KmeliaPublicationHelper.isPublicationsOnRootAllowed(pk.getInstanceId()) || !KmeliaPublicationHelper.isTreeEnabled(pk.getInstanceId()));
        return !SilverpeasRole.USER.isInRole(new String[]{profile}) && publicationsInTopic;
    }

    public static boolean isPublicationsOnRootAllowed(String instanceId) {
        String parameterValue = KmeliaPublicationHelper.getParameterValue(instanceId, "nbPubliOnRoot");
        if (StringUtil.isDefined((String)parameterValue)) {
            return Integer.parseInt(parameterValue) == 0;
        }
        return true;
    }

    public static boolean isTreeEnabled(String instanceId) {
        String param = KmeliaPublicationHelper.getParameterValue(instanceId, "istree");
        if (!StringUtil.isDefined((String)param)) {
            return true;
        }
        return "0".equals(param) || "1".equals(param);
    }

    private static String getParameterValue(String instanceId, String name) {
        return OrganizationControllerProvider.getOrganisationController().getComponentParameterValue(instanceId, name);
    }

    private static boolean hasWritePrivilege(String currentUserId, String profile, User owner) {
        SilverpeasRole role = SilverpeasRole.fromString((String)profile);
        return role == SilverpeasRole.ADMIN || role == SilverpeasRole.PUBLISHER || role == SilverpeasRole.SUPERVISOR || owner != null && currentUserId.equals(owner.getId()) && role == SilverpeasRole.WRITER;
    }
}

