/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.tree.impl;

import java.util.Collections;
import org.apache.jackrabbit.guava.common.base.Preconditions;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class HiddenTree
implements Tree {
    private final Tree parent;
    private final String name;

    HiddenTree(Tree parent, String name) {
        this.parent = parent;
        this.name = name;
    }

    public String toString() {
        return this.getPath() + ": {}";
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    public boolean isRoot() {
        return false;
    }

    @NotNull
    public String getPath() {
        return PathUtils.concat((String)this.parent.getPath(), (String)this.name);
    }

    @NotNull
    public Tree.Status getStatus() {
        return Tree.Status.UNCHANGED;
    }

    public boolean exists() {
        return false;
    }

    @NotNull
    public Tree getParent() {
        return this.parent;
    }

    @Nullable
    public PropertyState getProperty(@NotNull String name) {
        return null;
    }

    @Nullable
    public Tree.Status getPropertyStatus(@NotNull String name) {
        return null;
    }

    public boolean hasProperty(@NotNull String name) {
        return false;
    }

    public long getPropertyCount() {
        return 0L;
    }

    @NotNull
    public Iterable<? extends PropertyState> getProperties() {
        return Collections.emptyList();
    }

    @NotNull
    public Tree getChild(@NotNull String name) {
        return new HiddenTree(this, (String)Preconditions.checkNotNull((Object)name));
    }

    public boolean hasChild(@NotNull String name) {
        return false;
    }

    public long getChildrenCount(long max) {
        return 0L;
    }

    @NotNull
    public Iterable<Tree> getChildren() {
        return Collections.emptyList();
    }

    public boolean remove() {
        return false;
    }

    @NotNull
    public Tree addChild(@NotNull String name) {
        throw HiddenTree.nonExistingTree();
    }

    public void setOrderableChildren(boolean enable) {
        throw HiddenTree.nonExistingTree();
    }

    public boolean orderBefore(@Nullable String name) {
        throw HiddenTree.nonExistingTree();
    }

    public void setProperty(@NotNull PropertyState property) {
        throw HiddenTree.nonExistingTree();
    }

    public <T> void setProperty(@NotNull String name, @NotNull T value) {
        throw HiddenTree.nonExistingTree();
    }

    public <T> void setProperty(@NotNull String name, @NotNull T value, @NotNull Type<T> type) {
        throw HiddenTree.nonExistingTree();
    }

    public void removeProperty(@NotNull String name) {
        throw HiddenTree.nonExistingTree();
    }

    private static IllegalStateException nonExistingTree() {
        return new IllegalStateException("This tree does not exist");
    }
}

