/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.quickinfo.socialnetwork;

import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.silverpeas.components.quickinfo.model.News;
import org.silverpeas.components.quickinfo.model.QuickInfoServiceProvider;
import org.silverpeas.core.admin.service.OrganizationController;
import org.silverpeas.core.admin.service.OrganizationControllerProvider;
import org.silverpeas.core.annotation.Provider;
import org.silverpeas.core.comment.service.CommentServiceProvider;
import org.silverpeas.core.comment.socialnetwork.SocialInformationComment;
import org.silverpeas.core.date.Period;
import org.silverpeas.core.socialnetwork.model.SocialInformation;
import org.silverpeas.core.socialnetwork.provider.SocialNewsCommentProvider;
import org.silverpeas.core.util.URLUtil;

@Provider
public class SocialQuickInfoComment
implements SocialNewsCommentProvider {
    private List<String> getListResourceType() {
        ArrayList<String> listResourceType = new ArrayList<String>();
        listResourceType.add(News.getResourceType());
        return listResourceType;
    }

    private List<SocialInformation> decorate(List<SocialInformationComment> listSocialInformation) {
        for (SocialInformationComment socialInformation : listSocialInformation) {
            String resourceId = socialInformation.getComment().getResourceReference().getLocalId();
            News news = QuickInfoServiceProvider.getQuickInfoService().getNews(resourceId);
            socialInformation.setUrl(URLUtil.getSimpleURL((int)2, (String)news.getPublicationId(), (String)news.getComponentInstanceId(), (boolean)false));
            socialInformation.setTitle(news.getTitle());
        }
        return listSocialInformation;
    }

    public List<SocialInformation> getSocialInformationList(String userId, Date begin, Date end) {
        List listSocialInformation = CommentServiceProvider.getCommentService().getSocialInformationCommentsListByUserId(this.getListResourceType(), userId, Period.between((Instant)begin.toInstant(), (Instant)end.toInstant()));
        return this.decorate(listSocialInformation);
    }

    public List<SocialInformation> getSocialInformationListOfMyContacts(String myId, List<String> myContactsIds, Date begin, Date end) {
        OrganizationController oc = OrganizationControllerProvider.getOrganisationController();
        ArrayList<String> instanceIds = new ArrayList<String>();
        instanceIds.addAll(Arrays.asList(oc.getComponentIdsForUser(myId, "quickinfo")));
        List listSocialInformation = CommentServiceProvider.getCommentService().getSocialInformationCommentsListOfMyContacts(this.getListResourceType(), myContactsIds, instanceIds, Period.between((Instant)begin.toInstant(), (Instant)end.toInstant()));
        return this.decorate(listSocialInformation);
    }
}

