/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.comment.dao.jdbc;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import org.silverpeas.core.ResourceReference;
import org.silverpeas.core.annotation.Repository;
import org.silverpeas.core.comment.dao.CommentDAO;
import org.silverpeas.core.comment.dao.jdbc.JDBCCommentRequester;
import org.silverpeas.core.comment.model.Comment;
import org.silverpeas.core.comment.model.CommentId;
import org.silverpeas.core.comment.model.CommentedPublicationInfo;
import org.silverpeas.core.comment.socialnetwork.SocialInformationComment;
import org.silverpeas.core.date.Period;
import org.silverpeas.core.persistence.jdbc.DBUtil;
import org.silverpeas.kernel.SilverpeasRuntimeException;
import org.silverpeas.kernel.util.StringUtil;

@Repository
@Named(value="commentDAO")
public class JDBCCommentDAO
implements CommentDAO {
    protected static final long serialVersionUID = -4880326368611108874L;
    private static final String IN_COMPONENT_INSTANCE = " in component instance ";
    @Inject
    private JDBCCommentRequester theRequester;

    private JDBCCommentRequester getRequester() {
        return this.theRequester;
    }

    @Override
    public Comment saveComment(Comment cmt) {
        Comment comment;
        block9: {
            Connection con = DBUtil.openConnection();
            try {
                JDBCCommentRequester requester = this.getRequester();
                Comment comment2 = requester.saveComment(con, cmt);
                if (comment2 == null) {
                    throw new SilverpeasRuntimeException("Cannot save comment for resource " + cmt.getResourceReference().getLocalId() + " of type " + cmt.getResourceType() + IN_COMPONENT_INSTANCE + cmt.getComponentInstanceId());
                }
                comment = comment2;
                if (con == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (con != null) {
                        try {
                            con.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception re) {
                    throw new SilverpeasRuntimeException(re.getMessage(), (Throwable)re);
                }
            }
            con.close();
        }
        return comment;
    }

    @Override
    public void removeComment(CommentId commentId) {
        try (Connection con = DBUtil.openConnection();){
            JDBCCommentRequester requester = this.getRequester();
            requester.deleteComment(con, commentId);
        }
        catch (Exception re) {
            throw new SilverpeasRuntimeException(re.getMessage(), (Throwable)re);
        }
    }

    @Override
    public void updateComment(Comment cmt) {
        try (Connection con = DBUtil.openConnection();){
            JDBCCommentRequester requester = this.getRequester();
            requester.updateComment(con, cmt);
        }
        catch (Exception re) {
            throw new SilverpeasRuntimeException(re.getMessage(), (Throwable)re);
        }
    }

    @Override
    public Comment getComment(CommentId commentId) {
        Comment comment;
        block9: {
            Connection con = DBUtil.openConnection();
            try {
                JDBCCommentRequester requester = this.getRequester();
                Comment comment2 = requester.getComment(con, commentId);
                if (comment2 == null) {
                    throw new SilverpeasRuntimeException("Cannot get comment " + commentId.getLocalId() + IN_COMPONENT_INSTANCE + commentId.getComponentInstanceId());
                }
                comment = comment2;
                if (con == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (con != null) {
                        try {
                            con.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception re) {
                    throw new SilverpeasRuntimeException(re.getMessage(), (Throwable)re);
                }
            }
            con.close();
        }
        return comment;
    }

    @Override
    public List<CommentedPublicationInfo> getAllMostCommentedPublications() {
        List<CommentedPublicationInfo> list;
        block8: {
            Connection con = DBUtil.openConnection();
            try {
                JDBCCommentRequester requester = this.getRequester();
                list = requester.getMostCommentedAllPublications(con, null);
                if (con == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (con != null) {
                        try {
                            con.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new SilverpeasRuntimeException(e.getMessage(), (Throwable)e);
                }
            }
            con.close();
        }
        return list;
    }

    @Override
    public List<CommentedPublicationInfo> getMostCommentedPublications(String resourceType, List<ResourceReference> resourceRefs) {
        List<Object> commentedPubs = null;
        JDBCCommentRequester requester = this.getRequester();
        if (resourceRefs != null && !resourceRefs.isEmpty()) {
            try (Connection con = DBUtil.openConnection();){
                commentedPubs = requester.getMostCommentedPublications(con, resourceRefs);
            }
            catch (Exception e) {
                throw new SilverpeasRuntimeException(e.getMessage(), (Throwable)e);
            }
        }
        return commentedPubs == null ? new ArrayList() : commentedPubs;
    }

    @Override
    public int getCommentsCountByForeignKey(String resourceType, ResourceReference resourceRef) {
        int n;
        block8: {
            Connection con = DBUtil.openConnection();
            try {
                JDBCCommentRequester requester = this.getRequester();
                n = requester.getCommentsCount(con, resourceType, resourceRef);
                if (con == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (con != null) {
                        try {
                            con.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new SilverpeasRuntimeException(e.getMessage(), (Throwable)e);
                }
            }
            con.close();
        }
        return n;
    }

    @Override
    public Map<ResourceReference, Integer> getCommentCountIndexedByResource(String resourceType, String instanceId) {
        Map<ResourceReference, Integer> map;
        block8: {
            Connection con = DBUtil.openConnection();
            try {
                JDBCCommentRequester requester = this.getRequester();
                map = requester.getCommentCountIndexedByResource(con, resourceType, instanceId);
                if (con == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (con != null) {
                        try {
                            con.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new SilverpeasRuntimeException(e.getMessage(), (Throwable)e);
                }
            }
            con.close();
        }
        return map;
    }

    @Override
    public List<Comment> getAllCommentsByForeignKey(String resourceType, ResourceReference resourceRef) {
        List<Comment> list;
        block9: {
            Connection con = DBUtil.openConnection();
            try {
                JDBCCommentRequester requester = this.getRequester();
                List<Comment> vRet = requester.getAllComments(con, resourceType, resourceRef);
                if (vRet == null) {
                    throw new SilverpeasRuntimeException("Cannot get all comments for resource " + resourceRef.getLocalId() + " of type " + resourceType + IN_COMPONENT_INSTANCE + resourceRef.getComponentInstanceId());
                }
                list = vRet;
                if (con == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (con != null) {
                        try {
                            con.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new SilverpeasRuntimeException(e.getMessage(), (Throwable)e);
                }
            }
            con.close();
        }
        return list;
    }

    @Override
    public void removeAllCommentsByForeignPk(String resourceType, ResourceReference resourceRef) {
        try (Connection con = DBUtil.openConnection();){
            JDBCCommentRequester requester = this.getRequester();
            requester.deleteAllComments(con, resourceType, resourceRef);
        }
        catch (Exception e) {
            throw new SilverpeasRuntimeException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void moveComments(String resourceType, ResourceReference fromPK, ResourceReference toPK) {
        this.moveComments(resourceType, fromPK, resourceType, toPK);
    }

    @Override
    public void moveComments(String fromResourceType, ResourceReference fromPK, String toResourceType, ResourceReference toPK) {
        try (Connection con = DBUtil.openConnection();){
            JDBCCommentRequester requester = this.getRequester();
            requester.moveComments(con, fromResourceType, fromPK, toResourceType, toPK);
        }
        catch (Exception e) {
            throw new SilverpeasRuntimeException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public List<CommentedPublicationInfo> getMostCommentedPublications(String resourceType) {
        List<CommentedPublicationInfo> list;
        block8: {
            Connection con = DBUtil.openConnection();
            try {
                JDBCCommentRequester requester = this.getRequester();
                list = requester.getMostCommentedAllPublications(con, resourceType);
                if (con == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (con != null) {
                        try {
                            con.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new SilverpeasRuntimeException(e.getMessage(), (Throwable)e);
                }
            }
            con.close();
        }
        return list;
    }

    @Override
    public List<Comment> getLastComments(String instanceId, int count) {
        List<Comment> list;
        block8: {
            Connection con = DBUtil.openConnection();
            try {
                JDBCCommentRequester requester = this.getRequester();
                list = requester.getLastComments(con, instanceId, count);
                if (con == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (con != null) {
                        try {
                            con.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new SilverpeasRuntimeException(e.getMessage(), (Throwable)e);
                }
            }
            con.close();
        }
        return list;
    }

    @Override
    public List<SocialInformationComment> getSocialInformationCommentsListByUserId(List<String> resourceTypes, String userId, Period period) {
        List<SocialInformationComment> list;
        block8: {
            Connection con = DBUtil.openConnection();
            try {
                JDBCCommentRequester requester = this.getRequester();
                list = requester.getSocialInformationComments(con, resourceTypes, StringUtil.isDefined((String)userId) ? Collections.singletonList(userId) : null, null, period);
                if (con == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (con != null) {
                        try {
                            con.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new SilverpeasRuntimeException(e.getMessage(), (Throwable)e);
                }
            }
            con.close();
        }
        return list;
    }

    @Override
    public List<SocialInformationComment> getSocialInformationCommentsListOfMyContacts(List<String> resourceTypes, List<String> myContactsIds, List<String> instanceIds, Period period) {
        List<SocialInformationComment> list;
        block8: {
            Connection con = DBUtil.openConnection();
            try {
                JDBCCommentRequester requester = this.getRequester();
                list = requester.getSocialInformationComments(con, resourceTypes, myContactsIds, instanceIds, period);
                if (con == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (con != null) {
                        try {
                            con.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new SilverpeasRuntimeException(e.getMessage(), (Throwable)e);
                }
            }
            con.close();
        }
        return list;
    }
}

