/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.simple.common.field;

import org.odftoolkit.odfdom.dom.element.text.TextPageCountElement;
import org.odftoolkit.odfdom.dom.element.text.TextSpanElement;
import org.odftoolkit.odfdom.pkg.OdfElement;
import org.odftoolkit.odfdom.pkg.OdfFileDom;
import org.odftoolkit.simple.Component;
import org.odftoolkit.simple.Document;
import org.odftoolkit.simple.common.field.Field;
import org.odftoolkit.simple.meta.Meta;
import org.odftoolkit.simple.style.NumberFormat;
import org.w3c.dom.Node;

public class PageCountField
extends Field {
    private TextPageCountElement pageCountElement;

    PageCountField(OdfElement odfElement) {
        TextSpanElement spanElement = (TextSpanElement)((OdfFileDom)odfElement.getOwnerDocument()).newOdfElement(TextSpanElement.class);
        odfElement.appendChild((Node)spanElement);
        this.pageCountElement = spanElement.newTextPageCountElement(null);
        try {
            OdfFileDom dom = (OdfFileDom)odfElement.getOwnerDocument();
            Meta meta = ((Document)dom.getDocument()).getOfficeMetadata();
            int count = meta.getDocumentStatistic().getPageCount();
            this.pageCountElement.setTextContent(String.valueOf(count));
        }
        catch (Exception exception) {
            // empty catch block
        }
        Component.registerComponent(this, (OdfElement)this.getOdfElement());
    }

    public void setNumberFormat(NumberFormat format) {
        this.pageCountElement.setStyleNumFormatAttribute(format.toString());
    }

    public TextPageCountElement getOdfElement() {
        return this.pageCountElement;
    }

    @Override
    public Field.FieldType getFieldType() {
        return Field.FieldType.PAGE_COUNT_FIELD;
    }
}

