/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment.compaction;

import org.apache.jackrabbit.guava.common.base.Preconditions;
import org.apache.jackrabbit.oak.commons.jmx.AnnotatedStandardMBean;
import org.apache.jackrabbit.oak.segment.compaction.SegmentGCOptions;
import org.apache.jackrabbit.oak.segment.compaction.SegmentRevisionGC;
import org.apache.jackrabbit.oak.segment.file.FileStore;
import org.apache.jackrabbit.oak.segment.file.FileStoreGCMonitor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SegmentRevisionGCMBean
extends AnnotatedStandardMBean
implements SegmentRevisionGC {
    private static final Logger log = LoggerFactory.getLogger(SegmentRevisionGCMBean.class);
    @NotNull
    private final FileStore fileStore;
    @NotNull
    private final SegmentGCOptions gcOptions;
    @NotNull
    private final FileStoreGCMonitor fileStoreGCMonitor;

    public SegmentRevisionGCMBean(@NotNull FileStore fileStore, @NotNull SegmentGCOptions gcOptions, @NotNull FileStoreGCMonitor fileStoreGCMonitor) {
        super(SegmentRevisionGC.class);
        this.fileStore = (FileStore)Preconditions.checkNotNull((Object)fileStore);
        this.gcOptions = (SegmentGCOptions)Preconditions.checkNotNull((Object)gcOptions);
        this.fileStoreGCMonitor = (FileStoreGCMonitor)Preconditions.checkNotNull((Object)fileStoreGCMonitor);
    }

    @Override
    public boolean isPausedCompaction() {
        return this.gcOptions.isPaused();
    }

    @Override
    public void setPausedCompaction(boolean paused) {
        this.gcOptions.setPaused(paused);
    }

    @Override
    public int getRetryCount() {
        return this.gcOptions.getRetryCount();
    }

    @Override
    public void setRetryCount(int retryCount) {
        this.gcOptions.setRetryCount(retryCount);
    }

    @Override
    public int getForceTimeout() {
        return this.gcOptions.getForceTimeout();
    }

    @Override
    public void setForceTimeout(int timeout) {
        this.gcOptions.setForceTimeout(timeout);
    }

    @Override
    public int getRetainedGenerations() {
        return this.gcOptions.getRetainedGenerations();
    }

    @Override
    public void setRetainedGenerations(int retainedGenerations) {
        if (retainedGenerations != 2) {
            log.warn("The number of retained generations defaults to {} and can't be changed. This configuration option is considered deprecated and will be removed in the future.", (Object)2);
        }
    }

    @Override
    public long getGcSizeDeltaEstimation() {
        return this.gcOptions.getGcSizeDeltaEstimation();
    }

    @Override
    public void setGcSizeDeltaEstimation(long gcSizeDeltaEstimation) {
        this.gcOptions.setGcSizeDeltaEstimation(gcSizeDeltaEstimation);
    }

    @Override
    public boolean isEstimationDisabled() {
        return this.gcOptions.isEstimationDisabled();
    }

    @Override
    public void setEstimationDisabled(boolean disabled) {
        this.gcOptions.setEstimationDisabled(disabled);
    }

    @Override
    public String getGCType() {
        return this.gcOptions.getGCType().toString();
    }

    @Override
    public void setGCType(String gcType) {
        this.gcOptions.setGCType(SegmentGCOptions.GCType.valueOf(gcType));
    }

    @Override
    public void startRevisionGC() {
        this.fileStore.getGCRunner().run();
    }

    @Override
    public void cancelRevisionGC() {
        this.fileStore.cancelGC();
    }

    @Override
    public long getLastCompaction() {
        return this.fileStoreGCMonitor.getLastCompaction();
    }

    @Override
    public long getLastCleanup() {
        return this.fileStoreGCMonitor.getLastCleanup();
    }

    @Override
    public long getLastRepositorySize() {
        return this.fileStoreGCMonitor.getLastRepositorySize();
    }

    @Override
    public long getLastReclaimedSize() {
        return this.fileStoreGCMonitor.getLastReclaimedSize();
    }

    @Override
    @Nullable
    public String getLastError() {
        return this.fileStoreGCMonitor.getLastError();
    }

    @Override
    @NotNull
    public String getLastLogMessage() {
        return this.fileStoreGCMonitor.getLastLogMessage();
    }

    @Override
    @NotNull
    public String getStatus() {
        return this.fileStoreGCMonitor.getStatus();
    }

    @Override
    public int getMemoryThreshold() {
        return this.gcOptions.getMemoryThreshold();
    }

    @Override
    public void setMemoryThreshold(int memoryThreshold) {
        this.gcOptions.setMemoryThreshold(memoryThreshold);
    }

    @Override
    public boolean isRevisionGCRunning() {
        return this.fileStore.getGCNodeWriteMonitor().isCompactionRunning();
    }

    @Override
    public long getCompactedNodes() {
        return this.fileStore.getGCNodeWriteMonitor().getCompactedNodes();
    }

    @Override
    public long getEstimatedCompactableNodes() {
        return this.fileStore.getGCNodeWriteMonitor().getEstimatedTotal();
    }

    @Override
    public int getEstimatedRevisionGCCompletion() {
        return this.fileStore.getGCNodeWriteMonitor().getEstimatedPercentage();
    }

    @Override
    public long getRevisionGCProgressLog() {
        return this.fileStore.getGCNodeWriteMonitor().getGcProgressLog();
    }

    @Override
    public void setRevisionGCProgressLog(long gcProgressLog) {
        this.gcOptions.setGCLogInterval(gcProgressLog);
    }
}

