/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.stats;

import javax.management.openmbean.CompositeData;
import org.apache.jackrabbit.api.stats.RepositoryStatistics;
import org.apache.jackrabbit.api.stats.TimeSeries;
import org.apache.jackrabbit.oak.api.jmx.RepositoryStatsMBean;
import org.apache.jackrabbit.oak.commons.jmx.AnnotatedStandardMBean;
import org.apache.jackrabbit.stats.TimeSeriesStatsUtil;

public class RepositoryStats
extends AnnotatedStandardMBean
implements RepositoryStatsMBean {
    static final String OBSERVATION_QUEUE_MAX_LENGTH = "OBSERVATION_QUEUE_MAX_LENGTH";
    private final RepositoryStatistics repoStats;
    private final TimeSeries maxQueueLength;

    public RepositoryStats(RepositoryStatistics repoStats, TimeSeries maxQueueLength) {
        super(RepositoryStatsMBean.class);
        this.repoStats = repoStats;
        this.maxQueueLength = maxQueueLength;
    }

    public CompositeData getSessionCount() {
        return this.asCompositeData(RepositoryStatistics.Type.SESSION_COUNT);
    }

    public CompositeData getSessionLogin() {
        return this.asCompositeData(RepositoryStatistics.Type.SESSION_LOGIN_COUNTER);
    }

    public CompositeData getSessionReadCount() {
        return this.asCompositeData(RepositoryStatistics.Type.SESSION_READ_COUNTER);
    }

    public CompositeData getSessionReadDuration() {
        return this.asCompositeData(RepositoryStatistics.Type.SESSION_READ_DURATION);
    }

    public CompositeData getSessionReadAverage() {
        return this.asCompositeData(RepositoryStatistics.Type.SESSION_READ_AVERAGE);
    }

    public CompositeData getSessionWriteCount() {
        return this.asCompositeData(RepositoryStatistics.Type.SESSION_WRITE_COUNTER);
    }

    public CompositeData getSessionWriteDuration() {
        return this.asCompositeData(RepositoryStatistics.Type.SESSION_WRITE_DURATION);
    }

    public CompositeData getSessionWriteAverage() {
        return this.asCompositeData(RepositoryStatistics.Type.SESSION_WRITE_AVERAGE);
    }

    public CompositeData getQueryCount() {
        return this.asCompositeData(RepositoryStatistics.Type.QUERY_COUNT);
    }

    public CompositeData getQueryDuration() {
        return this.asCompositeData(RepositoryStatistics.Type.QUERY_DURATION);
    }

    public CompositeData getQueryAverage() {
        return this.asCompositeData(RepositoryStatistics.Type.QUERY_AVERAGE);
    }

    public CompositeData getObservationEventCount() {
        return this.asCompositeData(RepositoryStatistics.Type.OBSERVATION_EVENT_COUNTER);
    }

    public CompositeData getObservationEventDuration() {
        return this.asCompositeData(RepositoryStatistics.Type.OBSERVATION_EVENT_DURATION);
    }

    public CompositeData getObservationEventAverage() {
        return this.asCompositeData(RepositoryStatistics.Type.OBSERVATION_EVENT_AVERAGE);
    }

    public CompositeData getObservationQueueMaxLength() {
        return TimeSeriesStatsUtil.asCompositeData((TimeSeries)this.maxQueueLength, (String)"maximal length of observation queue");
    }

    private TimeSeries getTimeSeries(RepositoryStatistics.Type type) {
        return this.repoStats.getTimeSeries(type);
    }

    private CompositeData asCompositeData(RepositoryStatistics.Type type) {
        return TimeSeriesStatsUtil.asCompositeData((TimeSeries)this.getTimeSeries(type), (String)type.name());
    }
}

