/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document.mongo;

import com.mongodb.ServerAddress;
import com.mongodb.event.ServerHeartbeatSucceededEvent;
import com.mongodb.event.ServerMonitorListenerAdapter;
import java.util.Collection;
import java.util.Date;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.bson.BsonArray;
import org.bson.BsonDocument;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReplicaSetStatus
extends ServerMonitorListenerAdapter {
    private static final Logger LOG = LoggerFactory.getLogger(ReplicaSetStatus.class);
    public static final long UNKNOWN_LAG = Long.MAX_VALUE;
    private final Map<ServerAddress, Heartbeat> heartbeats = new HashMap<ServerAddress, Heartbeat>();
    private final Set<ServerAddress> members = new HashSet<ServerAddress>();
    private final Deque<Long> estimatesPerMember = new LinkedList<Long>();
    private long lagEstimate = Long.MAX_VALUE;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serverHeartbeatSucceeded(ServerHeartbeatSucceededEvent event) {
        Map<ServerAddress, Heartbeat> map = this.heartbeats;
        synchronized (map) {
            ServerAddress address = event.getConnectionId().getServerId().getAddress();
            Heartbeat beat = new Heartbeat(event);
            this.heartbeats.put(address, beat);
            this.members.addAll(beat.getHosts());
            if (!this.members.isEmpty()) {
                this.updateLag();
            }
        }
    }

    public long getLagEstimate() {
        return this.lagEstimate;
    }

    private void updateLag() {
        if (!this.heartbeats.keySet().containsAll(this.members)) {
            this.lagEstimate = Long.MAX_VALUE;
            return;
        }
        long oldestUpdate = Long.MAX_VALUE;
        long newestUpdate = Long.MIN_VALUE;
        long oldestWrite = Long.MAX_VALUE;
        long newestWrite = Long.MIN_VALUE;
        for (Map.Entry<ServerAddress, Heartbeat> entry : this.heartbeats.entrySet()) {
            if (!this.members.contains(entry.getKey())) continue;
            Heartbeat beat = entry.getValue();
            Date lastWrite = beat.getLastWrite();
            if (lastWrite == null) {
                oldestWrite = 0L;
                newestWrite = Long.MAX_VALUE;
            } else {
                oldestWrite = Math.min(oldestWrite, lastWrite.getTime());
                newestWrite = Math.max(newestWrite, lastWrite.getTime());
            }
            long updateTime = beat.getTime();
            oldestUpdate = Math.min(oldestUpdate, updateTime);
            newestUpdate = Math.max(newestUpdate, updateTime);
        }
        long uncertaintyMillis = newestUpdate - oldestUpdate;
        this.estimatesPerMember.addFirst(Math.max(0L, newestWrite - oldestWrite - uncertaintyMillis));
        long estimate = 0L;
        int i = 0;
        Iterator<Long> it = this.estimatesPerMember.iterator();
        while (it.hasNext()) {
            long v = it.next();
            if (i++ < this.members.size()) {
                estimate += v;
                continue;
            }
            it.remove();
        }
        this.lagEstimate = estimate / (long)this.members.size();
        LOG.debug("lagEstimate: {} ms ({})", (Object)this.lagEstimate, this.estimatesPerMember);
    }

    private static List<ServerAddress> hostsFrom(ServerHeartbeatSucceededEvent event) {
        return event.getReply().getArray((Object)"hosts", new BsonArray()).stream().map(bsonValue -> new ServerAddress(bsonValue.asString().getValue())).collect(Collectors.toList());
    }

    private static Date localTimeFrom(ServerHeartbeatSucceededEvent event) {
        BsonDocument reply = event.getReply();
        return new Date(reply.getDateTime((Object)"localTime").getValue());
    }

    private static Date lastWriteFrom(ServerHeartbeatSucceededEvent event) {
        BsonDocument reply = event.getReply();
        if (!reply.containsKey((Object)"lastWrite")) {
            return null;
        }
        return new Date(reply.getDocument((Object)"lastWrite").getDateTime((Object)"lastWriteDate").getValue());
    }

    private static class Heartbeat {
        private final List<ServerAddress> hosts;
        private final Date lastWrite;
        private final long localTime;

        Heartbeat(ServerHeartbeatSucceededEvent event) {
            this.hosts = ReplicaSetStatus.hostsFrom(event);
            this.lastWrite = ReplicaSetStatus.lastWriteFrom(event);
            this.localTime = ReplicaSetStatus.localTimeFrom(event).getTime();
        }

        Collection<ServerAddress> getHosts() {
            return this.hosts;
        }

        long getTime() {
            return this.localTime;
        }

        @Nullable
        Date getLastWrite() {
            return this.lastWrite;
        }
    }
}

