/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.kmelia.notification;

import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import org.owasp.encoder.Encode;
import org.silverpeas.components.kmelia.notification.AbstractKmeliaPublicationUserNotification;
import org.silverpeas.components.kmelia.service.KmeliaHelper;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.contribution.attachment.model.SimpleDocument;
import org.silverpeas.core.contribution.publication.model.PublicationDetail;
import org.silverpeas.core.node.model.NodePK;
import org.silverpeas.core.notification.user.client.constant.NotifAction;
import org.silverpeas.core.notification.user.model.NotificationResourceData;
import org.silverpeas.core.template.SilverpeasTemplate;
import org.silverpeas.core.util.DateUtil;
import org.silverpeas.core.util.file.FileRepositoryManager;
import org.silverpeas.kernel.util.StringUtil;

public class KmeliaNotifyPublicationDocumentUserNotification
extends AbstractKmeliaPublicationUserNotification {
    private final SimpleDocument document;

    public KmeliaNotifyPublicationDocumentUserNotification(NodePK nodePK, PublicationDetail resource, SimpleDocument document) {
        super(nodePK, resource, NotifAction.REPORT);
        this.document = document;
    }

    protected String getBundleSubjectKey() {
        return "AlertDocument";
    }

    protected String getTemplateFileName() {
        return "notificationAttachment";
    }

    protected Collection<String> getUserIdsToNotify() {
        return Collections.emptyList();
    }

    protected void perform(PublicationDetail resource) {
        super.perform((Object)resource);
        this.getNotificationMetaData().displayReceiversInFooter();
    }

    @Override
    protected void performTemplateData(String language, PublicationDetail resource, SilverpeasTemplate template) {
        super.performTemplateData(language, resource, template);
        template.setAttribute("attachmentFileName", (Object)Encode.forHtml((String)this.document.getFilename()));
        if (StringUtil.isDefined((String)this.document.getTitle())) {
            template.setAttribute("attachmentTitle", (Object)Encode.forHtml((String)this.document.getTitle()));
        }
        if (StringUtil.isDefined((String)this.document.getDescription())) {
            template.setAttribute("attachmentDesc", (Object)Encode.forHtml((String)this.document.getDescription()));
        }
        template.setAttribute("attachmentCreationDate", (Object)DateUtil.getOutputDate((Date)this.document.getCreationDate(), (String)language));
        template.setAttribute("attachmentSize", (Object)FileRepositoryManager.formatFileSize((long)this.document.getSize()));
        User author = this.getOrganisationController().getUserDetail(this.document.getUpdatedBy());
        if (author == null) {
            author = this.getOrganisationController().getUserDetail(this.document.getCreatedBy());
        }
        template.setAttribute("attachmentAuthor", (Object)(author.getFirstName() + " " + author.getLastName()));
        if (this.document.isVersioned()) {
            template.setAttribute("attachmentMajorNumber", (Object)this.document.getMajorVersion());
            template.setAttribute("attachmentMinorNumber", (Object)this.document.getMinorVersion());
        }
    }

    @Override
    protected void performNotificationResource(String language, PublicationDetail resource, NotificationResourceData notificationResourceData) {
        super.performNotificationResource(language, resource, notificationResourceData);
        StringBuilder sb = new StringBuilder(1024);
        if (StringUtil.isDefined((String)this.document.getTitle())) {
            sb.append(this.document.getTitle());
        }
        if (sb.length() > 0) {
            sb.append(" - ");
        }
        sb.append(this.document.getFilename());
        sb.insert(0, " - ");
        sb.insert(0, notificationResourceData.getResourceName());
        notificationResourceData.setResourceName(sb.toString());
    }

    @Override
    protected String getResourceURL(PublicationDetail resource) {
        return KmeliaHelper.getDocumentUrl(resource, this.document, this.getComponentInstanceId());
    }

    @Override
    protected String getContributionAccessLinkLabelBundleKey() {
        return "kmelia.notifDocumentLinkLabel";
    }
}

