/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.query.ast;

import org.apache.jackrabbit.oak.api.PropertyValue;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.query.QueryImpl;
import org.apache.jackrabbit.oak.query.ValueConverter;
import org.apache.jackrabbit.oak.query.ast.AstVisitor;
import org.jetbrains.annotations.NotNull;

abstract class AstElement {
    protected QueryImpl query;

    AstElement() {
    }

    abstract boolean accept(AstVisitor var1);

    protected String protect(Object expression) {
        String str = expression.toString();
        if (str.indexOf(32) >= 0) {
            return "(" + str + ")";
        }
        return str;
    }

    protected String quote(String pathOrName) {
        pathOrName = pathOrName.replaceAll("]", "]]");
        return "[" + pathOrName + "]";
    }

    protected String quoteJson(String string) {
        return "\"" + string.replaceAll("\"", "\"\"") + "\"";
    }

    public void setQuery(QueryImpl query) {
        this.query = query;
    }

    protected String normalizePropertyName(String propertyName) {
        if (this.query == null) {
            return propertyName;
        }
        if (propertyName == null) {
            return null;
        }
        int slash = propertyName.indexOf(47);
        if (slash < 0) {
            return this.normalizeNonRelativePropertyName(propertyName);
        }
        String relativePath = PathUtils.getParentPath((String)propertyName);
        if (relativePath.indexOf(42) >= 0) {
            StringBuilder buff = new StringBuilder();
            for (String p : PathUtils.elements((String)relativePath)) {
                if (!p.equals("*")) {
                    p = this.query.getOakPath(p);
                }
                if (p.length() <= 0) continue;
                if (buff.length() > 0) {
                    buff.append('/');
                }
                buff.append(p);
            }
            relativePath = buff.toString();
        } else {
            relativePath = this.query.getOakPath(relativePath);
        }
        propertyName = PathUtils.getName((String)propertyName);
        propertyName = this.normalizeNonRelativePropertyName(propertyName);
        return PathUtils.concat((String)relativePath, (String)propertyName);
    }

    private String normalizeNonRelativePropertyName(String propertyName) {
        if (propertyName.equals("*")) {
            return propertyName;
        }
        return this.query.getOakPath(propertyName);
    }

    protected String normalizePath(String path) {
        if (this.query == null) {
            return path;
        }
        return this.query.getOakPath(path);
    }

    protected PropertyValue convertValueToType(PropertyValue v, PropertyValue targetType) {
        int type = targetType.getType().tag();
        if (v.getType().tag() == type) {
            return v;
        }
        try {
            return ValueConverter.convert(v, type, this.query.getNamePathMapper());
        }
        catch (IllegalArgumentException e) {
            return v;
        }
    }

    protected String getLocalPath(String path) {
        return path;
    }

    @NotNull
    public AstElement copyOf() {
        return this;
    }
}

