/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment;

import javax.jcr.Value;
import org.apache.jackrabbit.commons.SimpleValueFactory;
import org.apache.jackrabbit.oak.api.Descriptors;
import org.apache.jackrabbit.oak.spi.cluster.ClusterRepositoryInfo;
import org.apache.jackrabbit.oak.spi.state.NodeStore;
import org.jetbrains.annotations.NotNull;

class SegmentDiscoveryLiteDescriptors
implements Descriptors {
    private static final String OAK_DISCOVERYLITE_CLUSTERVIEW = "oak.discoverylite.clusterview";
    private final SimpleValueFactory factory = new SimpleValueFactory();
    private final NodeStore store;

    SegmentDiscoveryLiteDescriptors(NodeStore store) {
        this.store = store;
    }

    @NotNull
    public String[] getKeys() {
        return new String[]{OAK_DISCOVERYLITE_CLUSTERVIEW};
    }

    public boolean isStandardDescriptor(@NotNull String key) {
        return OAK_DISCOVERYLITE_CLUSTERVIEW.equals(key);
    }

    public boolean isSingleValueDescriptor(@NotNull String key) {
        return OAK_DISCOVERYLITE_CLUSTERVIEW.equals(key);
    }

    public Value getValue(@NotNull String key) {
        if (!OAK_DISCOVERYLITE_CLUSTERVIEW.equals(key)) {
            return null;
        }
        return this.factory.createValue(this.getClusterViewAsDescriptorValue());
    }

    public Value[] getValues(@NotNull String key) {
        if (!OAK_DISCOVERYLITE_CLUSTERVIEW.equals(key)) {
            return null;
        }
        return new Value[]{this.getValue(key)};
    }

    private String getClusterViewAsDescriptorValue() {
        String clusterId = ClusterRepositoryInfo.getOrCreateId((NodeStore)this.store);
        return "{\"seq\":1,\"final\":true,\"me\":1,\"id\":\"" + clusterId + "\",\"active\":[1],\"deactivating\":[],\"inactive\":[]}";
    }
}

