/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document.rdb;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.zip.GZIPOutputStream;
import javax.sql.DataSource;
import org.apache.jackrabbit.guava.common.base.Function;
import org.apache.jackrabbit.guava.common.base.Preconditions;
import org.apache.jackrabbit.guava.common.base.Stopwatch;
import org.apache.jackrabbit.guava.common.base.Strings;
import org.apache.jackrabbit.guava.common.collect.ImmutableMap;
import org.apache.jackrabbit.guava.common.collect.Iterators;
import org.apache.jackrabbit.guava.common.collect.Lists;
import org.apache.jackrabbit.guava.common.collect.Maps;
import org.apache.jackrabbit.guava.common.collect.Sets;
import org.apache.jackrabbit.oak.cache.CacheStats;
import org.apache.jackrabbit.oak.cache.CacheValue;
import org.apache.jackrabbit.oak.commons.properties.SystemPropertySupplier;
import org.apache.jackrabbit.oak.plugins.document.Collection;
import org.apache.jackrabbit.oak.plugins.document.Document;
import org.apache.jackrabbit.oak.plugins.document.DocumentNodeStoreBuilder;
import org.apache.jackrabbit.oak.plugins.document.DocumentStore;
import org.apache.jackrabbit.oak.plugins.document.DocumentStoreException;
import org.apache.jackrabbit.oak.plugins.document.DocumentStoreStatsCollector;
import org.apache.jackrabbit.oak.plugins.document.NodeDocument;
import org.apache.jackrabbit.oak.plugins.document.UpdateOp;
import org.apache.jackrabbit.oak.plugins.document.UpdateUtils;
import org.apache.jackrabbit.oak.plugins.document.cache.CacheChangesTracker;
import org.apache.jackrabbit.oak.plugins.document.cache.CacheInvalidationStats;
import org.apache.jackrabbit.oak.plugins.document.cache.ModificationStamp;
import org.apache.jackrabbit.oak.plugins.document.cache.NodeDocumentCache;
import org.apache.jackrabbit.oak.plugins.document.locks.NodeDocumentLocks;
import org.apache.jackrabbit.oak.plugins.document.locks.StripedNodeDocumentLocks;
import org.apache.jackrabbit.oak.plugins.document.rdb.RDBConnectionHandler;
import org.apache.jackrabbit.oak.plugins.document.rdb.RDBDocumentSerializer;
import org.apache.jackrabbit.oak.plugins.document.rdb.RDBDocumentStoreDB;
import org.apache.jackrabbit.oak.plugins.document.rdb.RDBDocumentStoreJDBC;
import org.apache.jackrabbit.oak.plugins.document.rdb.RDBJDBCTools;
import org.apache.jackrabbit.oak.plugins.document.rdb.RDBOptions;
import org.apache.jackrabbit.oak.plugins.document.rdb.RDBRow;
import org.apache.jackrabbit.oak.plugins.document.util.CloseableIterator;
import org.apache.jackrabbit.oak.plugins.document.util.Utils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RDBDocumentStore
implements DocumentStore {
    private static int MINIMALBULKUPDATESIZE = 3;
    private String droppedTables = "";
    private static Map<Collection<? extends Document>, String> TABLEMAP;
    private static List<String> TABLENAMES;
    private final Map<Collection<? extends Document>, RDBTableMetaData> tableMeta = new HashMap<Collection<? extends Document>, RDBTableMetaData>();
    private static final String MODIFIED = "_modified";
    private static final String MODCOUNT = "_modCount";
    public static final String COLLISIONSMODCOUNT = "_collisionsModCount";
    private static final String ID = "_id";
    private static final Logger LOG;
    private Exception callStack;
    private RDBConnectionHandler ch;
    private Set<String> tablesToBeDropped = new HashSet<String>();
    public static final int CHAR2OCTETRATIO = 3;
    private static final int RETRIES = 10;
    protected static final boolean USECMODCOUNT = true;
    protected static final int SCHEMA = 2;
    private static final UpdateOp.Key MODIFIEDKEY;
    private RDBDocumentStoreDB dbInfo;
    private RDBDocumentStoreJDBC db;
    protected static final List<String> EMPTY_KEY_PATTERN;
    private Map<String, String> metadata;
    private DocumentStoreStatsCollector stats;
    private boolean readOnly;
    public static String VERSIONPROP;
    private static final Set<String> INDEXEDPROPERTIES;
    private static final Set<String> REQUIREDCOLUMNS;
    private static final Set<String> OPTIONALCOLUMNS;
    private static final Set<String> COLUMNPROPERTIES;
    private static final Set<String> COLUMNPROPERTIES2;
    private final RDBDocumentSerializer ser = new RDBDocumentSerializer(this);
    private static final boolean NOGZIP;
    private static final boolean NOAPPEND;
    private static final int CHUNKSIZE;
    private static final int QUERYHITSLIMIT;
    private static final int QUERYTIMELIMIT;
    private static final boolean BATCHUPDATES;
    private NodeDocumentCache nodesCache;
    private NodeDocumentLocks locks;
    private Map<String, Long> cnUpdates = new ConcurrentHashMap<String, Long>();

    public RDBDocumentStore(DataSource ds, DocumentNodeStoreBuilder<?> builder, RDBOptions options) {
        try {
            this.initialize(ds, builder, options);
        }
        catch (Exception ex) {
            throw RDBJDBCTools.asDocumentStoreException(ex, "initializing RDB document store");
        }
    }

    public RDBDocumentStore(DataSource ds, DocumentNodeStoreBuilder<?> builder) {
        this(ds, builder, new RDBOptions());
    }

    @Override
    public <T extends Document> T find(Collection<T> collection, String id) {
        return this.find(collection, id, Integer.MAX_VALUE);
    }

    @Override
    public <T extends Document> T find(Collection<T> collection, String id, int maxCacheAge) {
        return this.readDocumentCached(collection, id, maxCacheAge);
    }

    @Override
    @NotNull
    public <T extends Document> List<T> query(Collection<T> collection, String fromKey, String toKey, int limit) {
        return this.query(collection, fromKey, toKey, null, 0L, limit);
    }

    @Override
    @NotNull
    public <T extends Document> List<T> query(Collection<T> collection, String fromKey, String toKey, String indexedProperty, long startValue, int limit) {
        List<QueryCondition> conditions = Collections.emptyList();
        if (indexedProperty != null) {
            conditions = Collections.singletonList(new QueryCondition(indexedProperty, ">=", startValue));
        }
        return this.internalQuery(collection, fromKey, toKey, EMPTY_KEY_PATTERN, conditions, limit);
    }

    @NotNull
    protected <T extends Document> List<T> query(Collection<T> collection, String fromKey, String toKey, List<String> excludeKeyPatterns, List<QueryCondition> conditions, int limit) {
        return this.internalQuery(collection, fromKey, toKey, excludeKeyPatterns, conditions, limit);
    }

    @Override
    public <T extends Document> void remove(Collection<T> collection, String id) {
        try {
            this.delete(collection, id);
        }
        finally {
            this.invalidateCache(collection, id, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends Document> void remove(Collection<T> collection, List<String> ids) {
        try {
            this.delete(collection, ids);
        }
        finally {
            for (String id : ids) {
                this.invalidateCache(collection, id, true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends Document> int remove(Collection<T> collection, Map<String, Long> toRemove) {
        try {
            int n = this.delete(collection, toRemove);
            return n;
        }
        finally {
            for (String id : toRemove.keySet()) {
                this.invalidateCache(collection, id, true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends Document> int remove(Collection<T> collection, String indexedProperty, long startValue, long endValue) throws DocumentStoreException {
        try {
            ArrayList<QueryCondition> conditions = new ArrayList<QueryCondition>();
            conditions.add(new QueryCondition(indexedProperty, ">", startValue));
            conditions.add(new QueryCondition(indexedProperty, "<", endValue));
            int n = this.deleteWithCondition(collection, conditions);
            return n;
        }
        finally {
            if (collection == Collection.NODES) {
                this.invalidateCache();
            }
        }
    }

    @Override
    public <T extends Document> boolean create(Collection<T> collection, List<UpdateOp> updateOps) {
        return this.internalCreate(collection, updateOps);
    }

    @Override
    public <T extends Document> T createOrUpdate(Collection<T> collection, UpdateOp update) {
        UpdateUtils.assertUnconditional(update);
        return this.internalCreateOrUpdate(collection, update, update.isNew(), false, 10);
    }

    @Override
    public <T extends Document> List<T> createOrUpdate(Collection<T> collection, List<UpdateOp> updateOps) {
        if (!BATCHUPDATES || updateOps.size() < MINIMALBULKUPDATESIZE) {
            ArrayList<T> results = new ArrayList<T>(updateOps.size());
            for (UpdateOp update : updateOps) {
                results.add(this.createOrUpdate(collection, update));
            }
            return results;
        }
        return this.internalCreateOrUpdate(collection, updateOps);
    }

    private <T extends Document> List<T> internalCreateOrUpdate(Collection<T> collection, List<UpdateOp> updateOps) {
        Stopwatch watch = this.startWatch();
        LinkedHashMap<UpdateOp, T> results = new LinkedHashMap<UpdateOp, T>();
        LinkedHashMap<String, UpdateOp> operationsToCover = new LinkedHashMap<String, UpdateOp>();
        HashSet<UpdateOp> duplicates = new HashSet<UpdateOp>();
        for (UpdateOp updateOp : updateOps) {
            UpdateUtils.assertUnconditional(updateOp);
            if (operationsToCover.containsKey(updateOp.getId())) {
                duplicates.add(updateOp);
                results.put(updateOp, null);
                continue;
            }
            UpdateOp clone = updateOp.copy();
            RDBDocumentStore.addUpdateCounters(clone);
            operationsToCover.put(clone.getId(), clone);
            results.put(clone, null);
        }
        HashMap<String, T> oldDocs = new HashMap<String, T>();
        if (collection == Collection.NODES) {
            oldDocs.putAll(this.readDocumentCached(collection, operationsToCover.keySet()));
        }
        int i = 0;
        while (operationsToCover.size() >= MINIMALBULKUPDATESIZE) {
            boolean upsert;
            boolean bl = upsert = i == 0;
            if (i++ == 3) break;
            for (List partition : Lists.partition((List)Lists.newArrayList(operationsToCover.values()), (int)CHUNKSIZE)) {
                Map<UpdateOp, T> successfulUpdates = this.bulkUpdate(collection, partition, oldDocs, upsert);
                results.putAll(successfulUpdates);
                operationsToCover.values().removeAll(successfulUpdates.keySet());
            }
        }
        for (UpdateOp updateOp : updateOps) {
            UpdateOp conflictedOp = (UpdateOp)operationsToCover.remove(updateOp.getId());
            if (conflictedOp != null) {
                if (collection == Collection.NODES) {
                    LOG.debug("createOrUpdate: update conflict on {}, invalidating cache and retrying...", (Object)updateOp.getId());
                    this.nodesCache.invalidate(updateOp.getId());
                } else {
                    LOG.debug("createOrUpdate: update conflict on {}, retrying...", (Object)updateOp.getId());
                }
                results.put(conflictedOp, this.createOrUpdate(collection, updateOp));
                continue;
            }
            if (!duplicates.contains(updateOp)) continue;
            results.put(updateOp, this.createOrUpdate(collection, updateOp));
        }
        this.stats.doneCreateOrUpdate(watch.elapsed(TimeUnit.NANOSECONDS), collection, Lists.transform(updateOps, (Function)new Function<UpdateOp, String>(){

            public String apply(UpdateOp input) {
                return input.getId();
            }
        }));
        return new ArrayList(results.values());
    }

    private <T extends Document> Map<String, T> readDocumentCached(Collection<T> collection, Set<String> keys) {
        HashMap<String, T> documents = new HashMap<String, T>();
        if (collection == Collection.NODES) {
            for (String key : keys) {
                NodeDocument cached = this.nodesCache.getIfPresent(key);
                if (cached == null || cached == NodeDocument.NULL) continue;
                Object doc = RDBDocumentStore.castAsT(RDBDocumentStore.unwrap(cached));
                documents.put(((Document)doc).getId(), doc);
            }
        }
        Sets.SetView documentsToRead = Sets.difference(keys, documents.keySet());
        Map<String, T> readDocuments = this.readDocumentsUncached(collection, (Set<String>)documentsToRead);
        documents.putAll(readDocuments);
        if (collection == Collection.NODES) {
            for (Object doc : readDocuments.values()) {
                this.nodesCache.putIfAbsent((NodeDocument)doc);
            }
        }
        return documents;
    }

    private <T extends Document> Map<String, T> readDocumentsUncached(Collection<T> collection, Set<String> keys) {
        HashMap<String, T> result = new HashMap<String, T>();
        Connection connection = null;
        RDBTableMetaData tmd = this.getTable(collection);
        try {
            connection = this.ch.getROConnection();
            List<RDBRow> rows = this.db.read(connection, tmd, keys);
            int size = rows.size();
            for (int i = 0; i < size; ++i) {
                RDBRow row = rows.set(i, null);
                T document = this.convertFromDBObject(collection, row);
                result.put(((Document)document).getId(), document);
            }
            connection.commit();
        }
        catch (Exception ex) {
            throw RDBJDBCTools.asDocumentStoreException(ex, "trying to read: " + keys);
        }
        finally {
            this.ch.closeConnection(connection);
        }
        return result;
    }

    @Nullable
    private <T extends Document> CacheChangesTracker obtainTracker(Collection<T> collection, Set<String> keys) {
        if (collection == Collection.NODES) {
            return this.nodesCache.registerTracker(keys);
        }
        return null;
    }

    @Nullable
    private <T extends Document> CacheChangesTracker obtainTracker(Collection<T> collection, String fromKey, String toKey) {
        if (collection == Collection.NODES) {
            return this.nodesCache.registerTracker(fromKey, toKey);
        }
        return null;
    }

    /*
     * Loose catch block
     */
    private <T extends Document> Map<UpdateOp, T> bulkUpdate(Collection<T> collection, List<UpdateOp> updates, Map<String, T> oldDocs, boolean upsert) {
        HashSet<String> missingDocs = new HashSet<String>();
        for (UpdateOp op : updates) {
            if (oldDocs.containsKey(op.getId())) continue;
            missingDocs.add(op.getId());
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("bulkUpdate: cached docs to be updated: {}", (Object)RDBDocumentStore.dumpKeysAndModcounts(oldDocs));
        }
        Map<String, T> freshDocs = this.readDocumentsUncached(collection, missingDocs);
        if (LOG.isTraceEnabled()) {
            LOG.trace("bulkUpdate: fresh docs to be updated: {}", (Object)RDBDocumentStore.dumpKeysAndModcounts(freshDocs));
        }
        oldDocs.putAll(freshDocs);
        try (CacheChangesTracker tracker = this.obtainTracker(collection, (Set<String>)Sets.union(oldDocs.keySet(), missingDocs));){
            ArrayList<T> docsToUpdate = new ArrayList<T>(updates.size());
            HashSet<String> keysToUpdate = new HashSet<String>();
            for (UpdateOp update : updates) {
                String id = update.getId();
                T modifiedDoc = collection.newDocument(this);
                Document oldDoc = (Document)oldDocs.get(id);
                if (oldDoc != null) {
                    oldDoc.deepCopy((Document)modifiedDoc);
                }
                UpdateUtils.applyChanges(modifiedDoc, update);
                if (oldDoc != null || update.isNew()) {
                    docsToUpdate.add(modifiedDoc);
                }
                keysToUpdate.add(id);
            }
            Connection connection = null;
            RDBTableMetaData tmd = this.getTable(collection);
            try {
                connection = this.ch.getRWConnection();
                Set<String> successfulUpdates = this.db.update(connection, tmd, docsToUpdate, upsert);
                connection.commit();
                Sets.SetView failedUpdates = Sets.difference(keysToUpdate, successfulUpdates);
                oldDocs.keySet().removeAll((java.util.Collection<?>)failedUpdates);
                if (LOG.isTraceEnabled()) {
                    LOG.trace("bulkUpdate: success for {}, failure for {}", successfulUpdates, (Object)failedUpdates);
                }
                if (collection == Collection.NODES) {
                    ArrayList<NodeDocument> docsToCache = new ArrayList<NodeDocument>();
                    for (Document doc : docsToUpdate) {
                        if (!successfulUpdates.contains(doc.getId())) continue;
                        docsToCache.add((NodeDocument)doc);
                    }
                    this.nodesCache.putNonConflictingDocs(tracker, docsToCache);
                }
                HashMap<UpdateOp, Document> result = new HashMap<UpdateOp, Document>();
                for (UpdateOp op : updates) {
                    if (!successfulUpdates.contains(op.getId())) continue;
                    result.put(op, (Document)oldDocs.get(op.getId()));
                }
                HashMap<UpdateOp, Document> hashMap = result;
                return hashMap;
            }
            catch (SQLException ex) {
                this.ch.rollbackConnection(connection);
                throw this.handleException("update failed for: " + keysToUpdate, (Exception)ex, collection, keysToUpdate);
            }
            finally {
                this.ch.closeConnection(connection);
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
    }

    @Override
    public <T extends Document> T findAndUpdate(Collection<T> collection, UpdateOp update) {
        return this.internalCreateOrUpdate(collection, update, false, true, 10);
    }

    @Override
    public CacheInvalidationStats invalidateCache() {
        for (CacheValue key : this.nodesCache.keys()) {
            this.invalidateCache(Collection.NODES, key.toString());
        }
        return null;
    }

    @Override
    public CacheInvalidationStats invalidateCache(Iterable<String> keys) {
        for (String key : keys) {
            this.invalidateCache(Collection.NODES, key);
        }
        return null;
    }

    @Override
    public <T extends Document> void invalidateCache(Collection<T> collection, String id) {
        this.invalidateCache(collection, id, false);
    }

    private <T extends Document> void invalidateCache(Collection<T> collection, String id, boolean remove) {
        if (collection == Collection.NODES) {
            this.invalidateNodesCache(id, remove);
        }
    }

    private void invalidateNodesCache(String id, boolean remove) {
        try (CacheLock lock = this.acquireLockFor(id);){
            if (remove) {
                this.nodesCache.invalidate(id);
            } else {
                this.nodesCache.markChanged(id);
                NodeDocument entry = this.nodesCache.getIfPresent(id);
                if (entry != null) {
                    entry.markUpToDate(0L);
                }
            }
        }
    }

    @Override
    public long determineServerTimeDifferenceMillis() {
        Connection connection = null;
        try {
            connection = this.ch.getROConnection();
            long result = this.db.determineServerTimeDifferenceMillis(connection);
            connection.commit();
            long l = result;
            return l;
        }
        catch (SQLException ex) {
            LOG.error("Trying to determine time difference to server", (Throwable)ex);
            throw RDBJDBCTools.asDocumentStoreException(ex, "Trying to determine time difference to server");
        }
        finally {
            this.ch.closeConnection(connection);
        }
    }

    public String getDroppedTables() {
        return this.droppedTables;
    }

    public static List<String> getTableNames() {
        return TABLENAMES;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        if (!this.tablesToBeDropped.isEmpty()) {
            Object dropped = "";
            LOG.debug("attempting to drop: " + this.tablesToBeDropped);
            for (String tname : this.tablesToBeDropped) {
                Connection con = null;
                try {
                    con = this.ch.getRWConnection();
                    Statement stmt = null;
                    try {
                        stmt = con.createStatement();
                        stmt.execute("drop table " + tname);
                        stmt.close();
                        con.commit();
                        dropped = (String)dropped + tname + " ";
                    }
                    catch (SQLException ex) {
                        LOG.debug("attempting to drop: " + tname, (Throwable)ex);
                    }
                    finally {
                        RDBJDBCTools.closeStatement(stmt);
                    }
                }
                catch (SQLException ex) {
                    LOG.debug("attempting to drop: " + tname, (Throwable)ex);
                }
                finally {
                    this.ch.closeConnection(con);
                }
            }
            this.droppedTables = ((String)dropped).trim();
        }
        try {
            this.ch.close();
        }
        catch (IOException ex) {
            LOG.error("closing connection handler", (Throwable)ex);
        }
        try {
            this.nodesCache.close();
        }
        catch (IOException ex) {
            LOG.warn("Error occurred while closing nodes cache", (Throwable)ex);
        }
        LOG.info("RDBDocumentStore (" + Utils.getModuleVersion() + ") disposed" + this.getCnStats() + (String)(this.droppedTables.isEmpty() ? "" : " (tables dropped: " + this.droppedTables + ")"));
    }

    @Override
    public <T extends Document> T getIfCached(Collection<T> collection, String id) {
        if (collection != Collection.NODES) {
            return null;
        }
        NodeDocument doc = this.nodesCache.getIfPresent(id);
        doc = doc != null ? RDBDocumentStore.unwrap(doc) : null;
        return RDBDocumentStore.castAsT(doc);
    }

    private <T extends Document> T getIfCached(Collection<T> collection, String id, long modCount) {
        T doc = this.getIfCached(collection, id);
        if (doc != null && ((Document)doc).getModCount() != null && ((Document)doc).getModCount() == modCount) {
            return doc;
        }
        return null;
    }

    @Override
    public Iterable<CacheStats> getCacheStats() {
        return this.nodesCache.getCacheStats();
    }

    @Override
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    @Override
    @NotNull
    public Map<String, String> getStats() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        this.tableMeta.forEach((k, v) -> this.toMapBuilder((ImmutableMap.Builder<String, String>)builder, (Collection)k, (RDBTableMetaData)v));
        if (LOG.isDebugEnabled()) {
            LOG.debug("statistics obtained: " + builder.toString());
        }
        return builder.build();
    }

    private <T extends Document> void toMapBuilder(ImmutableMap.Builder<String, String> builder, Collection<T> collection, RDBTableMetaData meta) {
        String prefix = collection.toString();
        builder.put((Object)(prefix + ".ns"), (Object)(meta.getCatalog() + "." + meta.getName()));
        builder.put((Object)(prefix + ".schemaInfo"), (Object)meta.getSchemaInfo());
        builder.put((Object)(prefix + ".indexInfo"), (Object)meta.getIndexInfo());
        if (Collection.CLUSTER_NODES.equals(collection)) {
            builder.put((Object)(prefix + ".updates"), (Object)this.getCnStats());
        }
        Map<String, String> map = this.dbInfo.getAdditionalStatistics(this.ch, meta.getCatalog(), meta.getName());
        map.forEach((k, v) -> builder.put((Object)(prefix + "." + k), v));
        try {
            long c = this.queryCount(collection, null, null, Collections.emptyList(), Collections.emptyList());
            builder.put((Object)(prefix + ".count"), (Object)Long.toString(c));
        }
        catch (DocumentStoreException ex) {
            LOG.debug("getting entry count for " + prefix, (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initialize(DataSource ds, DocumentNodeStoreBuilder<?> builder, RDBOptions options) throws Exception {
        this.stats = builder.getDocumentStoreStatsCollector();
        this.callStack = LOG.isDebugEnabled() ? new Exception("call stack of RDBDocumentStore creation") : null;
        this.readOnly = builder.getReadOnlyMode();
        this.ch = new RDBConnectionHandler(ds);
        Connection con = this.ch.getRWConnection();
        String catalog = con.getCatalog();
        DatabaseMetaData md = con.getMetaData();
        if (null == catalog) {
            catalog = md.getUserName();
        }
        this.tableMeta.put(Collection.NODES, new RDBTableMetaData(catalog, RDBJDBCTools.createTableName(options.getTablePrefix(), TABLEMAP.get(Collection.NODES))));
        this.tableMeta.put(Collection.CLUSTER_NODES, new RDBTableMetaData(catalog, RDBJDBCTools.createTableName(options.getTablePrefix(), TABLEMAP.get(Collection.CLUSTER_NODES))));
        this.tableMeta.put(Collection.JOURNAL, new RDBTableMetaData(catalog, RDBJDBCTools.createTableName(options.getTablePrefix(), TABLEMAP.get(Collection.JOURNAL))));
        this.tableMeta.put(Collection.SETTINGS, new RDBTableMetaData(catalog, RDBJDBCTools.createTableName(options.getTablePrefix(), TABLEMAP.get(Collection.SETTINGS))));
        this.locks = new StripedNodeDocumentLocks();
        this.nodesCache = builder.buildNodeDocumentCache(this, this.locks);
        int isolation = con.getTransactionIsolation();
        String isolationDiags = RDBJDBCTools.isolationLevelToString(isolation);
        if (isolation != 2) {
            LOG.info("Detected transaction isolation level " + isolationDiags + " is " + (isolation < 2 ? "lower" : "higher") + " than expected " + RDBJDBCTools.isolationLevelToString(2) + " - check datasource configuration");
        }
        String dbDesc = String.format("%s %s (%d.%d)", md.getDatabaseProductName(), md.getDatabaseProductVersion(), md.getDatabaseMajorVersion(), md.getDatabaseMinorVersion()).replaceAll("[\r\n\t]", " ").trim();
        String driverDesc = String.format("%s %s (%d.%d)", md.getDriverName(), md.getDriverVersion(), md.getDriverMajorVersion(), md.getDriverMinorVersion()).replaceAll("[\r\n\t]", " ").trim();
        String dbUrl = md.getURL();
        this.dbInfo = RDBDocumentStoreDB.getValue(md.getDatabaseProductName());
        this.db = new RDBDocumentStoreJDBC(this.dbInfo, this.ser, QUERYHITSLIMIT, QUERYTIMELIMIT);
        this.metadata = ImmutableMap.builder().put((Object)"type", (Object)"rdb").put((Object)"db", (Object)md.getDatabaseProductName()).put((Object)"version", (Object)md.getDatabaseProductVersion()).put((Object)"driver", (Object)md.getDriverName()).put((Object)"driverVersion", (Object)md.getDriverVersion()).build();
        String versionDiags = this.dbInfo.checkVersion(md);
        if (!versionDiags.isEmpty()) {
            LOG.error(versionDiags);
        }
        if (!"".equals(this.dbInfo.getInitializationStatement())) {
            Statement stmt = null;
            try {
                stmt = con.createStatement();
                stmt.execute(this.dbInfo.getInitializationStatement());
                stmt.close();
                con.commit();
            }
            finally {
                RDBJDBCTools.closeStatement(stmt);
            }
        }
        ArrayList<String> tablesCreated = new ArrayList<String>();
        ArrayList<String> tablesPresent = new ArrayList<String>();
        try {
            this.createTableFor(con, Collection.CLUSTER_NODES, this.tableMeta.get(Collection.CLUSTER_NODES), tablesCreated, tablesPresent, options.getInitialSchema(), options.getUpgradeToSchema());
            this.createTableFor(con, Collection.NODES, this.tableMeta.get(Collection.NODES), tablesCreated, tablesPresent, options.getInitialSchema(), options.getUpgradeToSchema());
            this.createTableFor(con, Collection.SETTINGS, this.tableMeta.get(Collection.SETTINGS), tablesCreated, tablesPresent, options.getInitialSchema(), options.getUpgradeToSchema());
            this.createTableFor(con, Collection.JOURNAL, this.tableMeta.get(Collection.JOURNAL), tablesCreated, tablesPresent, options.getInitialSchema(), options.getUpgradeToSchema());
        }
        finally {
            con.commit();
            con.close();
        }
        StringBuilder tableDiags = new StringBuilder();
        RDBTableMetaData nodesMeta = this.tableMeta.get(Collection.NODES);
        tableDiags.append(nodesMeta.getSchemaInfo());
        if (!nodesMeta.getIndexInfo().isEmpty()) {
            tableDiags.append(" /* ").append(nodesMeta.getIndexInfo()).append(" */");
        }
        if (options.isDropTablesOnClose()) {
            this.tablesToBeDropped.addAll(tablesCreated);
        }
        if (tableDiags.length() != 0) {
            tableDiags.insert(0, ", ");
        }
        Map<String, String> diag = this.dbInfo.getAdditionalDiagnostics(this.ch, this.tableMeta.get(Collection.NODES).getName());
        LOG.info("RDBDocumentStore (" + Utils.getModuleVersion() + ") instantiated for database " + dbDesc + ", using driver: " + driverDesc + ", connecting to: " + dbUrl + (String)(diag.isEmpty() ? "" : ", properties: " + diag.toString()) + ", transaction isolation level: " + isolationDiags + tableDiags);
        if (!tablesPresent.isEmpty()) {
            LOG.info("Tables present upon startup: " + tablesPresent);
        }
        if (!tablesCreated.isEmpty()) {
            LOG.info("Tables created upon startup: " + tablesCreated + (options.isDropTablesOnClose() ? " (will be dropped on exit)" : ""));
        }
    }

    private static boolean isBinaryType(int sqlType) {
        return sqlType == -3 || sqlType == -2 || sqlType == -4;
    }

    private static boolean isNChar(int sqlType) {
        return sqlType == -15 || sqlType == -9 || sqlType == -16;
    }

    private static void obtainFlagsFromResultSetMeta(ResultSetMetaData met, RDBTableMetaData tmd) throws SQLException {
        for (int i = 1; i <= met.getColumnCount(); ++i) {
            String lcName = met.getColumnName(i).toLowerCase(Locale.ENGLISH);
            if ("id".equals(lcName)) {
                tmd.setIdIsBinary(RDBDocumentStore.isBinaryType(met.getColumnType(i)));
            }
            if ("data".equals(lcName)) {
                tmd.setDataLimitInOctets(met.getPrecision(i));
                tmd.setDataIsNChar(RDBDocumentStore.isNChar(met.getColumnType(i)));
            }
            if ("version".equals(lcName)) {
                tmd.setHasVersion(true);
            }
            if (!"sdtype".equals(lcName)) continue;
            tmd.setHasSplitDocs(true);
        }
    }

    private static String asQualifiedDbName(String one, String two) {
        one = Strings.nullToEmpty((String)one).trim();
        two = Strings.nullToEmpty((String)two).trim();
        if (one.isEmpty() && two.isEmpty()) {
            return null;
        }
        one = Strings.nullToEmpty((String)one).trim();
        two = two == null ? "" : two.trim();
        return one.isEmpty() ? two : one + "." + two;
    }

    private static String indexTypeAsString(int type) {
        switch (type) {
            case 1: {
                return "clustered";
            }
            case 2: {
                return "hashed";
            }
            case 0: {
                return "statistic";
            }
            case 3: {
                return "other";
            }
        }
        return "indexType=" + type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String dumpIndexData(DatabaseMetaData met, ResultSetMetaData rmet, String tableName, Set<String> indexedColumns) {
        String string;
        ResultSet rs = null;
        try {
            String rmetTableName = Strings.nullToEmpty((String)rmet.getTableName(1)).trim();
            if (!rmetTableName.isEmpty()) {
                tableName = rmetTableName;
            }
            String rmetSchemaName = Strings.nullToEmpty((String)rmet.getSchemaName(1)).trim();
            rs = met.getIndexInfo(null, null, tableName, false, true);
            Map<String, IndexInformation> indices = RDBDocumentStore.getIndexInformation(rs, rmetSchemaName);
            if (indices.isEmpty() && !tableName.equals(tableName.toUpperCase(Locale.ENGLISH))) {
                rs = met.getIndexInfo(null, null, tableName.toUpperCase(Locale.ENGLISH), false, true);
                indices = RDBDocumentStore.getIndexInformation(rs, rmetSchemaName);
            }
            if (indexedColumns != null) {
                for (IndexInformation idata : indices.values()) {
                    indexedColumns.addAll(idata.columns);
                }
            }
            string = RDBDocumentStore.dumpIndexData(indices);
        }
        catch (SQLException ex) {
            String string2;
            try {
                String message = String.format("exception while retrieving index information: %s, code %d, state %s", ex.getMessage(), ex.getErrorCode(), ex.getSQLState());
                LOG.debug(message, (Throwable)ex);
                string2 = "/* " + message + "*/";
            }
            catch (Throwable throwable) {
                RDBJDBCTools.closeResultSet(rs);
                throw throwable;
            }
            RDBJDBCTools.closeResultSet(rs);
            return string2;
        }
        RDBJDBCTools.closeResultSet(rs);
        return string;
    }

    private static String dumpIndexData(Map<String, IndexInformation> indices) {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, IndexInformation> index : indices.entrySet()) {
            String indexName = index.getKey();
            IndexInformation info = index.getValue();
            if (!info.fields.isEmpty()) {
                if (sb.length() != 0) {
                    sb.append(", ");
                }
                sb.append(String.format("%sindex %s on %s (", info.nonunique ? "" : "unique ", indexName, info.tname));
                String delim = "";
                for (String field : info.fields.values()) {
                    sb.append(delim);
                    delim = ", ";
                    sb.append(field);
                }
                sb.append(")");
                sb.append(" ").append(info.type);
            }
            if (info.filterCondition != null) {
                sb.append(" where ").append(info.filterCondition);
            }
            sb.append(String.format(" (#%d, p%d)", info.cardinality, info.pages));
        }
        return sb.toString();
    }

    private static Map<String, IndexInformation> getIndexInformation(ResultSet rs, String rmetSchemaName) throws SQLException {
        TreeMap<String, IndexInformation> result = new TreeMap<String, IndexInformation>();
        while (rs.next()) {
            String tname;
            String name = RDBDocumentStore.asQualifiedDbName(rs.getString("INDEX_QUALIFIER"), rs.getString("INDEX_NAME"));
            if (name == null) continue;
            IndexInformation info = (IndexInformation)result.get(name);
            if (info == null) {
                info = new IndexInformation();
                result.put(name, info);
                info.fields = new TreeMap<Integer, String>();
            }
            info.nonunique = rs.getBoolean("NON_UNIQUE");
            info.type = RDBDocumentStore.indexTypeAsString(rs.getInt("TYPE"));
            String inSchema = rs.getString("TABLE_SCHEM");
            inSchema = Strings.nullToEmpty((String)inSchema).trim();
            String filterCondition = Strings.nullToEmpty((String)rs.getString("FILTER_CONDITION")).trim();
            if (!filterCondition.isEmpty()) {
                info.filterCondition = filterCondition;
            }
            info.cardinality = rs.getInt("CARDINALITY");
            info.pages = rs.getInt("PAGES");
            HashSet<String> columns = new HashSet<String>();
            info.columns = columns;
            if (!rmetSchemaName.isEmpty() && !inSchema.isEmpty() && !rmetSchemaName.equals(inSchema)) continue;
            info.tname = tname = RDBDocumentStore.asQualifiedDbName(inSchema, rs.getString("TABLE_NAME"));
            String cname = rs.getString("COLUMN_NAME");
            if (cname == null) continue;
            columns.add(cname.toUpperCase(Locale.ENGLISH));
            String order = "A".equals(rs.getString("ASC_OR_DESC")) ? " ASC" : ("D".equals(rs.getString("ASC_OR_DESC")) ? " DESC" : "");
            info.fields.put(rs.getInt("ORDINAL_POSITION"), cname + order);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createTableFor(Connection con, Collection<? extends Document> col, RDBTableMetaData tmd, List<String> tablesCreated, List<String> tablesPresent, int initialSchema, int upgradeToSchema) throws SQLException {
        Statement creatStatement;
        ResultSet checkResultSet;
        Statement checkStatement;
        block21: {
            Object dbname = this.dbInfo.toString();
            if (con.getMetaData().getURL() != null) {
                dbname = (String)dbname + " (" + con.getMetaData().getURL() + ")";
            }
            String tableName = tmd.getName();
            checkStatement = null;
            checkResultSet = null;
            creatStatement = null;
            try {
                checkStatement = con.createStatement();
                checkResultSet = checkStatement.executeQuery("select * from " + tableName + " where ID = '0'");
                ResultSetMetaData met = checkResultSet.getMetaData();
                RDBDocumentStore.obtainFlagsFromResultSetMeta(met, tmd);
                HashSet<String> requiredColumns = new HashSet<String>(REQUIREDCOLUMNS);
                HashSet<String> unknownColumns = new HashSet<String>();
                boolean hasVersionColumn = false;
                boolean hasSDTypeColumn = false;
                for (int i = 1; i <= met.getColumnCount(); ++i) {
                    String cname = met.getColumnName(i).toLowerCase(Locale.ENGLISH);
                    if (!requiredColumns.remove(cname) && !OPTIONALCOLUMNS.contains(cname)) {
                        unknownColumns.add(cname);
                    }
                    if (cname.equals("version")) {
                        hasVersionColumn = true;
                    }
                    if (!cname.equals("sdtype")) continue;
                    hasSDTypeColumn = true;
                }
                if (!requiredColumns.isEmpty()) {
                    String message = String.format("Table %s: the following required columns are missing: %s", tableName, ((Object)requiredColumns).toString());
                    LOG.error(message);
                    throw new DocumentStoreException(message);
                }
                if (!unknownColumns.isEmpty()) {
                    String message = String.format("Table %s: the following columns are unknown and will not be maintained: %s", tableName, ((Object)unknownColumns).toString());
                    LOG.info(message);
                }
                String tableInfo = RDBJDBCTools.dumpResultSetMeta(met);
                tmd.setSchemaInfo(tableInfo);
                HashSet<String> indexOn = new HashSet<String>();
                String indexInfo = RDBDocumentStore.dumpIndexData(con.getMetaData(), met, tableName, indexOn);
                tmd.setIndexInfo(indexInfo);
                RDBJDBCTools.closeResultSet(checkResultSet);
                boolean dbWasChanged = false;
                if (this.readOnly) {
                    LOG.debug("Skipping table update code because store is initialized in readOnly mode");
                } else {
                    if (!hasVersionColumn && upgradeToSchema >= 1) {
                        dbWasChanged |= this.upgradeTable(con, tableName, 1);
                    }
                    if (!hasSDTypeColumn && upgradeToSchema >= 2) {
                        dbWasChanged |= this.upgradeTable(con, tableName, 2);
                    }
                    if (!indexOn.contains("MODIFIED") && col == Collection.NODES) {
                        dbWasChanged |= this.addModifiedIndex(con, tableName);
                    }
                }
                tablesPresent.add(tableName);
                if (!dbWasChanged) break block21;
                RDBDocumentStore.getTableMetaData(con, col, tmd);
            }
            catch (SQLException ex) {
                try {
                    con.rollback();
                    LOG.debug("trying to read from '" + tableName + "'", (Throwable)ex);
                    if (this.readOnly) {
                        throw new SQLException("Would like to create table '" + tableName + "', but RDBDocumentStore has been initialized in 'readonly' mode");
                    }
                    try {
                        creatStatement = con.createStatement();
                        creatStatement.execute(this.dbInfo.getTableCreationStatement(tableName, initialSchema));
                        creatStatement.close();
                        for (String ic : this.dbInfo.getIndexCreationStatements(tableName, initialSchema)) {
                            creatStatement = con.createStatement();
                            creatStatement.execute(ic);
                            creatStatement.close();
                        }
                        con.commit();
                        if (initialSchema < 1 && upgradeToSchema >= 1) {
                            this.upgradeTable(con, tableName, 1);
                        }
                        if (initialSchema < 2 && upgradeToSchema >= 2) {
                            this.upgradeTable(con, tableName, 2);
                        }
                        tablesCreated.add(tableName);
                        RDBDocumentStore.getTableMetaData(con, col, tmd);
                    }
                    catch (SQLException ex2) {
                        LOG.error("Failed to create table '" + tableName + "' in '" + (String)dbname + "'", (Throwable)ex2);
                        throw ex2;
                    }
                }
                catch (Throwable throwable) {
                    RDBJDBCTools.closeResultSet(checkResultSet);
                    RDBJDBCTools.closeStatement(checkStatement);
                    RDBJDBCTools.closeStatement(creatStatement);
                    throw throwable;
                }
                RDBJDBCTools.closeResultSet(checkResultSet);
                RDBJDBCTools.closeStatement(checkStatement);
                RDBJDBCTools.closeStatement(creatStatement);
            }
        }
        RDBJDBCTools.closeResultSet(checkResultSet);
        RDBJDBCTools.closeStatement(checkStatement);
        RDBJDBCTools.closeStatement(creatStatement);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean upgradeTable(Connection con, String tableName, int level) throws SQLException {
        boolean wasChanged = false;
        for (String statement : this.dbInfo.getTableUpgradeStatements(tableName, level)) {
            Statement upgradeStatement = null;
            try {
                upgradeStatement = con.createStatement();
                upgradeStatement.execute(statement);
                upgradeStatement.close();
                con.commit();
                LOG.info("Upgraded " + tableName + " to DB level " + level + " using '" + statement + "'");
                wasChanged = true;
            }
            catch (SQLException exup) {
                con.rollback();
                String message = String.format("Attempted to upgrade %s to DB level %d using '%s', but failed with SQLException '%s' (code: %d/state: %s) - will continue without.", tableName, level, statement, exup.getMessage(), exup.getErrorCode(), exup.getSQLState());
                if (LOG.isDebugEnabled()) {
                    LOG.debug(message, (Throwable)exup);
                    continue;
                }
                LOG.info(message);
            }
            finally {
                RDBJDBCTools.closeStatement(upgradeStatement);
            }
        }
        return wasChanged;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean addModifiedIndex(Connection con, String tableName) throws SQLException {
        boolean wasChanged = false;
        String statement = this.dbInfo.getModifiedIndexStatement(tableName);
        Statement upgradeStatement = null;
        try {
            upgradeStatement = con.createStatement();
            upgradeStatement.execute(statement);
            upgradeStatement.close();
            con.commit();
            LOG.info("Added 'modified' index to " + tableName + " using '" + statement + "'");
            wasChanged = true;
        }
        catch (SQLException exup) {
            con.rollback();
            String message = String.format("Attempted to add 'modified' index to %s using '%s', but failed with SQLException '%s' (code: %d/state: %s) - will continue without.", tableName, statement, exup.getMessage(), exup.getErrorCode(), exup.getSQLState());
            if (LOG.isDebugEnabled()) {
                LOG.debug(message, (Throwable)exup);
            } else {
                LOG.info(message);
            }
        }
        finally {
            RDBJDBCTools.closeStatement(upgradeStatement);
        }
        return wasChanged;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void getTableMetaData(Connection con, Collection<? extends Document> col, RDBTableMetaData tmd) throws SQLException {
        Statement checkStatement = null;
        ResultSet checkResultSet = null;
        try {
            checkStatement = con.createStatement();
            checkResultSet = checkStatement.executeQuery("select * from " + tmd.getName() + " where ID = '0'");
            ResultSetMetaData met = checkResultSet.getMetaData();
            RDBDocumentStore.obtainFlagsFromResultSetMeta(met, tmd);
            String tableInfo = RDBJDBCTools.dumpResultSetMeta(met);
            tmd.setSchemaInfo(tableInfo);
            String indexInfo = RDBDocumentStore.dumpIndexData(con.getMetaData(), met, tmd.getName(), null);
            tmd.setIndexInfo(indexInfo);
        }
        catch (Throwable throwable) {
            RDBJDBCTools.closeResultSet(checkResultSet);
            RDBJDBCTools.closeStatement(checkStatement);
            throw throwable;
        }
        RDBJDBCTools.closeResultSet(checkResultSet);
        RDBJDBCTools.closeStatement(checkStatement);
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    protected void finalize() throws Throwable {
        if (!this.ch.isClosed() && this.callStack != null) {
            LOG.debug("finalizing RDBDocumentStore that was not disposed", (Throwable)this.callStack);
        }
        super.finalize();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <T extends Document> T readDocumentCached(final Collection<T> collection, final String id, int maxCacheAge) {
        long lastCheckTime;
        if (collection != Collection.NODES) {
            return this.readDocumentUncached(collection, id, null);
        }
        NodeDocument doc = null;
        if (maxCacheAge > 0 && (doc = this.nodesCache.getIfPresent(id)) != null && (lastCheckTime = doc.getLastCheckTime()) != 0L && (maxCacheAge == Integer.MAX_VALUE || System.currentTimeMillis() - lastCheckTime < (long)maxCacheAge)) {
            this.stats.doneFindCached(Collection.NODES, id);
            return RDBDocumentStore.castAsT(RDBDocumentStore.unwrap(doc));
        }
        try (CacheLock lock = this.acquireLockFor(id);){
            NodeDocument cachedDoc;
            long lastCheckTime2;
            if (maxCacheAge == 0) {
                this.invalidateNodesCache(id, true);
                doc = null;
            }
            if ((lastCheckTime2 = (doc = this.nodesCache.get(id, new Callable<NodeDocument>(cachedDoc = doc){
                final /* synthetic */ NodeDocument val$cachedDoc;
                {
                    this.val$cachedDoc = nodeDocument;
                }

                @Override
                public NodeDocument call() throws Exception {
                    NodeDocument doc = (NodeDocument)RDBDocumentStore.this.readDocumentUncached(collection, id, this.val$cachedDoc);
                    if (doc != null) {
                        doc.seal();
                    }
                    return RDBDocumentStore.wrap(doc);
                }
            })).getLastCheckTime()) != 0L) {
                if (maxCacheAge == 0) return RDBDocumentStore.castAsT(RDBDocumentStore.unwrap(doc));
                if (maxCacheAge == Integer.MAX_VALUE) {
                    return RDBDocumentStore.castAsT(RDBDocumentStore.unwrap(doc));
                }
            }
            if (lastCheckTime2 != 0L && System.currentTimeMillis() - lastCheckTime2 < (long)maxCacheAge) {
                return RDBDocumentStore.castAsT(RDBDocumentStore.unwrap(doc));
            }
            NodeDocument ndoc = (NodeDocument)this.readDocumentUncached(collection, id, cachedDoc);
            if (ndoc != null) {
                ndoc.seal();
            }
            doc = RDBDocumentStore.wrap(ndoc);
            this.nodesCache.put(doc);
            return RDBDocumentStore.castAsT(RDBDocumentStore.unwrap(doc));
        }
        catch (ExecutionException e) {
            throw new IllegalStateException("Failed to load document with " + id, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private <T extends Document> boolean internalCreate(Collection<T> collection, List<UpdateOp> updates) {
        Stopwatch watch = this.startWatch();
        ArrayList<String> ids = new ArrayList<String>(updates.size());
        boolean success = true;
        try {
            for (List chunks : Lists.partition(updates, (int)CHUNKSIZE)) {
                ArrayList<Object> docs = new ArrayList<Object>();
                for (UpdateOp update : chunks) {
                    ids.add(update.getId());
                    this.maintainUpdateStats(collection, update.getId());
                    UpdateUtils.assertUnconditional(update);
                    Object doc = collection.newDocument(this);
                    RDBDocumentStore.addUpdateCounters(update);
                    UpdateUtils.applyChanges(doc, update);
                    if (!update.getId().equals(((Document)doc).getId())) {
                        throw new DocumentStoreException("ID mismatch - UpdateOp: " + update.getId() + ", ID property: " + ((Document)doc).getId());
                    }
                    docs.add(doc);
                }
                boolean done = this.insertDocuments(collection, docs);
                if (done) {
                    if (collection != Collection.NODES) continue;
                    for (Object doc : docs) {
                        this.nodesCache.putIfAbsent((NodeDocument)doc);
                    }
                    continue;
                }
                success = false;
            }
            boolean bl = success;
            return bl;
        }
        catch (DocumentStoreException ex) {
            boolean bl = false;
            return bl;
        }
        finally {
            this.stats.doneCreate(watch.elapsed(TimeUnit.NANOSECONDS), collection, ids, success);
        }
    }

    @Nullable
    private <T extends Document> T internalCreateOrUpdate(Collection<T> collection, UpdateOp update, boolean allowCreate, boolean checkConditions, int retries) {
        T oldDoc = this.readDocumentCached(collection, update.getId(), Integer.MAX_VALUE);
        if (oldDoc == null) {
            if (!allowCreate || !update.isNew()) {
                return null;
            }
            T doc = collection.newDocument(this);
            if (checkConditions && !UpdateUtils.checkConditions(doc, update.getConditions())) {
                return null;
            }
            RDBDocumentStore.addUpdateCounters(update);
            UpdateUtils.applyChanges(doc, update);
            try {
                Stopwatch watch = this.startWatch();
                if (!this.insertDocuments(collection, Collections.singletonList(doc))) {
                    throw new DocumentStoreException("Can't insert the document: " + ((Document)doc).getId());
                }
                if (collection == Collection.NODES) {
                    this.nodesCache.putIfAbsent((NodeDocument)doc);
                }
                this.stats.doneFindAndModify(watch.elapsed(TimeUnit.NANOSECONDS), collection, update.getId(), true, true, 0);
                return oldDoc;
            }
            catch (DocumentStoreException ex) {
                oldDoc = this.readDocumentUncached(collection, update.getId(), null);
                if (oldDoc == null) {
                    LOG.error("insert failed, but document " + update.getId() + " is not present, aborting", (Throwable)ex);
                    throw ex;
                }
                return this.internalUpdate(collection, update, oldDoc, checkConditions, retries);
            }
        }
        T result = this.internalUpdate(collection, update, oldDoc, checkConditions, retries);
        if (allowCreate && result == null) {
            if (retries > 0) {
                result = this.internalCreateOrUpdate(collection, update, allowCreate, checkConditions, retries - 1);
            } else {
                LOG.error("update of " + update.getId() + " failed, race condition?");
                throw new DocumentStoreException("update of " + update.getId() + " failed, race condition?", null, DocumentStoreException.Type.TRANSIENT);
            }
        }
        return result;
    }

    /*
     * Exception decompiling
     */
    @Nullable
    private <T extends Document> T internalUpdate(Collection<T> collection, UpdateOp update, T oldDoc, boolean checkConditions, int maxRetries) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [12[UNCONDITIONALDOLOOP]], but top level block is 5[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @NotNull
    private <T extends Document> T createNewDocument(Collection<T> collection, T oldDoc, UpdateOp update) {
        T doc = collection.newDocument(this);
        oldDoc.deepCopy((Document)doc);
        UpdateUtils.applyChanges(doc, update);
        ((Document)doc).seal();
        return doc;
    }

    private static void addUpdateCounters(UpdateOp update) {
        if (RDBDocumentStore.hasChangesToCollisions(update)) {
            update.increment(COLLISIONSMODCOUNT, 1L);
        }
        update.increment(MODCOUNT, 1L);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private <T extends Document> List<T> internalQuery(Collection<T> collection, String fromKey, String toKey, List<String> excludeKeyPatterns, List<QueryCondition> conditions, int limit) {
        connection = null;
        tmd = this.getTable(collection);
        for (QueryCondition cond : conditions) {
            if (RDBDocumentStore.INDEXEDPROPERTIES.contains(cond.getPropertyName())) continue;
            message = "indexed property " + cond.getPropertyName() + " not supported, query was '" + cond + "'; supported properties are " + RDBDocumentStore.INDEXEDPROPERTIES;
            RDBDocumentStore.LOG.info(message);
            throw new DocumentStoreException(message);
        }
        watch = this.startWatch();
        resultSize = 0;
        tracker = this.obtainTracker(collection, fromKey, toKey);
        now = System.currentTimeMillis();
        connection = this.ch.getROConnection();
        from = collection == Collection.NODES && "0000000".equals(fromKey) != false ? null : fromKey;
        to = collection == Collection.NODES && ";".equals(toKey) != false ? null : toKey;
        populateCache = to != null;
        dbresult = this.db.query(connection, tmd, from, to, excludeKeyPatterns, conditions, limit);
        connection.commit();
        size = dbresult.size();
        result = new ArrayList<T>(size);
        for (i = 0; i < size; ++i) {
            row = dbresult.set(i, null);
            doc /* !! */  = this.getIfCached(collection, row.getId(), row.getModcount());
            if (doc /* !! */  == null) {
                doc /* !! */  = this.convertFromDBObject(collection, row);
            } else {
                lastmodified = RDBDocumentStore.modifiedOf(doc /* !! */ );
                if (lastmodified == row.getModified() && lastmodified >= 1L) {
                    lock = this.acquireLockFor(row.getId());
                    try {
                        if (tracker.mightBeenAffected(row.getId())) ** GOTO lbl40
                        ((NodeDocument)doc /* !! */ ).markUpToDate(now);
                    }
                    finally {
                        if (lock != null) {
                            lock.close();
                        }
                    }
                } else {
                    doc /* !! */  = this.convertFromDBObject(collection, row);
                }
            }
lbl40:
            // 4 sources

            result.add(doc /* !! */ );
        }
        if (collection == Collection.NODES) {
            if (populateCache) {
                this.nodesCache.putNonConflictingDocs(tracker, RDBDocumentStore.castAsNodeDocumentList(result));
            } else {
                invMap = Maps.newHashMap();
                for (T doc : result) {
                    invMap.put(doc /* !! */ .getId(), new ModificationStamp(RDBDocumentStore.modcountOf(doc /* !! */ ), RDBDocumentStore.modifiedOf(doc /* !! */ )));
                }
                this.nodesCache.invalidateOutdated(invMap);
            }
        }
        resultSize = result.size();
        var20_25 = result;
        if (tracker != null) {
            tracker.close();
        }
        this.ch.closeConnection(connection);
        this.stats.doneQuery(watch.elapsed(TimeUnit.NANOSECONDS), collection, fromKey, toKey, conditions.isEmpty() == false, resultSize, -1L, false);
        return var20_25;
        {
            catch (Throwable var12_16) {
                try {
                    try {
                        if (tracker != null) {
                            try {
                                tracker.close();
                            }
                            catch (Throwable var13_32) {
                                var12_16.addSuppressed(var13_32);
                            }
                        }
                        throw var12_16;
                    }
                    catch (Exception ex) {
                        RDBDocumentStore.LOG.error("SQL exception on query", (Throwable)ex);
                        throw RDBJDBCTools.asDocumentStoreException(ex, "SQL exception on query");
                    }
                }
                catch (Throwable var28_33) {
                    this.ch.closeConnection(connection);
                    this.stats.doneQuery(watch.elapsed(TimeUnit.NANOSECONDS), collection, fromKey, toKey, conditions.isEmpty() == false, resultSize, -1L, false);
                    throw var28_33;
                }
            }
        }
    }

    protected <T extends Document> Iterable<T> queryAsIterable(final Collection<T> collection, String fromKey, String toKey, final List<String> excludeKeyPatterns, final List<QueryCondition> conditions, final int limit, final String sortBy) {
        final RDBTableMetaData tmd = this.getTable(collection);
        Sets.SetView allowedProps = Sets.intersection(INDEXEDPROPERTIES, tmd.getColumnProperties());
        for (QueryCondition cond : conditions) {
            if (allowedProps.contains(cond.getPropertyName())) continue;
            String message = "indexed property " + cond.getPropertyName() + " not supported, query was '" + cond + "'; supported properties are " + (Set)allowedProps;
            LOG.info(message);
            throw new UnsupportedIndexedPropertyException(message);
        }
        final String from = collection == Collection.NODES && "0000000".equals(fromKey) ? null : fromKey;
        final String to = collection == Collection.NODES && ";".equals(toKey) ? null : toKey;
        return new MyCloseableIterable<T>(){
            Set<Iterator<RDBRow>> returned = Sets.newHashSet();

            @Override
            public Iterator<T> iterator() {
                try {
                    Iterator<RDBRow> res = RDBDocumentStore.this.db.queryAsIterator(RDBDocumentStore.this.ch, tmd, from, to, excludeKeyPatterns, conditions, limit, sortBy);
                    this.returned.add(res);
                    Iterator tmp = Iterators.transform(res, (Function)new Function<RDBRow, T>(){

                        public T apply(RDBRow input) {
                            return RDBDocumentStore.this.convertFromDBObject(collection, input);
                        }
                    });
                    return CloseableIterator.wrap(tmp, (Closeable)((Object)res));
                }
                catch (SQLException ex) {
                    throw new RuntimeException(ex);
                }
            }

            @Override
            public void close() throws IOException {
                for (Iterator<RDBRow> rdbi : this.returned) {
                    if (!(rdbi instanceof Closeable)) continue;
                    ((Closeable)((Object)rdbi)).close();
                }
            }
        };
    }

    protected <T extends Document> long queryCount(Collection<T> collection, String fromKey, String toKey, List<String> excludeKeyPatterns, List<QueryCondition> conditions) {
        return this.internalGetAggregate(collection, "COUNT", "*", fromKey, toKey, excludeKeyPatterns, conditions);
    }

    protected <T extends Document> long getMinValue(Collection<T> collection, String field, String fromKey, String toKey, List<String> excludeKeyPatterns, List<QueryCondition> conditions) {
        return this.internalGetAggregate(collection, "MIN", field, fromKey, toKey, excludeKeyPatterns, conditions);
    }

    private <T extends Document> long internalGetAggregate(Collection<T> collection, String aggregrate, String field, String fromKey, String toKey, List<String> excludeKeyPatterns, List<QueryCondition> conditions) {
        RDBTableMetaData tmd = this.getTable(collection);
        for (QueryCondition cond : conditions) {
            if (INDEXEDPROPERTIES.contains(cond.getPropertyName())) continue;
            String message = "indexed property " + cond.getPropertyName() + " not supported, query was '" + cond + "'; supported properties are " + INDEXEDPROPERTIES;
            LOG.info(message);
            throw new DocumentStoreException(message);
        }
        String from = collection == Collection.NODES && "0000000".equals(fromKey) ? null : fromKey;
        String to = collection == Collection.NODES && ";".equals(toKey) ? null : toKey;
        Connection connection = null;
        try {
            connection = this.ch.getROConnection();
            long result = this.db.getLong(connection, tmd, aggregrate, field, from, to, excludeKeyPatterns, conditions);
            connection.commit();
            long l = result;
            return l;
        }
        catch (SQLException ex) {
            LOG.error("SQL exception on query", (Throwable)ex);
            throw RDBJDBCTools.asDocumentStoreException(ex, "SQL exception on query");
        }
        finally {
            this.ch.closeConnection(connection);
        }
    }

    @NotNull
    protected <T extends Document> RDBTableMetaData getTable(Collection<T> collection) {
        RDBTableMetaData tmd = this.tableMeta.get(collection);
        if (tmd != null) {
            return tmd;
        }
        throw new IllegalArgumentException("Unknown collection: " + collection.toString());
    }

    @Nullable
    private <T extends Document> T readDocumentUncached(Collection<T> collection, String id, NodeDocument cachedDoc) {
        T t;
        RDBRow row;
        boolean docFound;
        Stopwatch watch;
        Connection connection;
        block8: {
            long lastmodified;
            long lastmodcount;
            block7: {
                connection = null;
                RDBTableMetaData tmd = this.getTable(collection);
                watch = this.startWatch();
                docFound = true;
                lastmodcount = -1L;
                lastmodified = -1L;
                if (cachedDoc != null) {
                    lastmodcount = RDBDocumentStore.modcountOf(cachedDoc);
                    lastmodified = RDBDocumentStore.modifiedOf(cachedDoc);
                }
                connection = this.ch.getROConnection();
                row = this.db.read(connection, tmd, id, lastmodcount, lastmodified);
                connection.commit();
                if (row != null) break block7;
                docFound = false;
                T t2 = null;
                this.ch.closeConnection(connection);
                this.stats.doneFindUncached(watch.elapsed(TimeUnit.NANOSECONDS), collection, id, docFound, false);
                return t2;
            }
            if (lastmodcount != row.getModcount() || lastmodified != row.getModified() || lastmodified < 1L) break block8;
            cachedDoc.markUpToDate(System.currentTimeMillis());
            T t3 = RDBDocumentStore.castAsT(cachedDoc);
            this.ch.closeConnection(connection);
            this.stats.doneFindUncached(watch.elapsed(TimeUnit.NANOSECONDS), collection, id, docFound, false);
            return t3;
        }
        try {
            t = this.convertFromDBObject(collection, row);
            this.ch.closeConnection(connection);
            this.stats.doneFindUncached(watch.elapsed(TimeUnit.NANOSECONDS), collection, id, docFound, false);
        }
        catch (Exception ex) {
            try {
                throw RDBJDBCTools.asDocumentStoreException(ex, "exception while reading " + id);
            }
            catch (Throwable throwable) {
                this.ch.closeConnection(connection);
                this.stats.doneFindUncached(watch.elapsed(TimeUnit.NANOSECONDS), collection, id, docFound, false);
                throw throwable;
            }
        }
        return t;
    }

    private <T extends Document> void delete(Collection<T> collection, String id) {
        Connection connection = null;
        RDBTableMetaData tmd = this.getTable(collection);
        Stopwatch watch = this.startWatch();
        try {
            connection = this.ch.getRWConnection();
            this.db.delete(connection, tmd, Collections.singletonList(id));
            connection.commit();
        }
        catch (Exception ex) {
            this.ch.rollbackConnection(connection);
            throw this.handleException("removing " + id, ex, collection, id);
        }
        finally {
            this.ch.closeConnection(connection);
            this.stats.doneRemove(watch.elapsed(TimeUnit.NANOSECONDS), collection, 1);
        }
    }

    private <T extends Document> int delete(Collection<T> collection, List<String> ids) {
        int numDeleted = 0;
        RDBTableMetaData tmd = this.getTable(collection);
        for (List sublist : Lists.partition(ids, (int)64)) {
            Connection connection = null;
            Stopwatch watch = this.startWatch();
            try {
                connection = this.ch.getRWConnection();
                numDeleted += this.db.delete(connection, tmd, sublist);
                connection.commit();
            }
            catch (Exception ex) {
                this.ch.rollbackConnection(connection);
                throw this.handleException("removing " + ids, ex, collection, ids);
            }
            finally {
                this.ch.closeConnection(connection);
                this.stats.doneRemove(watch.elapsed(TimeUnit.NANOSECONDS), collection, ids.size());
            }
        }
        return numDeleted;
    }

    private <T extends Document> int delete(Collection<T> collection, Map<String, Long> toRemove) {
        int numDeleted = 0;
        RDBTableMetaData tmd = this.getTable(collection);
        HashMap subMap = Maps.newHashMap();
        Iterator<Map.Entry<String, Long>> it = toRemove.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, Long> entry = it.next();
            subMap.put(entry.getKey(), entry.getValue());
            if (subMap.size() != 64 && it.hasNext()) continue;
            Connection connection = null;
            int num = 0;
            Stopwatch watch = this.startWatch();
            try {
                connection = this.ch.getRWConnection();
                num = this.db.delete(connection, tmd, subMap);
                numDeleted += num;
                connection.commit();
            }
            catch (Exception ex) {
                this.ch.rollbackConnection(connection);
                Set<String> ids = subMap.keySet();
                throw this.handleException("deleting " + ids, ex, collection, ids);
            }
            finally {
                this.ch.closeConnection(connection);
                this.stats.doneRemove(watch.elapsed(TimeUnit.NANOSECONDS), collection, num);
            }
            subMap.clear();
        }
        return numDeleted;
    }

    private <T extends Document> int deleteWithCondition(Collection<T> collection, List<QueryCondition> conditions) {
        int numDeleted = 0;
        RDBTableMetaData tmd = this.getTable(collection);
        Stopwatch watch = this.startWatch();
        Connection connection = null;
        try {
            connection = this.ch.getRWConnection();
            numDeleted = this.db.deleteWithCondition(connection, tmd, conditions);
            connection.commit();
        }
        catch (Exception ex) {
            this.ch.rollbackConnection(connection);
            throw RDBJDBCTools.asDocumentStoreException(ex, "deleting " + collection + ": " + conditions);
        }
        finally {
            this.ch.closeConnection(connection);
            this.stats.doneRemove(watch.elapsed(TimeUnit.NANOSECONDS), collection, numDeleted);
        }
        return numDeleted;
    }

    private <T extends Document> boolean updateDocument(@NotNull Collection<T> collection, @NotNull T document, @NotNull UpdateOp update, Long oldmodcount) {
        Connection connection = null;
        RDBTableMetaData tmd = this.getTable(collection);
        String data = null;
        try {
            String appendData;
            connection = this.ch.getRWConnection();
            Number hasBinary = (Number)document.get("_bin");
            Boolean deletedOnce = (Boolean)document.get("_deletedOnce");
            Long modcount = (Long)document.get(MODCOUNT);
            Long cmodcount = (Long)document.get(COLLISIONSMODCOUNT);
            boolean success = false;
            boolean shouldRetry = true;
            if (RDBDocumentStore.isAppendableUpdate(update) && modcount % 16L != 0L && (appendData = this.ser.asString(update, tmd.getColumnOnlyProperties())).length() < tmd.getDataLimitInOctets() / 3) {
                try {
                    UpdateOp.Operation modOperation = update.getChanges().get(MODIFIEDKEY);
                    long modified = RDBDocumentStore.getModifiedFromOperation(modOperation);
                    boolean modifiedIsConditional = modOperation == null || modOperation.type != UpdateOp.Operation.Type.SET;
                    success = this.db.appendingUpdate(connection, tmd, document.getId(), modified, modifiedIsConditional, hasBinary, deletedOnce, modcount, cmodcount, oldmodcount, appendData);
                    shouldRetry = false;
                    connection.commit();
                }
                catch (SQLException ex) {
                    RDBDocumentStore.continueIfStringOverflow(ex);
                    this.ch.rollbackConnection(connection);
                    success = false;
                }
            }
            if (!success && shouldRetry) {
                data = this.ser.asString(document, tmd.getColumnOnlyProperties());
                Object m = document.get(MODIFIED);
                long modified = m instanceof Long ? (Long)m : 0L;
                success = this.db.update(connection, tmd, document.getId(), modified, hasBinary, deletedOnce, modcount, cmodcount, oldmodcount, data);
                connection.commit();
            }
            boolean bl = success;
            return bl;
        }
        catch (SQLException ex) {
            this.ch.rollbackConnection(connection);
            String addDiags = "";
            if (data != null && RDBJDBCTools.matchesSQLState(ex, "22", "72")) {
                byte[] bytes = RDBDocumentStore.asBytes(data);
                addDiags = String.format(" (DATA size in Java characters: %d, in octets: %d, computed character limit: %d)", data.length(), bytes.length, tmd.getDataLimitInOctets() / 3);
            }
            String message = String.format("Update for %s failed%s", document.getId(), addDiags);
            LOG.debug(message, (Throwable)ex);
            throw this.handleException(message, (Exception)ex, collection, document.getId());
        }
        finally {
            this.ch.closeConnection(connection);
        }
    }

    private static void continueIfStringOverflow(SQLException ex) throws SQLException {
        String state = ex.getSQLState();
        if (!("22001".equals(state) || "72000".equals(state) && 1489 == ex.getErrorCode() || "S0001".equals(state) && 2628 == ex.getErrorCode())) {
            throw ex;
        }
    }

    private static boolean isAppendableUpdate(UpdateOp update) {
        return !NOAPPEND;
    }

    private static long getModifiedFromOperation(UpdateOp.Operation op) {
        return op == null ? 0L : Long.parseLong(op.value.toString());
    }

    private <T extends Document> boolean insertDocuments(Collection<T> collection, List<T> documents) {
        Connection connection = null;
        RDBTableMetaData tmd = this.getTable(collection);
        try {
            connection = this.ch.getRWConnection();
            Set<String> insertedKeys = this.db.insert(connection, tmd, documents);
            connection.commit();
            boolean bl = insertedKeys.size() == documents.size();
            return bl;
        }
        catch (SQLException ex) {
            this.ch.rollbackConnection(connection);
            ArrayList<String> ids = new ArrayList<String>();
            for (Document doc : documents) {
                ids.add(doc.getId());
            }
            String message = String.format("insert of %s failed", ids);
            LOG.debug(message, (Throwable)ex);
            Object messages = LOG.isDebugEnabled() ? RDBJDBCTools.getAdditionalMessages(ex) : "";
            boolean dataRelated = false;
            for (SQLException walk = ex; walk != null && !dataRelated; walk = walk.getNextException()) {
                dataRelated = RDBJDBCTools.matchesSQLState(walk, "22", "72");
            }
            if (dataRelated) {
                String id = null;
                int longest = 0;
                int longestChars = 0;
                for (Document d : documents) {
                    String data = this.ser.asString(d, tmd.getColumnOnlyProperties());
                    byte[] bytes = RDBDocumentStore.asBytes(data);
                    if (bytes.length <= longest) continue;
                    longest = bytes.length;
                    longestChars = data.length();
                    id = d.getId();
                }
                String m = String.format(" (potential cause: long data for ID %s - longest octet DATA size in Java characters: %d, in octets: %d, computed character limit: %d)", id, longest, longestChars, tmd.getDataLimitInOctets() / 3);
                messages = (String)messages + m;
            }
            if (!((String)messages).isEmpty()) {
                LOG.debug("additional diagnostics: " + (String)messages);
            }
            throw this.handleException(message, (Exception)ex, collection, ids);
        }
        finally {
            this.ch.closeConnection(connection);
        }
    }

    public static byte[] asBytes(@NotNull String data) {
        byte[] byArray;
        block12: {
            byte[] bytes;
            try {
                bytes = data.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException ex) {
                LOG.error("UTF-8 not supported??", (Throwable)ex);
                throw RDBJDBCTools.asDocumentStoreException(ex, "UTF-8 not supported??");
            }
            if (NOGZIP) {
                return bytes;
            }
            ByteArrayOutputStream bos = new ByteArrayOutputStream(bytes.length / 2);
            GZIPOutputStream gos = RDBDocumentStore.asGZIPOutputStream(bos, 1);
            try {
                gos.write(bytes);
                gos.close();
                byte[] compressedBytes = bos.toByteArray();
                if (LOG.isTraceEnabled()) {
                    long ratio = 100L * (long)compressedBytes.length / (long)bytes.length;
                    LOG.trace("Gzipped {} bytes to {} ({}%)", new Object[]{bytes.length, compressedBytes.length, ratio});
                }
                byArray = compressedBytes;
                if (gos == null) break block12;
            }
            catch (Throwable throwable) {
                try {
                    if (gos != null) {
                        try {
                            gos.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ex) {
                    LOG.error("Error while gzipping contents", (Throwable)ex);
                    throw RDBJDBCTools.asDocumentStoreException(ex, "Error while gzipping contents");
                }
            }
            gos.close();
        }
        return byArray;
    }

    private static GZIPOutputStream asGZIPOutputStream(OutputStream os, final int level) throws IOException {
        return new GZIPOutputStream(os){
            {
                super(arg0);
                this.def.setLevel(level);
            }
        };
    }

    @Override
    public void setReadWriteMode(String readWriteMode) {
    }

    public void setStatsCollector(DocumentStoreStatsCollector stats) {
        this.stats = stats;
    }

    private static <T extends Document> T castAsT(NodeDocument doc) {
        return (T)doc;
    }

    private static <T extends Document> List<NodeDocument> castAsNodeDocumentList(List<T> list) {
        return list;
    }

    @Nullable
    private static NodeDocument unwrap(@NotNull NodeDocument doc) {
        return doc == NodeDocument.NULL ? null : doc;
    }

    @NotNull
    private static NodeDocument wrap(@Nullable NodeDocument doc) {
        return doc == null ? NodeDocument.NULL : doc;
    }

    @NotNull
    private static String idOf(@NotNull Document doc) {
        String id = doc.getId();
        if (id == null) {
            throw new IllegalArgumentException("non-null ID expected");
        }
        return id;
    }

    private static long modcountOf(@NotNull Document doc) {
        Long n = doc.getModCount();
        return n != null ? n : -1L;
    }

    private static long modifiedOf(@NotNull Document doc) {
        Object l = doc.get(MODIFIED);
        return l instanceof Long ? (Long)l : -1L;
    }

    @NotNull
    protected <T extends Document> T convertFromDBObject(@NotNull Collection<T> collection, @NotNull RDBRow row) {
        return this.ser.fromRow(collection, row);
    }

    private static boolean hasChangesToCollisions(UpdateOp update) {
        for (Map.Entry<UpdateOp.Key, UpdateOp.Operation> e : ((UpdateOp)Preconditions.checkNotNull((Object)update)).getChanges().entrySet()) {
            UpdateOp.Key k = e.getKey();
            UpdateOp.Operation op = e.getValue();
            if (op.type != UpdateOp.Operation.Type.SET_MAP_ENTRY || !"_collisions".equals(k.getName())) continue;
            return true;
        }
        return false;
    }

    @NotNull
    private static <T extends Document> String dumpKeysAndModcounts(Map<String, T> docs) {
        if (docs.isEmpty()) {
            return "-";
        }
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, T> e : docs.entrySet()) {
            Long mc = ((Document)e.getValue()).getModCount();
            if (sb.length() != 0) {
                sb.append(", ");
            }
            sb.append(String.format("%s (%s)", e.getKey(), mc == null ? "" : mc.toString()));
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T extends Document> void maintainUpdateStats(Collection<T> collection, String key) {
        if (collection == Collection.CLUSTER_NODES) {
            RDBDocumentStore rDBDocumentStore = this;
            synchronized (rDBDocumentStore) {
                Long old = this.cnUpdates.get(key);
                old = old == null ? Long.valueOf(1L) : old + 1L;
                this.cnUpdates.put(key, old);
            }
        }
    }

    private String getCnStats() {
        if (this.cnUpdates.isEmpty()) {
            return "";
        }
        ArrayList<Map.Entry<String, Long>> tmp = new ArrayList<Map.Entry<String, Long>>(this.cnUpdates.entrySet());
        Collections.sort(tmp, (o1, o2) -> ((String)o1.getKey()).compareTo((String)o2.getKey()));
        return " (Cluster Node updates: " + ((Object)tmp).toString() + ")";
    }

    private Stopwatch startWatch() {
        return Stopwatch.createStarted();
    }

    protected NodeDocumentCache getNodeDocumentCache() {
        return this.nodesCache;
    }

    private <T extends Document> DocumentStoreException handleException(String message, Exception ex, Collection<T> collection, java.util.Collection<String> ids) {
        if (collection == Collection.NODES) {
            for (String id : ids) {
                this.invalidateCache(collection, id, false);
            }
        }
        return RDBJDBCTools.asDocumentStoreException(ex, message);
    }

    private <T extends Document> DocumentStoreException handleException(String message, Exception ex, Collection<T> collection, String id) {
        return this.handleException(message, ex, collection, Collections.singleton(id));
    }

    private CacheLock acquireLockFor(String id) {
        return new CacheLock(this.locks, id);
    }

    static {
        HashMap<Collection<Document>, String> tmp = new HashMap<Collection<Document>, String>();
        tmp.put(Collection.CLUSTER_NODES, "CLUSTERNODES");
        tmp.put(Collection.JOURNAL, "JOURNAL");
        tmp.put(Collection.NODES, "NODES");
        tmp.put(Collection.SETTINGS, "SETTINGS");
        TABLEMAP = Collections.unmodifiableMap(tmp);
        ArrayList<String> tl = new ArrayList<String>(TABLEMAP.values());
        Collections.sort(tl);
        TABLENAMES = Collections.unmodifiableList(tl);
        LOG = LoggerFactory.getLogger(RDBDocumentStore.class);
        MODIFIEDKEY = new UpdateOp.Key(MODIFIED, null);
        EMPTY_KEY_PATTERN = Collections.emptyList();
        VERSIONPROP = "__version";
        INDEXEDPROPERTIES = new HashSet<String>(Arrays.asList(MODIFIED, "_bin", "_deletedOnce", "_sdType", "_sdMaxRevTime", VERSIONPROP));
        REQUIREDCOLUMNS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("id", "dsize", "deletedonce", "bdata", "data", "cmodcount", "modcount", "hasbinary", "modified")));
        OPTIONALCOLUMNS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("version", "sdtype", "sdmaxrevtime")));
        COLUMNPROPERTIES = new HashSet<String>(Arrays.asList(ID, "_bin", "_deletedOnce", COLLISIONSMODCOUNT, MODIFIED, MODCOUNT));
        COLUMNPROPERTIES2 = new HashSet<String>(Arrays.asList(ID, "_bin", "_deletedOnce", COLLISIONSMODCOUNT, MODIFIED, MODCOUNT, "_sdType", "_sdMaxRevTime", VERSIONPROP));
        NOGZIP = (Boolean)SystemPropertySupplier.create((String)"org.apache.jackrabbit.oak.plugins.document.rdb.RDBDocumentStore.NOGZIP", (Object)Boolean.FALSE).loggingTo(LOG).get();
        NOAPPEND = (Boolean)SystemPropertySupplier.create((String)"org.apache.jackrabbit.oak.plugins.document.rdb.RDBDocumentStore.NOAPPEND", (Object)Boolean.FALSE).loggingTo(LOG).get();
        CHUNKSIZE = (Integer)SystemPropertySupplier.create((String)"org.apache.jackrabbit.oak.plugins.document.rdb.RDBDocumentStore.CHUNKSIZE", (Object)64).loggingTo(LOG).validateWith(value -> value > 0).get();
        QUERYHITSLIMIT = (Integer)SystemPropertySupplier.create((String)"org.apache.jackrabbit.oak.plugins.document.rdb.RDBDocumentStore.QUERYHITSLIMIT", (Object)4096).loggingTo(LOG).validateWith(value -> value > 0).get();
        QUERYTIMELIMIT = (Integer)SystemPropertySupplier.create((String)"org.apache.jackrabbit.oak.plugins.document.rdb.RDBDocumentStore.QUERYTIMELIMIT", (Object)10000).loggingTo(LOG).validateWith(value -> value > 0).get();
        BATCHUPDATES = (Boolean)SystemPropertySupplier.create((String)(RDBDocumentStore.class.getName() + ".BATCHUPDATES"), (Object)Boolean.TRUE).loggingTo(LOG).formatSetMessage((name, value) -> String.format("Batch updates disabled (system property %s set to '%s')", name, value)).get();
    }

    protected static class QueryCondition {
        private final String propertyName;
        private final String operator;
        private final List<? extends Object> operands;

        public QueryCondition(String propertyName, String operator, long value) {
            this.propertyName = propertyName;
            this.operator = operator;
            this.operands = Collections.singletonList(value);
        }

        public QueryCondition(String propertyName, String operator, List<? extends Object> values) {
            this.propertyName = propertyName;
            this.operator = operator;
            this.operands = values;
        }

        public QueryCondition(String propertyName, String operator) {
            this.propertyName = propertyName;
            this.operator = operator;
            this.operands = Collections.emptyList();
        }

        public String getPropertyName() {
            return this.propertyName;
        }

        public String getOperator() {
            return this.operator;
        }

        public List<? extends Object> getOperands() {
            return this.operands;
        }

        public String toString() {
            if (this.operands.isEmpty()) {
                return String.format("%s %s", this.propertyName, this.operator);
            }
            if (this.operands.size() == 1) {
                return String.format("%s %s %s", this.propertyName, this.operator, this.operands.get(0).toString());
            }
            return String.format("%s %s %s", this.propertyName, this.operator, this.operands.toString());
        }
    }

    private static class CacheLock
    implements AutoCloseable {
        private final Lock lock;

        public CacheLock(NodeDocumentLocks locks, String id) {
            this.lock = locks.acquire(id);
        }

        @Override
        public void close() {
            this.lock.unlock();
        }
    }

    protected class UnsupportedIndexedPropertyException
    extends DocumentStoreException {
        private static final long serialVersionUID = -8392572622365260105L;

        public UnsupportedIndexedPropertyException(String message) {
            super(message);
        }
    }

    private static interface MyCloseableIterable<T>
    extends Closeable,
    Iterable<T> {
    }

    private static class IndexInformation {
        public Map<Integer, String> fields;
        public boolean nonunique;
        public String type;
        public String filterCondition;
        public int cardinality;
        public int pages;
        public Set<String> columns;
        public String tname;

        private IndexInformation() {
        }
    }

    static class RDBTableMetaData {
        private final String catalog;
        private final String name;
        private boolean idIsBinary = false;
        private boolean dataIsNChar = false;
        private boolean hasVersion = false;
        private boolean hasSplitDocs = false;
        private int dataLimitInOctets = 16384;
        private String schemaInfo = "";
        private String indexInfo = "";
        private Set<String> columnOnlyProperties = Collections.unmodifiableSet(COLUMNPROPERTIES);
        private Set<String> columnProperties = Collections.unmodifiableSet(COLUMNPROPERTIES);

        public RDBTableMetaData(@Nullable String catalog, @NotNull String name) {
            this.catalog = catalog == null ? "" : catalog;
            this.name = name;
        }

        public int getDataLimitInOctets() {
            return this.dataLimitInOctets;
        }

        public String getCatalog() {
            return this.catalog;
        }

        public Set<String> getColumnProperties() {
            return this.columnProperties;
        }

        public Set<String> getColumnOnlyProperties() {
            return this.columnOnlyProperties;
        }

        public String getIndexInfo() {
            return this.indexInfo;
        }

        public String getName() {
            return this.name;
        }

        public String getSchemaInfo() {
            return this.schemaInfo;
        }

        public boolean isDataNChar() {
            return this.dataIsNChar;
        }

        public boolean isIdBinary() {
            return this.idIsBinary;
        }

        public boolean hasSplitDocs() {
            return this.hasSplitDocs;
        }

        public boolean hasVersion() {
            return this.hasVersion;
        }

        public void setDataIsNChar(boolean dataIsNChar) {
            this.dataIsNChar = dataIsNChar;
        }

        public void setIdIsBinary(boolean idIsBinary) {
            this.idIsBinary = idIsBinary;
        }

        public void setHasSplitDocs(boolean hasSplitDocs) {
            this.hasSplitDocs = hasSplitDocs;
            this.columnProperties = Collections.unmodifiableSet(hasSplitDocs ? COLUMNPROPERTIES2 : COLUMNPROPERTIES);
        }

        public void setHasVersion(boolean hasVersion) {
            this.hasVersion = hasVersion;
        }

        public void setDataLimitInOctets(int dataLimitInOctets) {
            this.dataLimitInOctets = dataLimitInOctets;
        }

        public void setSchemaInfo(String schemaInfo) {
            this.schemaInfo = schemaInfo;
        }

        public void setIndexInfo(String indexInfo) {
            this.indexInfo = indexInfo;
        }
    }
}

