/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import org.apache.jackrabbit.guava.common.base.Preconditions;
import org.apache.jackrabbit.guava.common.base.Predicate;
import org.apache.jackrabbit.guava.common.base.Predicates;
import org.apache.jackrabbit.guava.common.base.Supplier;
import org.apache.jackrabbit.guava.common.base.Suppliers;
import org.apache.jackrabbit.guava.common.cache.Cache;
import org.apache.jackrabbit.guava.common.cache.CacheBuilder;
import org.apache.jackrabbit.guava.common.cache.RemovalCause;
import org.apache.jackrabbit.guava.common.cache.RemovalListener;
import org.apache.jackrabbit.guava.common.cache.RemovalNotification;
import org.apache.jackrabbit.guava.common.cache.Weigher;
import org.apache.jackrabbit.guava.common.util.concurrent.MoreExecutors;
import org.apache.jackrabbit.oak.cache.CacheLIRS;
import org.apache.jackrabbit.oak.cache.CacheStats;
import org.apache.jackrabbit.oak.cache.CacheValue;
import org.apache.jackrabbit.oak.cache.EmpiricalWeigher;
import org.apache.jackrabbit.oak.plugins.blob.BlobStoreStats;
import org.apache.jackrabbit.oak.plugins.blob.CachingBlobStore;
import org.apache.jackrabbit.oak.plugins.blob.ReferencedBlob;
import org.apache.jackrabbit.oak.plugins.document.BlobReferenceIterator;
import org.apache.jackrabbit.oak.plugins.document.ClusterNodeInfo;
import org.apache.jackrabbit.oak.plugins.document.DiffCache;
import org.apache.jackrabbit.oak.plugins.document.DocumentNodeState;
import org.apache.jackrabbit.oak.plugins.document.DocumentNodeStore;
import org.apache.jackrabbit.oak.plugins.document.DocumentNodeStoreStats;
import org.apache.jackrabbit.oak.plugins.document.DocumentNodeStoreStatsCollector;
import org.apache.jackrabbit.oak.plugins.document.DocumentStore;
import org.apache.jackrabbit.oak.plugins.document.DocumentStoreStats;
import org.apache.jackrabbit.oak.plugins.document.DocumentStoreStatsCollector;
import org.apache.jackrabbit.oak.plugins.document.JournalPropertyHandlerFactory;
import org.apache.jackrabbit.oak.plugins.document.LeaseCheckMode;
import org.apache.jackrabbit.oak.plugins.document.LocalDiffCache;
import org.apache.jackrabbit.oak.plugins.document.MissingLastRevSeeker;
import org.apache.jackrabbit.oak.plugins.document.NamePathRev;
import org.apache.jackrabbit.oak.plugins.document.NodeDocument;
import org.apache.jackrabbit.oak.plugins.document.Path;
import org.apache.jackrabbit.oak.plugins.document.PathRev;
import org.apache.jackrabbit.oak.plugins.document.ThrottlingStatsCollector;
import org.apache.jackrabbit.oak.plugins.document.ThrottlingStatsCollectorImpl;
import org.apache.jackrabbit.oak.plugins.document.TieredDiffCache;
import org.apache.jackrabbit.oak.plugins.document.VersionGCSupport;
import org.apache.jackrabbit.oak.plugins.document.VersionGarbageCollector;
import org.apache.jackrabbit.oak.plugins.document.cache.NodeDocumentCache;
import org.apache.jackrabbit.oak.plugins.document.locks.NodeDocumentLocks;
import org.apache.jackrabbit.oak.plugins.document.memory.MemoryDocumentStore;
import org.apache.jackrabbit.oak.plugins.document.persistentCache.CacheType;
import org.apache.jackrabbit.oak.plugins.document.persistentCache.EvictionListener;
import org.apache.jackrabbit.oak.plugins.document.persistentCache.PersistentCache;
import org.apache.jackrabbit.oak.plugins.document.persistentCache.PersistentCacheStats;
import org.apache.jackrabbit.oak.plugins.document.spi.lease.LeaseFailureHandler;
import org.apache.jackrabbit.oak.plugins.document.util.RevisionsKey;
import org.apache.jackrabbit.oak.plugins.document.util.StringValue;
import org.apache.jackrabbit.oak.spi.blob.AbstractBlobStore;
import org.apache.jackrabbit.oak.spi.blob.BlobStore;
import org.apache.jackrabbit.oak.spi.blob.MemoryBlobStore;
import org.apache.jackrabbit.oak.spi.blob.stats.BlobStatsCollector;
import org.apache.jackrabbit.oak.spi.gc.GCMonitor;
import org.apache.jackrabbit.oak.spi.gc.LoggingGCMonitor;
import org.apache.jackrabbit.oak.spi.toggle.Feature;
import org.apache.jackrabbit.oak.stats.Clock;
import org.apache.jackrabbit.oak.stats.StatisticsProvider;
import org.gradle.internal.classpath.Instrumented;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DocumentNodeStoreBuilder<T extends DocumentNodeStoreBuilder<T>> {
    private static final Logger LOG = LoggerFactory.getLogger(DocumentNodeStoreBuilder.class);
    public static final long DEFAULT_MEMORY_CACHE_SIZE = 0x10000000L;
    public static final int DEFAULT_NODE_CACHE_PERCENTAGE = 35;
    public static final int DEFAULT_PREV_DOC_CACHE_PERCENTAGE = 4;
    public static final int DEFAULT_CHILDREN_CACHE_PERCENTAGE = 15;
    public static final int DEFAULT_DIFF_CACHE_PERCENTAGE = 30;
    public static final int DEFAULT_CACHE_SEGMENT_COUNT = 16;
    public static final int DEFAULT_CACHE_STACK_MOVE_DISTANCE = 16;
    public static final int DEFAULT_UPDATE_LIMIT = 100000;
    private static final String DEFAULT_PERSISTENT_CACHE_URI = Instrumented.systemProperty((String)"oak.documentMK.persCache", (String)"org.apache.jackrabbit.oak.plugins.document.DocumentNodeStoreBuilder");
    static final int MANY_CHILDREN_THRESHOLD = Instrumented.getInteger((String)"oak.documentMK.manyChildren", (int)50, (String)"org.apache.jackrabbit.oak.plugins.document.DocumentNodeStoreBuilder");
    private static final boolean LIRS_CACHE = !Instrumented.getBoolean((String)"oak.documentMK.guavaCache", (String)"org.apache.jackrabbit.oak.plugins.document.DocumentNodeStoreBuilder");
    static final int UPDATE_LIMIT = Instrumented.getInteger((String)"update.limit", (int)100000, (String)"org.apache.jackrabbit.oak.plugins.document.DocumentNodeStoreBuilder");
    protected Supplier<DocumentStore> documentStoreSupplier = Suppliers.ofInstance((Object)new MemoryDocumentStore());
    protected Supplier<BlobStore> blobStoreSupplier;
    private DiffCache diffCache;
    private int clusterId = Instrumented.getInteger((String)"oak.documentMK.clusterId", (int)0, (String)"org.apache.jackrabbit.oak.plugins.document.DocumentNodeStoreBuilder");
    private int asyncDelay = 1000;
    private boolean timing;
    private boolean logging;
    private String loggingPrefix;
    private LeaseCheckMode leaseCheck = ClusterNodeInfo.DEFAULT_LEASE_CHECK_MODE;
    private boolean isReadOnlyMode = false;
    private Feature prefetchFeature;
    private Feature docStoreThrottlingFeature;
    private Weigher<CacheValue, CacheValue> weigher = new EmpiricalWeigher();
    private long memoryCacheSize = 0x10000000L;
    private int nodeCachePercentage = 35;
    private int prevDocCachePercentage = 4;
    private int childrenCachePercentage = 15;
    private int diffCachePercentage = 30;
    private int cacheSegmentCount = 16;
    private int cacheStackMoveDistance = 16;
    private boolean useSimpleRevision;
    private boolean disableBranches;
    private boolean prefetchExternalChanges;
    private Clock clock = Clock.SIMPLE;
    private Executor executor;
    private String persistentCacheURI = DEFAULT_PERSISTENT_CACHE_URI;
    private PersistentCache persistentCache;
    private String journalCacheURI;
    private PersistentCache journalCache;
    private LeaseFailureHandler leaseFailureHandler;
    private StatisticsProvider statisticsProvider = StatisticsProvider.NOOP;
    private BlobStoreStats blobStoreStats;
    private CacheStats blobStoreCacheStats;
    private DocumentStoreStatsCollector documentStoreStatsCollector;
    private ThrottlingStatsCollector throttlingStatsCollector;
    private DocumentNodeStoreStatsCollector nodeStoreStatsCollector;
    private Map<String, PersistentCacheStats> persistentCacheStats = new HashMap<String, PersistentCacheStats>();
    private boolean bundlingDisabled;
    private JournalPropertyHandlerFactory journalPropertyHandlerFactory = new JournalPropertyHandlerFactory();
    private int updateLimit = UPDATE_LIMIT;
    private int commitValueCacheSize = 10000;
    private boolean cacheEmptyCommitValue = false;
    private long maxRevisionAgeMillis = 86400000L;
    private long maxRevisionGCAgeMillis = TimeUnit.SECONDS.toMillis(86400L);
    private GCMonitor gcMonitor = new LoggingGCMonitor(LoggerFactory.getLogger(VersionGarbageCollector.class));
    private Predicate<Path> nodeCachePredicate = Predicates.alwaysTrue();
    private boolean clusterInvisible;
    private boolean throttlingEnabled;

    public static DocumentNodeStoreBuilder<?> newDocumentNodeStoreBuilder() {
        return new DocumentNodeStoreBuilder();
    }

    public DocumentNodeStore build() {
        return new DocumentNodeStore(this);
    }

    protected final T thisBuilder() {
        return (T)this;
    }

    public T setPersistentCache(String persistentCache) {
        this.persistentCacheURI = persistentCache;
        return this.thisBuilder();
    }

    public T setJournalCache(String journalCache) {
        this.journalCacheURI = journalCache;
        return this.thisBuilder();
    }

    public T setTiming(boolean timing) {
        this.timing = timing;
        return this.thisBuilder();
    }

    public boolean getTiming() {
        return this.timing;
    }

    public T setLogging(boolean logging) {
        this.logging = logging;
        return this.thisBuilder();
    }

    public boolean getLogging() {
        return this.logging;
    }

    public T setLoggingPrefix(String prefix) {
        this.loggingPrefix = prefix;
        return this.thisBuilder();
    }

    @Nullable
    String getLoggingPrefix() {
        return this.loggingPrefix;
    }

    @Deprecated
    public T setLeaseCheck(boolean leaseCheck) {
        this.leaseCheck = leaseCheck ? LeaseCheckMode.LENIENT : LeaseCheckMode.DISABLED;
        return this.thisBuilder();
    }

    @Deprecated
    public boolean getLeaseCheck() {
        return this.leaseCheck != LeaseCheckMode.DISABLED;
    }

    public T setLeaseCheckMode(LeaseCheckMode mode) {
        this.leaseCheck = mode;
        return this.thisBuilder();
    }

    LeaseCheckMode getLeaseCheckMode() {
        return this.leaseCheck;
    }

    public T setThrottlingEnabled(boolean b) {
        this.throttlingEnabled = b;
        return this.thisBuilder();
    }

    public boolean isThrottlingEnabled() {
        return this.throttlingEnabled;
    }

    public T setReadOnlyMode() {
        this.isReadOnlyMode = true;
        return this.thisBuilder();
    }

    public boolean getReadOnlyMode() {
        return this.isReadOnlyMode;
    }

    public T setPrefetchFeature(@Nullable Feature prefetch) {
        this.prefetchFeature = prefetch;
        return this.thisBuilder();
    }

    @Nullable
    public Feature getPrefetchFeature() {
        return this.prefetchFeature;
    }

    public T setDocStoreThrottlingFeature(@Nullable Feature docStoreThrottling) {
        this.docStoreThrottlingFeature = docStoreThrottling;
        return this.thisBuilder();
    }

    @Nullable
    public Feature getDocStoreThrottlingFeature() {
        return this.docStoreThrottlingFeature;
    }

    public T setLeaseFailureHandler(LeaseFailureHandler leaseFailureHandler) {
        this.leaseFailureHandler = leaseFailureHandler;
        return this.thisBuilder();
    }

    public LeaseFailureHandler getLeaseFailureHandler() {
        return this.leaseFailureHandler;
    }

    public T setDocumentStore(DocumentStore documentStore) {
        this.documentStoreSupplier = Suppliers.ofInstance((Object)documentStore);
        return this.thisBuilder();
    }

    public DocumentStore getDocumentStore() {
        return (DocumentStore)this.documentStoreSupplier.get();
    }

    public DiffCache getDiffCache(int clusterId) {
        if (this.diffCache == null) {
            this.diffCache = new TieredDiffCache(this, clusterId);
        }
        return this.diffCache;
    }

    public T setBlobStore(BlobStore blobStore) {
        this.blobStoreSupplier = Suppliers.ofInstance((Object)blobStore);
        return this.thisBuilder();
    }

    public BlobStore getBlobStore() {
        if (this.blobStoreSupplier == null) {
            this.blobStoreSupplier = Suppliers.ofInstance((Object)new MemoryBlobStore());
        }
        BlobStore blobStore = (BlobStore)this.blobStoreSupplier.get();
        this.configureBlobStore(blobStore);
        return blobStore;
    }

    public T setClusterId(int clusterId) {
        this.clusterId = clusterId;
        return this.thisBuilder();
    }

    public T setClusterInvisible(boolean invisible) {
        this.clusterInvisible = invisible;
        return this.thisBuilder();
    }

    public T setCacheSegmentCount(int cacheSegmentCount) {
        this.cacheSegmentCount = cacheSegmentCount;
        return this.thisBuilder();
    }

    public T setCacheStackMoveDistance(int cacheSegmentCount) {
        this.cacheStackMoveDistance = cacheSegmentCount;
        return this.thisBuilder();
    }

    public int getClusterId() {
        return this.clusterId;
    }

    public boolean isClusterInvisible() {
        return this.clusterInvisible;
    }

    public T setAsyncDelay(int asyncDelay) {
        this.asyncDelay = asyncDelay;
        return this.thisBuilder();
    }

    public int getAsyncDelay() {
        return this.asyncDelay;
    }

    public Weigher<CacheValue, CacheValue> getWeigher() {
        return this.weigher;
    }

    public T withWeigher(Weigher<CacheValue, CacheValue> weigher) {
        this.weigher = weigher;
        return this.thisBuilder();
    }

    public T memoryCacheSize(long memoryCacheSize) {
        this.memoryCacheSize = memoryCacheSize;
        return this.thisBuilder();
    }

    public T memoryCacheDistribution(int nodeCachePercentage, int prevDocCachePercentage, int childrenCachePercentage, int diffCachePercentage) {
        Preconditions.checkArgument((nodeCachePercentage >= 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((prevDocCachePercentage >= 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((childrenCachePercentage >= 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((diffCachePercentage >= 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((nodeCachePercentage + prevDocCachePercentage + childrenCachePercentage + diffCachePercentage < 100 ? 1 : 0) != 0);
        this.nodeCachePercentage = nodeCachePercentage;
        this.prevDocCachePercentage = prevDocCachePercentage;
        this.childrenCachePercentage = childrenCachePercentage;
        this.diffCachePercentage = diffCachePercentage;
        return this.thisBuilder();
    }

    public long getNodeCacheSize() {
        return this.memoryCacheSize * (long)this.nodeCachePercentage / 100L;
    }

    public long getPrevDocumentCacheSize() {
        return this.memoryCacheSize * (long)this.prevDocCachePercentage / 100L;
    }

    public long getChildrenCacheSize() {
        return this.memoryCacheSize * (long)this.childrenCachePercentage / 100L;
    }

    public long getDocumentCacheSize() {
        return this.memoryCacheSize - this.getNodeCacheSize() - this.getPrevDocumentCacheSize() - this.getChildrenCacheSize() - this.getDiffCacheSize();
    }

    public long getDiffCacheSize() {
        return this.memoryCacheSize * (long)this.diffCachePercentage / 100L;
    }

    public long getMemoryDiffCacheSize() {
        return this.getDiffCacheSize() / 2L;
    }

    public long getLocalDiffCacheSize() {
        return this.getDiffCacheSize() / 2L;
    }

    public T setUseSimpleRevision(boolean useSimpleRevision) {
        this.useSimpleRevision = useSimpleRevision;
        return this.thisBuilder();
    }

    public boolean isUseSimpleRevision() {
        return this.useSimpleRevision;
    }

    public Executor getExecutor() {
        if (this.executor == null) {
            return MoreExecutors.newDirectExecutorService();
        }
        return this.executor;
    }

    public T setExecutor(Executor executor) {
        this.executor = executor;
        return this.thisBuilder();
    }

    public T clock(Clock clock) {
        this.clock = clock;
        return this.thisBuilder();
    }

    public T setStatisticsProvider(StatisticsProvider statisticsProvider) {
        this.statisticsProvider = statisticsProvider;
        return this.thisBuilder();
    }

    public StatisticsProvider getStatisticsProvider() {
        return this.statisticsProvider;
    }

    public DocumentStoreStatsCollector getDocumentStoreStatsCollector() {
        if (this.documentStoreStatsCollector == null) {
            this.documentStoreStatsCollector = new DocumentStoreStats(this.statisticsProvider);
        }
        return this.documentStoreStatsCollector;
    }

    public T setDocumentStoreStatsCollector(DocumentStoreStatsCollector documentStoreStatsCollector) {
        this.documentStoreStatsCollector = documentStoreStatsCollector;
        return this.thisBuilder();
    }

    @NotNull
    public ThrottlingStatsCollector getThrottlingStatsCollector() {
        if (Objects.isNull(this.throttlingStatsCollector)) {
            this.throttlingStatsCollector = new ThrottlingStatsCollectorImpl(this.statisticsProvider);
        }
        return this.throttlingStatsCollector;
    }

    public T setThrottlingStatsCollector(@NotNull ThrottlingStatsCollector throttlingStatsCollector) {
        this.throttlingStatsCollector = throttlingStatsCollector;
        return this.thisBuilder();
    }

    public DocumentNodeStoreStatsCollector getNodeStoreStatsCollector() {
        if (this.nodeStoreStatsCollector == null) {
            this.nodeStoreStatsCollector = new DocumentNodeStoreStats(this.statisticsProvider);
        }
        return this.nodeStoreStatsCollector;
    }

    public T setNodeStoreStatsCollector(DocumentNodeStoreStatsCollector statsCollector) {
        this.nodeStoreStatsCollector = statsCollector;
        return this.thisBuilder();
    }

    @NotNull
    public Map<String, PersistentCacheStats> getPersistenceCacheStats() {
        return this.persistentCacheStats;
    }

    @Nullable
    public BlobStoreStats getBlobStoreStats() {
        return this.blobStoreStats;
    }

    @Nullable
    public CacheStats getBlobStoreCacheStats() {
        return this.blobStoreCacheStats;
    }

    public Clock getClock() {
        return this.clock;
    }

    public T disableBranches() {
        this.disableBranches = true;
        return this.thisBuilder();
    }

    public boolean isDisableBranches() {
        return this.disableBranches;
    }

    public T setBundlingDisabled(boolean enabled) {
        this.bundlingDisabled = enabled;
        return this.thisBuilder();
    }

    public boolean isBundlingDisabled() {
        return this.bundlingDisabled;
    }

    public T setPrefetchExternalChanges(boolean b) {
        this.prefetchExternalChanges = b;
        return this.thisBuilder();
    }

    public boolean isPrefetchExternalChanges() {
        return this.prefetchExternalChanges;
    }

    public T setJournalPropertyHandlerFactory(JournalPropertyHandlerFactory factory) {
        this.journalPropertyHandlerFactory = factory;
        return this.thisBuilder();
    }

    public JournalPropertyHandlerFactory getJournalPropertyHandlerFactory() {
        return this.journalPropertyHandlerFactory;
    }

    public T setUpdateLimit(int limit) {
        this.updateLimit = limit;
        return this.thisBuilder();
    }

    public int getUpdateLimit() {
        return this.updateLimit;
    }

    public T setCommitValueCacheSize(int cacheSize) {
        this.commitValueCacheSize = cacheSize;
        return this.thisBuilder();
    }

    public int getCommitValueCacheSize() {
        return this.commitValueCacheSize;
    }

    public T setCacheEmptyCommitValue(boolean enable) {
        this.cacheEmptyCommitValue = enable;
        return this.thisBuilder();
    }

    public boolean getCacheEmptyCommitValue() {
        return this.cacheEmptyCommitValue;
    }

    public T setJournalGCMaxAge(long maxRevisionAgeMillis) {
        this.maxRevisionAgeMillis = maxRevisionAgeMillis;
        return this.thisBuilder();
    }

    public long getJournalGCMaxAge() {
        return this.maxRevisionAgeMillis;
    }

    public T setRevisionGCMaxAge(long maxRevisionGCAgeMillis) {
        this.maxRevisionGCAgeMillis = maxRevisionGCAgeMillis;
        return this.thisBuilder();
    }

    public long getRevisionGCMaxAge() {
        return this.maxRevisionGCAgeMillis;
    }

    public T setGCMonitor(@NotNull GCMonitor gcMonitor) {
        this.gcMonitor = (GCMonitor)Preconditions.checkNotNull((Object)gcMonitor);
        return this.thisBuilder();
    }

    public GCMonitor getGCMonitor() {
        return this.gcMonitor;
    }

    public VersionGCSupport createVersionGCSupport() {
        return new VersionGCSupport(this.getDocumentStore());
    }

    public Iterable<ReferencedBlob> createReferencedBlobs(DocumentNodeStore ns) {
        return () -> new BlobReferenceIterator(ns);
    }

    public MissingLastRevSeeker createMissingLastRevSeeker() {
        return new MissingLastRevSeeker(this.getDocumentStore(), this.getClock());
    }

    public Cache<PathRev, DocumentNodeState> buildNodeCache(DocumentNodeStore store) {
        return this.buildCache(CacheType.NODE, this.getNodeCacheSize(), store, null);
    }

    public Cache<NamePathRev, DocumentNodeState.Children> buildChildrenCache(DocumentNodeStore store) {
        return this.buildCache(CacheType.CHILDREN, this.getChildrenCacheSize(), store, null);
    }

    public Cache<CacheValue, StringValue> buildMemoryDiffCache() {
        return this.buildCache(CacheType.DIFF, this.getMemoryDiffCacheSize(), null, null);
    }

    public Cache<RevisionsKey, LocalDiffCache.Diff> buildLocalDiffCache() {
        return this.buildCache(CacheType.LOCAL_DIFF, this.getLocalDiffCacheSize(), null, null);
    }

    public Cache<CacheValue, NodeDocument> buildDocumentCache(DocumentStore docStore) {
        return this.buildCache(CacheType.DOCUMENT, this.getDocumentCacheSize(), null, docStore);
    }

    public Cache<StringValue, NodeDocument> buildPrevDocumentsCache(DocumentStore docStore) {
        return this.buildCache(CacheType.PREV_DOCUMENT, this.getPrevDocumentCacheSize(), null, docStore);
    }

    public NodeDocumentCache buildNodeDocumentCache(DocumentStore docStore, NodeDocumentLocks locks) {
        Cache<CacheValue, NodeDocument> nodeDocumentsCache = this.buildDocumentCache(docStore);
        CacheStats nodeDocumentsCacheStats = new CacheStats(nodeDocumentsCache, "Document-Documents", this.getWeigher(), this.getDocumentCacheSize());
        Cache<StringValue, NodeDocument> prevDocumentsCache = this.buildPrevDocumentsCache(docStore);
        CacheStats prevDocumentsCacheStats = new CacheStats(prevDocumentsCache, "Document-PrevDocuments", this.getWeigher(), this.getPrevDocumentCacheSize());
        return new NodeDocumentCache(nodeDocumentsCache, nodeDocumentsCacheStats, prevDocumentsCache, prevDocumentsCacheStats, locks);
    }

    @Deprecated
    public T setNodeCachePredicate(Predicate<String> p) {
        this.nodeCachePredicate = input -> input != null && p.apply((Object)input.toString());
        return this.thisBuilder();
    }

    @Deprecated
    public Predicate<String> getNodeCachePredicate() {
        return input -> input != null && this.nodeCachePredicate.apply((Object)Path.fromString(input));
    }

    public T setNodeCachePathPredicate(Predicate<Path> p) {
        this.nodeCachePredicate = p;
        return this.thisBuilder();
    }

    public Predicate<Path> getNodeCachePathPredicate() {
        return this.nodeCachePredicate;
    }

    private <K extends CacheValue, V extends CacheValue> Cache<K, V> buildCache(CacheType cacheType, long maxWeight, DocumentNodeStore docNodeStore, DocumentStore docStore) {
        CopyOnWriteArraySet<EvictionListener<K, V>> listeners = new CopyOnWriteArraySet<EvictionListener<K, V>>();
        Cache<K, V> cache = this.buildCache(cacheType.name(), maxWeight, listeners);
        PersistentCache p = null;
        if (cacheType == CacheType.DIFF || cacheType == CacheType.LOCAL_DIFF) {
            p = this.getJournalCache();
        }
        if (p == null) {
            p = this.getPersistentCache();
        }
        if (p != null) {
            PersistentCacheStats stats;
            if ((cache = p.wrap(docNodeStore, docStore, cache, cacheType, this.statisticsProvider)) instanceof EvictionListener) {
                listeners.add((EvictionListener)cache);
            }
            if ((stats = PersistentCache.getPersistentCacheStats(cache)) != null) {
                this.persistentCacheStats.put(cacheType.name(), stats);
            }
        }
        return cache;
    }

    public PersistentCache getPersistentCache() {
        if (this.persistentCacheURI == null) {
            return null;
        }
        if (this.persistentCache == null) {
            try {
                this.persistentCache = new PersistentCache(this.persistentCacheURI);
            }
            catch (Throwable e) {
                LOG.warn("Persistent cache not available; please disable the configuration", e);
                throw new IllegalArgumentException(e);
            }
        }
        return this.persistentCache;
    }

    PersistentCache getJournalCache() {
        if (this.journalCacheURI == null) {
            return null;
        }
        if (this.journalCache == null) {
            try {
                this.journalCache = new PersistentCache(this.journalCacheURI);
            }
            catch (Throwable e) {
                LOG.warn("Journal cache not available; please disable the configuration", e);
                throw new IllegalArgumentException(e);
            }
        }
        return this.journalCache;
    }

    private <K extends CacheValue, V extends CacheValue> Cache<K, V> buildCache(String module, long maxWeight, final Set<EvictionListener<K, V>> listeners) {
        if (LIRS_CACHE && maxWeight > 0L) {
            return CacheLIRS.newBuilder().module(module).weigher(new Weigher<K, V>(){

                public int weigh(K key, V value) {
                    return DocumentNodeStoreBuilder.this.weigher.weigh(key, value);
                }
            }).averageWeight(2000).maximumWeight(maxWeight).segmentCount(this.cacheSegmentCount).stackMoveDistance(this.cacheStackMoveDistance).recordStats().evictionCallback(new CacheLIRS.EvictionCallback<K, V>(){

                public void evicted(K key, V value, RemovalCause cause) {
                    for (EvictionListener l : listeners) {
                        l.evicted(key, value, cause);
                    }
                }
            }).build();
        }
        return CacheBuilder.newBuilder().concurrencyLevel(this.cacheSegmentCount).weigher(this.weigher).maximumWeight(maxWeight).recordStats().removalListener(new RemovalListener<K, V>(){

            public void onRemoval(RemovalNotification<K, V> notification) {
                for (EvictionListener l : listeners) {
                    l.evicted((CacheValue)notification.getKey(), (CacheValue)notification.getValue(), notification.getCause());
                }
            }
        }).build();
    }

    private void configureBlobStore(BlobStore blobStore) {
        if (blobStore instanceof AbstractBlobStore) {
            this.blobStoreStats = new BlobStoreStats(this.statisticsProvider);
            ((AbstractBlobStore)blobStore).setStatsCollector((BlobStatsCollector)this.blobStoreStats);
        }
        if (blobStore instanceof CachingBlobStore) {
            this.blobStoreCacheStats = ((CachingBlobStore)blobStore).getCacheStats();
        }
    }
}

