/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.security.authentication.credentials;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import javax.jcr.Credentials;
import org.apache.jackrabbit.guava.common.collect.ImmutableMap;
import org.apache.jackrabbit.guava.common.collect.ImmutableSet;
import org.apache.jackrabbit.guava.common.collect.Maps;
import org.apache.jackrabbit.guava.common.collect.Sets;
import org.apache.jackrabbit.oak.spi.security.authentication.credentials.CredentialsSupport;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CompositeCredentialsSupport
implements CredentialsSupport {
    @NotNull
    private final Supplier<Collection<CredentialsSupport>> credentialSupplier;

    private CompositeCredentialsSupport(@NotNull Supplier<Collection<CredentialsSupport>> credentialSupplier) {
        this.credentialSupplier = credentialSupplier;
    }

    public static CredentialsSupport newInstance(@NotNull Supplier<Collection<CredentialsSupport>> credentialSupplier) {
        return new CompositeCredentialsSupport(credentialSupplier);
    }

    @Override
    @NotNull
    public Set<Class> getCredentialClasses() {
        Collection<CredentialsSupport> all = this.credentialSupplier.get();
        if (all.isEmpty()) {
            return ImmutableSet.of();
        }
        if (all.size() == 1) {
            return all.iterator().next().getCredentialClasses();
        }
        HashSet classes = Sets.newHashSet();
        for (CredentialsSupport c : all) {
            classes.addAll(c.getCredentialClasses());
        }
        return classes;
    }

    @Override
    @Nullable
    public String getUserId(@NotNull Credentials credentials) {
        Collection<CredentialsSupport> all = this.credentialSupplier.get();
        for (CredentialsSupport c : all) {
            String userId = c.getUserId(credentials);
            if (userId == null) continue;
            return userId;
        }
        return null;
    }

    @Override
    @NotNull
    public Map<String, ?> getAttributes(@NotNull Credentials credentials) {
        Collection<CredentialsSupport> all = this.credentialSupplier.get();
        if (all.isEmpty()) {
            return ImmutableMap.of();
        }
        if (all.size() == 1) {
            return all.iterator().next().getAttributes(credentials);
        }
        HashMap attrs = Maps.newHashMap();
        for (CredentialsSupport c : all) {
            attrs.putAll(c.getAttributes(credentials));
        }
        return attrs;
    }

    @Override
    public boolean setAttributes(@NotNull Credentials credentials, @NotNull Map<String, ?> attributes) {
        boolean set = false;
        Collection<CredentialsSupport> all = this.credentialSupplier.get();
        for (CredentialsSupport c : all) {
            set = c.setAttributes(credentials, attributes) || set;
        }
        return set;
    }
}

