/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.questionreply.service;

import java.sql.Connection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.silverpeas.components.questionreply.QuestionReplyException;
import org.silverpeas.components.questionreply.model.Question;
import org.silverpeas.components.questionreply.service.QuestionHeader;
import org.silverpeas.components.questionreply.service.QuestionManagerProvider;
import org.silverpeas.core.ResourceReference;
import org.silverpeas.core.annotation.Service;
import org.silverpeas.core.contribution.contentcontainer.content.AbstractSilverpeasContentManager;
import org.silverpeas.core.contribution.contentcontainer.content.ContentManagerException;
import org.silverpeas.core.contribution.contentcontainer.content.SilverContentVisibility;
import org.silverpeas.core.contribution.model.Contribution;
import org.silverpeas.core.persistence.jdbc.bean.IdPK;
import org.silverpeas.kernel.logging.SilverLogger;

@Service
public class QuestionReplyContentManager
extends AbstractSilverpeasContentManager {
    private static final String CONTENT_ICON_FILE_NAME = "questionReplySmall.gif";

    protected QuestionReplyContentManager() {
    }

    protected String getContentIconFileName(String componentInstanceId) {
        return CONTENT_ICON_FILE_NAME;
    }

    protected Optional<Contribution> getContribution(String resourceId, String componentInstanceId) {
        List<Contribution> contributions = this.getAccessibleContributions(Collections.singletonList(new ResourceReference(resourceId, componentInstanceId)), null);
        return contributions.isEmpty() ? Optional.empty() : Optional.of(contributions.get(0));
    }

    protected List<Contribution> getAccessibleContributions(List<ResourceReference> resourceReferences, String currentUserId) {
        try {
            List<String> resourceIds = resourceReferences.stream().map(ResourceReference::getLocalId).collect(Collectors.toList());
            return QuestionManagerProvider.getQuestionManager().getQuestionsByIds(resourceIds).stream().map(q -> new QuestionHeader((Question)((Object)q), q.getInstanceId(), q.getCreationDate(), q.getCreatorId())).collect(Collectors.toList());
        }
        catch (QuestionReplyException e) {
            SilverLogger.getLogger((Object)((Object)this)).error((Throwable)((Object)e));
            return Collections.emptyList();
        }
    }

    protected void createSilverContent(Connection con, Question question) throws ContentManagerException {
        SilverContentVisibility scv = new SilverContentVisibility(this.isVisible(question));
        this.getContentManager().addSilverContent(con, question.getPK().getId(), question.getInstanceId(), question.getCreatorId(), scv);
    }

    protected void updateSilverContentVisibility(Question question) throws ContentManagerException {
        int silverContentId = this.getContentManager().getSilverContentId(question.getPK().getId(), question.getPK().getComponentName());
        SilverContentVisibility scv = new SilverContentVisibility(this.isVisible(question));
        this.getContentManager().updateSilverContentVisibilityAttributes(scv, silverContentId);
    }

    protected void deleteSilverContent(Connection con, IdPK pk) throws ContentManagerException {
        this.deleteSilverContent(con, pk.getId(), pk.getComponentName());
    }

    private boolean isVisible(Question question) {
        return question.getPublicReplyNumber() != 0;
    }
}

