/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.atlas.iterator;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.Function;

public class IteratorFlatMap<IN, OUT>
implements Iterator<OUT> {
    private boolean finished = false;
    private Iterator<OUT> current = null;
    private Iterator<IN> input;
    private final Function<IN, Iterator<OUT>> mapper;

    public IteratorFlatMap(Iterator<IN> iter, Function<IN, Iterator<OUT>> mapper) {
        this.input = iter;
        this.mapper = mapper;
    }

    @Override
    public boolean hasNext() {
        if (this.finished) {
            return false;
        }
        if (this.current != null && this.current.hasNext()) {
            return true;
        }
        while (this.input.hasNext()) {
            IN x = this.input.next();
            this.current = this.mapper.apply(x);
            if (this.current == null || !this.current.hasNext()) continue;
            return true;
        }
        this.current = null;
        this.finished = true;
        return false;
    }

    @Override
    public OUT next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return this.current.next();
    }
}

