/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.counter;

import org.apache.jackrabbit.oak.api.CommitFailedException;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.plugins.index.IndexUpdateCallback;
import org.apache.jackrabbit.oak.plugins.index.counter.ApproximateCounter;
import org.apache.jackrabbit.oak.plugins.index.counter.SipHash;
import org.apache.jackrabbit.oak.plugins.index.counter.jmx.NodeCounter;
import org.apache.jackrabbit.oak.spi.commit.Editor;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.jetbrains.annotations.Nullable;

@Deprecated
public class NodeCounterEditorOld
implements Editor {
    public static final String DATA_NODE_NAME = ":index";
    public static final String COUNT_PROPERTY_NAME = ":count";
    public static final String COUNT_HASH_PROPERTY_NAME = ":cnt";
    public static final int DEFAULT_RESOLUTION = 1000;
    private final NodeCounterRoot root;
    private final NodeCounterEditorOld parent;
    private final String name;
    private long countOffset;
    private SipHash hash;

    public NodeCounterEditorOld(NodeCounterRoot root, NodeCounterEditorOld parent, String name, SipHash hash) {
        this.parent = parent;
        this.root = root;
        this.name = name;
        this.hash = hash;
    }

    private SipHash getHash() {
        if (this.hash != null) {
            return this.hash;
        }
        SipHash h = this.parent == null ? new SipHash(this.root.seed) : new SipHash(this.parent.getHash(), this.name.hashCode());
        this.hash = h;
        return h;
    }

    public void enter(NodeState before, NodeState after) throws CommitFailedException {
    }

    public void leave(NodeState before, NodeState after) throws CommitFailedException {
        if (NodeCounter.COUNT_HASH) {
            this.leaveNew(before, after);
            return;
        }
        this.leaveOld(before, after);
    }

    private void leaveOld(NodeState before, NodeState after) throws CommitFailedException {
        long offset = ApproximateCounter.calculateOffset(this.countOffset, this.root.resolution);
        if (offset == 0L) {
            return;
        }
        NodeBuilder builder = this.getBuilder();
        PropertyState p = builder.getProperty(COUNT_PROPERTY_NAME);
        long count = p == null ? 0L : (Long)p.getValue(Type.LONG);
        offset = ApproximateCounter.adjustOffset(count, offset, this.root.resolution);
        if (offset == 0L) {
            return;
        }
        this.root.callback.indexUpdate();
        if ((count += offset) == 0L) {
            if (builder.getChildNodeCount(1L) >= 0L) {
                builder.removeProperty(COUNT_PROPERTY_NAME);
            } else {
                builder.remove();
            }
        } else {
            builder.setProperty(COUNT_PROPERTY_NAME, (Object)count);
        }
    }

    public void leaveNew(NodeState before, NodeState after) throws CommitFailedException {
        if (this.countOffset == 0L) {
            return;
        }
        NodeBuilder builder = this.getBuilder();
        PropertyState p = builder.getProperty(COUNT_HASH_PROPERTY_NAME);
        long count = p == null ? 0L : (Long)p.getValue(Type.LONG);
        this.root.callback.indexUpdate();
        if ((count += this.countOffset) <= 0L) {
            if (builder.getChildNodeCount(1L) >= 0L) {
                builder.removeProperty(COUNT_HASH_PROPERTY_NAME);
            } else {
                builder.remove();
            }
        } else {
            builder.setProperty(COUNT_HASH_PROPERTY_NAME, (Object)count);
        }
    }

    private NodeBuilder getBuilder() {
        if (this.parent == null) {
            return this.root.definition.child(DATA_NODE_NAME);
        }
        return this.parent.getBuilder().child(this.name);
    }

    public void propertyAdded(PropertyState after) throws CommitFailedException {
    }

    public void propertyChanged(PropertyState before, PropertyState after) throws CommitFailedException {
    }

    public void propertyDeleted(PropertyState before) throws CommitFailedException {
    }

    @Nullable
    public Editor childNodeChanged(String name, NodeState before, NodeState after) throws CommitFailedException {
        return this.getChildIndexEditor(name, null);
    }

    @Nullable
    public Editor childNodeAdded(String name, NodeState after) throws CommitFailedException {
        if (NodeCounter.COUNT_HASH) {
            SipHash h = new SipHash(this.getHash(), name.hashCode());
            if ((h.hashCode() & this.root.bitMask) == 0) {
                this.count(this.root.bitMask + 1);
            }
            return this.getChildIndexEditor(name, h);
        }
        this.count(1);
        return this.getChildIndexEditor(name, null);
    }

    @Nullable
    public Editor childNodeDeleted(String name, NodeState before) throws CommitFailedException {
        if (NodeCounter.COUNT_HASH) {
            SipHash h = new SipHash(this.getHash(), name.hashCode());
            if ((h.hashCode() & this.root.bitMask) == 0) {
                this.count(-(this.root.bitMask + 1));
            }
            return this.getChildIndexEditor(name, h);
        }
        this.count(-1);
        return this.getChildIndexEditor(name, null);
    }

    private void count(int offset) {
        this.countOffset += (long)offset;
        if (this.parent != null) {
            this.parent.count(offset);
        }
    }

    private Editor getChildIndexEditor(String name, SipHash hash) {
        return new NodeCounterEditorOld(this.root, this, name, hash);
    }

    public static class NodeCounterRoot {
        final int resolution;
        final long seed;
        final int bitMask;
        final NodeBuilder definition;
        final NodeState root;
        final IndexUpdateCallback callback;

        NodeCounterRoot(int resolution, long seed, NodeBuilder definition, NodeState root, IndexUpdateCallback callback) {
            this.resolution = resolution;
            this.seed = seed;
            this.bitMask = Integer.highestOneBit(resolution) * 2 - 1;
            this.definition = definition;
            this.root = root;
            this.callback = callback;
        }
    }
}

