/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document;

import java.util.concurrent.TimeUnit;

public class VersionGCOptions {
    public final int overflowToDiskThreshold;
    public final long collectLimit;
    public final long precisionMs;
    public final int maxIterations;
    public final long maxDurationMs;
    public final double delayFactor;

    public VersionGCOptions() {
        this(100000, 100000L, TimeUnit.MINUTES.toMillis(1L), 0, TimeUnit.HOURS.toMillis(0L), 0.0);
    }

    private VersionGCOptions(int overflow, long collectLimit, long precisionMs, int maxIterations, long maxDurationMs, double delayFactor) {
        this.overflowToDiskThreshold = overflow;
        this.collectLimit = collectLimit;
        this.precisionMs = precisionMs;
        this.maxIterations = maxIterations;
        this.maxDurationMs = maxDurationMs;
        this.delayFactor = delayFactor;
    }

    public VersionGCOptions withOverflowToDiskThreshold(int overflowToDiskThreshold) {
        return new VersionGCOptions(overflowToDiskThreshold, this.collectLimit, this.precisionMs, this.maxIterations, this.maxDurationMs, this.delayFactor);
    }

    public VersionGCOptions withCollectLimit(long limit) {
        return new VersionGCOptions(this.overflowToDiskThreshold, limit, this.precisionMs, this.maxIterations, this.maxDurationMs, this.delayFactor);
    }

    public VersionGCOptions withPrecisionMs(TimeUnit unit, long t) {
        return new VersionGCOptions(this.overflowToDiskThreshold, this.collectLimit, unit.toMillis(t), this.maxIterations, this.maxDurationMs, this.delayFactor);
    }

    public VersionGCOptions withMaxDuration(TimeUnit unit, long t) {
        return new VersionGCOptions(this.overflowToDiskThreshold, this.collectLimit, this.precisionMs, this.maxIterations, unit.toMillis(t), this.delayFactor);
    }

    public VersionGCOptions withMaxIterations(int max) {
        return new VersionGCOptions(this.overflowToDiskThreshold, this.collectLimit, this.precisionMs, this.maxIterations, max, this.delayFactor);
    }

    public VersionGCOptions withDelayFactor(double f) {
        return new VersionGCOptions(this.overflowToDiskThreshold, this.collectLimit, this.precisionMs, this.maxIterations, this.maxDurationMs, f);
    }
}

