/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfdom.dom.element.text;

import org.odftoolkit.odfdom.dom.DefaultElementVisitor;
import org.odftoolkit.odfdom.dom.OdfDocumentNamespace;
import org.odftoolkit.odfdom.dom.attribute.text.TextStyleNameAttribute;
import org.odftoolkit.odfdom.dom.element.OdfStylableElement;
import org.odftoolkit.odfdom.dom.element.text.TextRubyBaseElement;
import org.odftoolkit.odfdom.dom.element.text.TextRubyTextElement;
import org.odftoolkit.odfdom.dom.style.OdfStyleFamily;
import org.odftoolkit.odfdom.pkg.ElementVisitor;
import org.odftoolkit.odfdom.pkg.OdfFileDom;
import org.odftoolkit.odfdom.pkg.OdfName;
import org.w3c.dom.Node;

public class TextRubyElement
extends OdfStylableElement {
    public static final OdfName ELEMENT_NAME = OdfName.newName(OdfDocumentNamespace.TEXT, "ruby");

    public TextRubyElement(OdfFileDom ownerDoc) {
        super(ownerDoc, ELEMENT_NAME, OdfStyleFamily.Ruby, OdfName.newName(OdfDocumentNamespace.TEXT, "style-name"));
    }

    @Override
    public OdfName getOdfName() {
        return ELEMENT_NAME;
    }

    public String getTextStyleNameAttribute() {
        TextStyleNameAttribute attr = (TextStyleNameAttribute)this.getOdfAttribute(OdfDocumentNamespace.TEXT, "style-name");
        if (attr != null) {
            return String.valueOf(attr.getValue());
        }
        return null;
    }

    public void setTextStyleNameAttribute(String textStyleNameValue) {
        TextStyleNameAttribute attr = new TextStyleNameAttribute((OdfFileDom)this.ownerDocument);
        this.setOdfAttribute(attr);
        attr.setValue(textStyleNameValue);
    }

    public TextRubyBaseElement newTextRubyBaseElement() {
        TextRubyBaseElement textRubyBase = ((OdfFileDom)this.ownerDocument).newOdfElement(TextRubyBaseElement.class);
        this.appendChild((Node)((Object)textRubyBase));
        return textRubyBase;
    }

    public TextRubyTextElement newTextRubyTextElement() {
        TextRubyTextElement textRubyText = ((OdfFileDom)this.ownerDocument).newOdfElement(TextRubyTextElement.class);
        this.appendChild((Node)((Object)textRubyText));
        return textRubyText;
    }

    @Override
    public void accept(ElementVisitor visitor) {
        if (visitor instanceof DefaultElementVisitor) {
            DefaultElementVisitor defaultVisitor = (DefaultElementVisitor)visitor;
            defaultVisitor.visit(this);
        } else {
            visitor.visit(this);
        }
    }
}

