/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.gallery.constant;

import java.net.URI;
import javax.ws.rs.core.UriBuilder;
import org.silverpeas.components.gallery.constant.MediaResolution;
import org.silverpeas.components.gallery.model.AlbumDetail;
import org.silverpeas.components.gallery.model.Media;
import org.silverpeas.core.io.media.video.ThumbnailPeriod;
import org.silverpeas.core.node.model.NodePK;
import org.silverpeas.core.web.SilverpeasWebResource;

public final class GalleryResourceURIs {
    public static final String GALLERY_BASE_URI = "gallery";
    public static final String GALLERY_ALBUMS_URI_PART = "albums";
    public static final String GALLERY_PHOTOS_PART = "photos";
    public static final String GALLERY_PHOTO_RESOLUTION_PARAM = "resolution";
    public static final String GALLERY_VIDEOS_PART = "videos";
    public static final String GALLERY_SOUNDS_PART = "sounds";
    public static final String GALLERY_MEDIA_CONTENT_PART = "content";
    public static final String GALLERY_MEDIA_EMBED_PART = "embed";
    public static final String GALLERY_STREAMINGS_PART = "streamings";
    public static final String GALLERY_MEDIA_THUMBNAIL_PART = "thumbnail";
    public static final String GALLERY_STREAMING_PROVIDER_DATA_PART = "providerData";

    public static URI buildAlbumURI(AlbumDetail album) {
        if (album == null) {
            return null;
        }
        return GalleryResourceURIs.buildAlbumURI(album.getNodePK());
    }

    public static URI buildAlbumURI(NodePK albumPk) {
        if (albumPk == null) {
            return null;
        }
        return SilverpeasWebResource.getBasePathBuilder().path(GALLERY_BASE_URI).path(albumPk.getInstanceId()).path(GALLERY_ALBUMS_URI_PART).path(albumPk.getId()).build(new Object[0]);
    }

    public static URI buildMediaInAlbumURI(AlbumDetail album, Media media) {
        if (album == null || media == null) {
            return null;
        }
        return UriBuilder.fromUri((URI)GalleryResourceURIs.buildAlbumURI(album)).path(media.getType().getMediaWebUriPart()).path(media.getId()).build(new Object[0]);
    }

    public static URI buildMediaContentURI(Media media, MediaResolution mediaResolution) {
        if (media == null) {
            return null;
        }
        UriBuilder uriBuilder = SilverpeasWebResource.getBasePathBuilder().path(GALLERY_BASE_URI).path(media.getInstanceId()).path(media.getType().getMediaWebUriPart()).path(media.getId()).path(GALLERY_MEDIA_CONTENT_PART).queryParam("_t", new Object[]{media.getLastUpdateDate().getTime()});
        if (mediaResolution != null && mediaResolution != MediaResolution.ORIGINAL) {
            uriBuilder.queryParam(GALLERY_PHOTO_RESOLUTION_PARAM, new Object[]{mediaResolution});
        }
        return uriBuilder.build(new Object[0]);
    }

    public static URI buildMediaEmbedURI(Media media, MediaResolution mediaResolution) {
        if (media == null) {
            return null;
        }
        UriBuilder uriBuilder = SilverpeasWebResource.getBasePathBuilder().path(GALLERY_BASE_URI).path(media.getInstanceId()).path(media.getType().getMediaWebUriPart()).path(media.getId()).path(GALLERY_MEDIA_EMBED_PART);
        if (mediaResolution != null && mediaResolution != MediaResolution.ORIGINAL) {
            uriBuilder.queryParam(GALLERY_PHOTO_RESOLUTION_PARAM, new Object[]{mediaResolution});
        }
        return uriBuilder.build(new Object[0]);
    }

    public static URI buildVideoThumbnailURI(Media media, ThumbnailPeriod thumbnail) {
        if (media == null) {
            return null;
        }
        UriBuilder uriBuilder = SilverpeasWebResource.getBasePathBuilder().path(GALLERY_BASE_URI).path(media.getInstanceId()).path(media.getType().getMediaWebUriPart()).path(media.getId()).path(GALLERY_MEDIA_THUMBNAIL_PART).path(Integer.toString(thumbnail.getIndex())).queryParam("_t", new Object[]{media.getLastUpdateDate().getTime()});
        return uriBuilder.build(new Object[0]);
    }

    private GalleryResourceURIs() {
    }
}

