/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment.standby.codec;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToByteEncoder;
import io.netty.util.CharsetUtil;
import org.apache.jackrabbit.oak.segment.standby.codec.GetHeadResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetHeadResponseEncoder
extends MessageToByteEncoder<GetHeadResponse> {
    private static final Logger log = LoggerFactory.getLogger(GetHeadResponseEncoder.class);

    protected void encode(ChannelHandlerContext ctx, GetHeadResponse msg, ByteBuf out) throws Exception {
        log.debug("Sending head {} to client {}", (Object)msg.getHeadRecordId(), (Object)msg.getClientId());
        byte[] body = msg.getHeadRecordId().getBytes(CharsetUtil.UTF_8);
        out.writeInt(body.length + 1);
        out.writeByte(0);
        out.writeBytes(body);
    }
}

