/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.web.token;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.inject.Singleton;
import org.silverpeas.core.annotation.Bean;
import org.silverpeas.core.util.ServiceProvider;
import org.silverpeas.kernel.annotation.Technical;

@Technical
@Bean
@Singleton
public class SilverpeasWebTokenService {
    protected static final int MAX_TOKENS_PER_ID = 10;
    private final Repository repository = new Repository();

    public static SilverpeasWebTokenService get() {
        return (SilverpeasWebTokenService)ServiceProvider.getService(SilverpeasWebTokenService.class, (Annotation[])new Annotation[0]);
    }

    public WebToken generateFor(String identifier) {
        WebToken token = new WebToken(identifier);
        this.repository.register(token);
        return token;
    }

    public Optional<String> consumeIdentifierBy(String tokenValue) {
        return this.repository.consume(tokenValue).map(WebToken::getId);
    }

    public void revokeById(String id) {
        this.repository.removeAllById(id);
    }

    private static class Repository {
        private final Map<String, WebToken> byTokens = Collections.synchronizedMap(new HashMap(2000));
        private final Map<String, Set<WebToken>> byIds = Collections.synchronizedMap(new HashMap(2000));

        private Repository() {
        }

        protected void register(WebToken token) {
            this.byTokens.put(token.value, token);
            this.byIds.compute(token.id, (s, l) -> {
                Set<WebToken> tokenList;
                Set<WebToken> set = tokenList = l == null ? Collections.synchronizedSet(new TreeSet()) : l;
                if (tokenList.size() >= 10) {
                    this.removeByToken(((WebToken)tokenList.iterator().next()).getValue());
                }
                tokenList.add(token);
                return tokenList;
            });
        }

        protected Optional<WebToken> consume(String tokenValue) {
            return this.removeByToken(tokenValue);
        }

        private Optional<WebToken> removeByToken(String tokenValue) {
            return Optional.ofNullable(this.byTokens.remove(tokenValue)).map(t -> {
                Optional.ofNullable(this.byIds.get(t.getId())).ifPresent(s -> {
                    s.removeIf(l -> l.getValue().equals(tokenValue));
                    if (s.isEmpty()) {
                        this.byIds.remove(t.getId());
                    }
                });
                return t;
            });
        }

        protected void removeAllById(String id) {
            Optional.ofNullable(this.byIds.remove(id)).stream().flatMap(Collection::stream).map(WebToken::getValue).forEach(this.byTokens::remove);
        }
    }

    public static class WebToken
    implements Serializable,
    Comparable<WebToken> {
        private static final long serialVersionUID = -9174043216375231076L;
        private final String timestamp = LocalDateTime.now().toString();
        private final String value = UUID.randomUUID().toString();
        private final String id;

        private WebToken(String id) {
            this.id = id;
        }

        public String getValue() {
            return this.value;
        }

        protected String getId() {
            return this.id;
        }

        @Override
        public int compareTo(@Nonnull WebToken o) {
            return this.timestamp.compareTo(o.timestamp);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            WebToken that = (WebToken)o;
            return this.value.equals(that.value);
        }

        public int hashCode() {
            return Objects.hash(this.value);
        }
    }
}

