/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.suggestionbox.model;

import javax.persistence.Column;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.silverpeas.components.suggestionbox.model.SuggestionBox;
import org.silverpeas.components.suggestionbox.repository.SuggestionRepository;
import org.silverpeas.core.admin.user.model.SilverpeasRole;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.contribution.ValidableContribution;
import org.silverpeas.core.contribution.model.ContributionIdentifier;
import org.silverpeas.core.contribution.model.ContributionValidation;
import org.silverpeas.core.contribution.model.SilverpeasContent;
import org.silverpeas.core.contribution.rating.model.ContributionRating;
import org.silverpeas.core.contribution.rating.model.Rateable;
import org.silverpeas.core.persistence.Transaction;
import org.silverpeas.core.persistence.datasource.model.identifier.UuidIdentifier;
import org.silverpeas.core.persistence.datasource.model.jpa.SilverpeasJpaEntity;

@Entity
@Table(name="sc_suggestion")
public class Suggestion
extends SilverpeasJpaEntity<Suggestion, UuidIdentifier>
implements ValidableContribution,
SilverpeasContent,
Rateable {
    private static final long serialVersionUID = -8559980140411995766L;
    public static final String TYPE = "Suggestion";
    public static final Suggestion NONE = new Suggestion();
    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="suggestionBoxId", referencedColumnName="id", nullable=false)
    private SuggestionBox suggestionBox;
    @Column(name="title", nullable=false)
    @Size(min=1)
    @NotNull
    private @Size(min=1) @NotNull String title;
    @Embedded
    private final ContributionValidation validation = new ContributionValidation();
    @Transient
    private String content = "";
    @Transient
    private boolean contentModified = false;
    @Transient
    private int commentCount;
    @Transient
    private ContributionRating contributionRating;

    public static Suggestion getById(String identifier) {
        Suggestion suggestion = SuggestionRepository.get().getById(identifier);
        return suggestion == null ? NONE : suggestion;
    }

    protected Suggestion() {
    }

    public Suggestion(String title) {
        this.title = title;
    }

    public SuggestionBox getSuggestionBox() {
        return this.suggestionBox;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String newTitle) {
        this.title = newTitle;
    }

    public void setContent(String content) {
        String contentToSet;
        String string = contentToSet = content == null ? "" : content;
        if (!contentToSet.equals(this.content)) {
            this.content = contentToSet;
            this.contentModified = true;
        }
    }

    public String getContent() {
        return this.content == null ? "" : this.content;
    }

    public void setCommentCount(int count) {
        this.commentCount = Math.max(count, 0);
    }

    public int getCommentCount() {
        return this.commentCount;
    }

    public ContributionRating getRating() {
        return this.contributionRating;
    }

    public void setRating(ContributionRating contributionRating) {
        this.contributionRating = contributionRating;
    }

    public ContributionValidation getValidation() {
        return this.validation;
    }

    public boolean isDefined() {
        return this != NONE;
    }

    public boolean isNotDefined() {
        return this == NONE;
    }

    public void save() {
        Suggestion suggestion = this;
        Transaction.performInOne(() -> {
            SuggestionRepository.get().save(suggestion);
            return null;
        });
    }

    protected void setSuggestionBox(SuggestionBox box) {
        this.suggestionBox = box;
    }

    public boolean isContentModified() {
        return this.contentModified;
    }

    public boolean isPublishableBy(User user) {
        return (this.getValidation().isInDraft() || this.getValidation().isRefused()) && (user.isAccessAdmin() || this.getCreator().equals(user) && this.getSuggestionBox().getHighestUserRole(user).isGreaterThanOrEquals(SilverpeasRole.WRITER));
    }

    public String getComponentInstanceId() {
        return this.getSuggestionBox().getComponentInstanceId();
    }

    public ContributionIdentifier getIdentifier() {
        return ContributionIdentifier.from((String)this.getComponentInstanceId(), (String)this.getId(), (String)this.getContributionType());
    }

    public String getDescription() {
        return this.getContent();
    }

    public String getContributionType() {
        return TYPE;
    }

    public boolean isIndexable() {
        return false;
    }

    public String toString() {
        return "Suggestion{suggestionBox=" + this.suggestionBox.getId() + ", title=" + this.title + ", content=" + this.content + ", contentModified=" + this.contentModified + ", validation=" + String.valueOf(this.getValidation()) + ", creationDate=" + String.valueOf(this.getCreationDate()) + ", lastUpdateDate=" + String.valueOf(this.getLastUpdateDate()) + "}";
    }
}

