/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.mydb.model;

import java.sql.JDBCType;
import java.util.Objects;
import java.util.stream.Stream;
import org.silverpeas.components.mydb.model.JdbcRequester;
import org.silverpeas.components.mydb.model.SqlTypes;
import org.silverpeas.components.mydb.model.TableFieldValue;
import org.silverpeas.kernel.logging.SilverLogger;
import org.silverpeas.kernel.util.StringUtil;

public class DbColumn {
    private final JdbcRequester.ColumnDescriptor descriptor;

    DbColumn(JdbcRequester.ColumnDescriptor descriptor) {
        this.descriptor = descriptor;
    }

    public int getType() {
        return this.descriptor.getType();
    }

    public String getName() {
        return this.descriptor.getName();
    }

    public String getTypeName() {
        return JDBCType.valueOf(this.getType()).getName();
    }

    public int getSize() {
        int size = this.descriptor.getSize();
        if (this.getType() == -7 && this.descriptor.getSize() == 1) {
            size = "false".length();
        }
        return size;
    }

    public boolean isPrimaryKey() {
        return this.descriptor.isPrimaryKey();
    }

    public boolean isForeignKey() {
        return this.descriptor.getForeignKey() != null;
    }

    public String getForeignKeyName() {
        Objects.requireNonNull(this.descriptor.getForeignKey());
        return this.descriptor.getForeignKey().getName();
    }

    public String getReferencedColumn() {
        Objects.requireNonNull(this.descriptor.getForeignKey());
        return this.descriptor.getForeignKey().getTargetColumnName();
    }

    public String getReferencedTable() {
        Objects.requireNonNull(this.descriptor.getForeignKey());
        return this.descriptor.getForeignKey().getTargetTableName();
    }

    public boolean isNullable() {
        return this.descriptor.isNullable();
    }

    public boolean isAutoValued() {
        return this.descriptor.isAutoIncrementable();
    }

    public boolean isDefaultValueDefined() {
        return this.descriptor.getDefaultValue().isDefined();
    }

    public String getDefaultValue() {
        return this.descriptor.getDefaultValue().get();
    }

    public boolean isOfTypeText() {
        return SqlTypes.isText(this.getType());
    }

    public boolean isOfTypeBinary() {
        return SqlTypes.isBinary(this.getType());
    }

    public Object getJdbcValueOf(String value) {
        try {
            if (StringUtil.isDefined((String)value)) {
                Object[] values = Stream.of(value.replace("\\,", "\\@@##@@").split(",")).map(v -> v.replace("\\@@##@@", "\\,")).map(v -> TableFieldValue.fromString(v, this.getType()).toSQLObject()).toArray();
                return values.length == 1 ? values[0] : values;
            }
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).warn((Throwable)e);
        }
        return value;
    }
}

