/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.mydb.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.silverpeas.components.mydb.model.DbColumn;
import org.silverpeas.components.mydb.model.JdbcRequester;
import org.silverpeas.components.mydb.model.MyDBConnectionInfo;
import org.silverpeas.components.mydb.model.TableFieldValue;
import org.silverpeas.components.mydb.model.TableRow;
import org.silverpeas.components.mydb.model.predicates.AbstractColumnValuePredicate;
import org.silverpeas.components.mydb.model.predicates.ColumnValuePredicate;
import org.silverpeas.components.mydb.service.MyDBRuntimeException;
import org.silverpeas.core.admin.PaginationPage;
import org.silverpeas.core.util.SilverpeasList;
import org.silverpeas.kernel.util.StringUtil;

public class DbTable {
    private final String name;
    private final List<DbColumn> columns = new ArrayList<DbColumn>();
    private JdbcRequester requester = null;

    public static Optional<DbTable> defaultTable(MyDBConnectionInfo dsInfo) {
        DbTable table = null;
        if (dsInfo.isDefaultTableNameDefined()) {
            table = new DbTable(dsInfo.getDefaultTableName(), dsInfo);
        }
        return Optional.ofNullable(table);
    }

    public static Optional<DbTable> table(String tableName, MyDBConnectionInfo dsInfo) {
        try {
            return Optional.of(new DbTable(tableName, dsInfo));
        }
        catch (MyDBRuntimeException e) {
            return Optional.empty();
        }
    }

    public static List<String> list(MyDBConnectionInfo dsInfo) {
        Objects.requireNonNull(dsInfo);
        JdbcRequester requester = new JdbcRequester(dsInfo);
        return requester.getTableNames();
    }

    private DbTable(String name, MyDBConnectionInfo ds) {
        StringUtil.requireDefined((String)name);
        Objects.requireNonNull(ds);
        this.name = name;
        this.setJdbcRequester(new JdbcRequester(ds));
    }

    private void setJdbcRequester(JdbcRequester requester) {
        this.requester = requester;
        this.requester.perform((r, c) -> {
            this.columns.clear();
            r.loadColumns(c, this.name, d -> this.columns.add(new DbColumn(d)));
            return null;
        });
    }

    public String getName() {
        return this.name;
    }

    public List<DbColumn> getColumns() {
        return this.columns;
    }

    public Optional<DbColumn> getColumn(String name) {
        return this.columns.stream().filter(c -> c.getName().equals(name)).findFirst();
    }

    public SilverpeasList<TableRow> getRows(ColumnValuePredicate filter, String orderBy, PaginationPage pagination) {
        if (!(filter instanceof AbstractColumnValuePredicate)) {
            throw new IllegalArgumentException("DbTable doesn't support predicate other than AbstractColumnValuePredicate objects");
        }
        return this.requester.perform((r, c) -> {
            JdbcRequester.DataConverters<TableFieldValue, TableRow> converters = new JdbcRequester.DataConverters<TableFieldValue, TableRow>(TableFieldValue::new, TableRow::new);
            return r.request(c, this.name, (AbstractColumnValuePredicate)filter, orderBy, converters, pagination);
        });
    }

    public long delete(TableRow row) {
        return this.requester.perform((r, c) -> {
            Map<String, Object> criteria = this.getCriteriaFrom(row);
            return r.delete(c, this.getName(), criteria);
        });
    }

    public long update(TableRow actualRow, TableRow updatedRow) {
        return this.requester.perform((r, c) -> {
            Map<String, Object> criteria = this.getCriteriaFrom(actualRow);
            Map<String, Object> values = this.tableRowToMap(updatedRow);
            return r.update(c, this.getName(), values, criteria);
        });
    }

    public void add(TableRow row) {
        this.requester.perform((r, c) -> {
            Map<String, Object> values = this.tableRowToMap(row);
            r.insert(c, this.getName(), values);
            return null;
        });
    }

    private Map<String, Object> getCriteriaFrom(TableRow row) {
        List pkColumns = this.columns.stream().filter(DbColumn::isPrimaryKey).collect(Collectors.toList());
        Map<String, Object> criteria = !pkColumns.isEmpty() ? pkColumns.stream().collect(Collectors.toMap(DbColumn::getName, pk -> row.getFieldValue(pk.getName()).toSQLObject())) : this.tableRowToMap(row);
        return criteria;
    }

    private Map<String, Object> tableRowToMap(TableRow tableRow) {
        return tableRow.getFields().entrySet().stream().filter(Predicate.not(e -> ((String)e.getKey()).equalsIgnoreCase("SP_MAX_ROW_COUNT"))).collect(HashMap::new, (h, e) -> h.put((String)e.getKey(), ((TableFieldValue)e.getValue()).toSQLObject()), HashMap::putAll);
    }
}

