/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment.file;

import org.apache.jackrabbit.guava.common.base.Predicate;
import org.apache.jackrabbit.oak.segment.RecordId;
import org.apache.jackrabbit.oak.segment.compaction.SegmentGCOptions;
import org.apache.jackrabbit.oak.segment.file.Reclaimers;
import org.apache.jackrabbit.oak.segment.file.tar.GCGeneration;
import org.jetbrains.annotations.NotNull;

abstract class CompactionResult {
    @NotNull
    private final GCGeneration currentGeneration;
    private final int gcCount;

    private CompactionResult(@NotNull GCGeneration currentGeneration, int gcCount) {
        this.currentGeneration = currentGeneration;
        this.gcCount = gcCount;
    }

    static CompactionResult succeeded(final @NotNull SegmentGCOptions.GCType gcType, final @NotNull GCGeneration newGeneration, final @NotNull SegmentGCOptions gcOptions, final @NotNull RecordId compactedRootId, int gcCount) {
        return new CompactionResult(newGeneration, gcCount){

            @Override
            Predicate<GCGeneration> reclaimer() {
                return Reclaimers.newOldReclaimer(gcType, newGeneration, gcOptions.getRetainedGenerations());
            }

            @Override
            boolean isSuccess() {
                return true;
            }

            @Override
            RecordId getCompactedRootId() {
                return compactedRootId;
            }
        };
    }

    static CompactionResult aborted(@NotNull GCGeneration currentGeneration, final @NotNull GCGeneration failedGeneration, int gcCount) {
        return new CompactionResult(currentGeneration, gcCount){

            @Override
            Predicate<GCGeneration> reclaimer() {
                return Reclaimers.newExactReclaimer(failedGeneration);
            }

            @Override
            boolean isSuccess() {
                return false;
            }
        };
    }

    static CompactionResult skipped(final @NotNull SegmentGCOptions.GCType lastGCType, final @NotNull GCGeneration currentGeneration, final @NotNull SegmentGCOptions gcOptions, final @NotNull RecordId compactedRootId, int gcCount) {
        return new CompactionResult(currentGeneration, gcCount){

            @Override
            Predicate<GCGeneration> reclaimer() {
                return Reclaimers.newOldReclaimer(lastGCType, currentGeneration, gcOptions.getRetainedGenerations());
            }

            @Override
            boolean isSuccess() {
                return true;
            }

            @Override
            RecordId getCompactedRootId() {
                return compactedRootId;
            }
        };
    }

    static CompactionResult notApplicable(int count) {
        return new CompactionResult(GCGeneration.NULL, count){

            @Override
            Predicate<GCGeneration> reclaimer() {
                return generation -> false;
            }

            @Override
            boolean isSuccess() {
                return false;
            }

            @Override
            boolean isNotApplicable() {
                return true;
            }
        };
    }

    abstract Predicate<GCGeneration> reclaimer();

    abstract boolean isSuccess();

    RecordId getCompactedRootId() {
        return RecordId.NULL;
    }

    boolean isNotApplicable() {
        return false;
    }

    String gcInfo() {
        return String.format("gc-count=%d,gc-status=%s,store-generation=%s,reclaim-predicate=%s", this.gcCount, this.isSuccess() ? "success" : "failed", this.currentGeneration, this.reclaimer());
    }
}

