/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment;

import java.util.Formatter;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.jackrabbit.guava.common.collect.Sets;
import org.apache.jackrabbit.oak.segment.MapRecord;
import org.apache.jackrabbit.oak.segment.PropertyTemplate;
import org.apache.jackrabbit.oak.segment.RecordId;
import org.apache.jackrabbit.oak.segment.RecordIdSet;
import org.apache.jackrabbit.oak.segment.SegmentNotFoundException;
import org.apache.jackrabbit.oak.segment.SegmentParser;
import org.apache.jackrabbit.oak.segment.SegmentReader;
import org.jetbrains.annotations.NotNull;

public class RecordUsageAnalyser
extends SegmentParser {
    private final RecordIdSet seenIds = new RecordIdSet();
    private final Set<String> deadLinks = Sets.newHashSet();
    private long mapSize;
    private long listSize;
    private long valueSize;
    private long templateSize;
    private long nodeSize;
    private long mapCount;
    private long listCount;
    private long propertyCount;
    private long smallBlobCount;
    private long mediumBlobCount;
    private long longBlobCount;
    private long externalBlobCount;
    private long smallStringCount;
    private long mediumStringCount;
    private long longStringCount;
    private long templateCount;
    private long nodeCount;

    public RecordUsageAnalyser(@NotNull SegmentReader reader) {
        super(reader);
    }

    public long getMapSize() {
        return this.mapSize;
    }

    public long getListSize() {
        return this.listSize;
    }

    public long getValueSize() {
        return this.valueSize;
    }

    public long getTemplateSize() {
        return this.templateSize;
    }

    public long getNodeSize() {
        return this.nodeSize;
    }

    public long getMapCount() {
        return this.mapCount;
    }

    public long getListCount() {
        return this.listCount;
    }

    public long getPropertyCount() {
        return this.propertyCount;
    }

    public long getSmallBlobCount() {
        return this.smallBlobCount;
    }

    public long getMediumBlobCount() {
        return this.mediumBlobCount;
    }

    public long getLongBlobCount() {
        return this.longBlobCount;
    }

    public long getExternalBlobCount() {
        return this.externalBlobCount;
    }

    public long getSmallStringCount() {
        return this.smallStringCount;
    }

    public long getMediumStringCount() {
        return this.mediumStringCount;
    }

    public long getLongStringCount() {
        return this.longStringCount;
    }

    public long getTemplateCount() {
        return this.templateCount;
    }

    public long getNodeCount() {
        return this.nodeCount;
    }

    public void analyseNode(RecordId nodeId) {
        this.onNode(null, nodeId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        Formatter formatter = new Formatter(sb);
        formatter.format("%s in maps (%s leaf and branch records)%n", FileUtils.byteCountToDisplaySize((long)this.mapSize), this.mapCount);
        formatter.format("%s in lists (%s list and bucket records)%n", FileUtils.byteCountToDisplaySize((long)this.listSize), this.listCount);
        formatter.format("%s in values (value and block records of %s properties, %s/%s/%s/%s small/medium/long/external blobs, %s/%s/%s small/medium/long strings)%n", FileUtils.byteCountToDisplaySize((long)this.valueSize), this.propertyCount, this.smallBlobCount, this.mediumBlobCount, this.longBlobCount, this.externalBlobCount, this.smallStringCount, this.mediumStringCount, this.longStringCount);
        formatter.format("%s in templates (%s template records)%n", FileUtils.byteCountToDisplaySize((long)this.templateSize), this.templateCount);
        formatter.format("%s in nodes (%s node records)%n", FileUtils.byteCountToDisplaySize((long)this.nodeSize), this.nodeCount);
        formatter.format("links to non existing segments: %s", this.deadLinks);
        return sb.toString();
    }

    @Override
    protected void onNode(RecordId parentId, RecordId nodeId) {
        try {
            if (this.seenIds.addIfNotPresent(nodeId)) {
                SegmentParser.NodeInfo info = this.parseNode(nodeId);
                ++this.nodeCount;
                this.nodeSize += (long)info.size;
            }
        }
        catch (SegmentNotFoundException snfe) {
            this.deadLinks.add(snfe.getSegmentId());
        }
    }

    @Override
    protected void onTemplate(RecordId parentId, RecordId templateId) {
        try {
            if (this.seenIds.addIfNotPresent(templateId)) {
                SegmentParser.TemplateInfo info = this.parseTemplate(templateId);
                ++this.templateCount;
                this.templateSize += (long)info.size;
            }
        }
        catch (SegmentNotFoundException snfe) {
            this.deadLinks.add(snfe.getSegmentId());
        }
    }

    @Override
    protected void onMapDiff(RecordId parentId, RecordId mapId, MapRecord map) {
        try {
            if (this.seenIds.addIfNotPresent(mapId)) {
                SegmentParser.MapInfo info = this.parseMapDiff(mapId, map);
                ++this.mapCount;
                this.mapSize += (long)info.size;
            }
        }
        catch (SegmentNotFoundException snfe) {
            this.deadLinks.add(snfe.getSegmentId());
        }
    }

    @Override
    protected void onMapLeaf(RecordId parentId, RecordId mapId, MapRecord map) {
        try {
            if (this.seenIds.addIfNotPresent(mapId)) {
                SegmentParser.MapInfo info = this.parseMapLeaf(mapId, map);
                ++this.mapCount;
                this.mapSize += (long)info.size;
            }
        }
        catch (SegmentNotFoundException snfe) {
            this.deadLinks.add(snfe.getSegmentId());
        }
    }

    @Override
    protected void onMapBranch(RecordId parentId, RecordId mapId, MapRecord map) {
        try {
            if (this.seenIds.addIfNotPresent(mapId)) {
                SegmentParser.MapInfo info = this.parseMapBranch(mapId, map);
                ++this.mapCount;
                this.mapSize += (long)info.size;
            }
        }
        catch (SegmentNotFoundException snfe) {
            this.deadLinks.add(snfe.getSegmentId());
        }
    }

    @Override
    protected void onProperty(RecordId parentId, RecordId propertyId, PropertyTemplate template) {
        try {
            if (!this.seenIds.contains(propertyId)) {
                SegmentParser.PropertyInfo info = this.parseProperty(parentId, propertyId, template);
                ++this.propertyCount;
                this.valueSize += (long)info.size;
                this.seenIds.addIfNotPresent(propertyId);
            }
        }
        catch (SegmentNotFoundException snfe) {
            this.deadLinks.add(snfe.getSegmentId());
        }
    }

    @Override
    protected void onBlob(RecordId parentId, RecordId blobId) {
        try {
            if (this.seenIds.addIfNotPresent(blobId)) {
                SegmentParser.BlobInfo info = this.parseBlob(blobId);
                this.valueSize += (long)info.size;
                switch (info.blobType) {
                    case SMALL: {
                        ++this.smallBlobCount;
                        break;
                    }
                    case MEDIUM: {
                        ++this.mediumBlobCount;
                        break;
                    }
                    case LONG: {
                        ++this.longBlobCount;
                        break;
                    }
                    case EXTERNAL: {
                        ++this.externalBlobCount;
                    }
                }
            }
        }
        catch (SegmentNotFoundException snfe) {
            this.deadLinks.add(snfe.getSegmentId());
        }
    }

    @Override
    protected void onString(RecordId parentId, RecordId stringId) {
        try {
            if (this.seenIds.addIfNotPresent(stringId)) {
                SegmentParser.BlobInfo info = this.parseString(stringId);
                this.valueSize += (long)info.size;
                switch (info.blobType) {
                    case SMALL: {
                        ++this.smallStringCount;
                        break;
                    }
                    case MEDIUM: {
                        ++this.mediumStringCount;
                        break;
                    }
                    case LONG: {
                        ++this.longStringCount;
                        break;
                    }
                    case EXTERNAL: {
                        throw new IllegalStateException("String is too long: " + info.size);
                    }
                }
            }
        }
        catch (SegmentNotFoundException snfe) {
            this.deadLinks.add(snfe.getSegmentId());
        }
    }

    @Override
    protected void onList(RecordId parentId, RecordId listId, int count) {
        try {
            if (this.seenIds.addIfNotPresent(listId)) {
                SegmentParser.ListInfo info = this.parseList(parentId, listId, count);
                ++this.listCount;
                this.listSize += (long)info.size;
            }
        }
        catch (SegmentNotFoundException snfe) {
            this.deadLinks.add(snfe.getSegmentId());
        }
    }
}

