/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.security.authorization.accesscontrol;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import javax.jcr.RepositoryException;
import javax.jcr.security.AccessControlException;
import javax.jcr.security.Privilege;
import org.apache.jackrabbit.api.security.authorization.PrivilegeManager;
import org.apache.jackrabbit.guava.common.base.Preconditions;
import org.apache.jackrabbit.guava.common.base.Strings;
import org.apache.jackrabbit.guava.common.collect.Iterables;
import org.apache.jackrabbit.guava.common.collect.Sets;
import org.apache.jackrabbit.oak.api.CommitFailedException;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.plugins.nodetype.TypePredicate;
import org.apache.jackrabbit.oak.plugins.tree.TreeProvider;
import org.apache.jackrabbit.oak.plugins.tree.TreeUtil;
import org.apache.jackrabbit.oak.security.authorization.ProviderCtx;
import org.apache.jackrabbit.oak.security.authorization.accesscontrol.ValidationEntry;
import org.apache.jackrabbit.oak.spi.commit.DefaultValidator;
import org.apache.jackrabbit.oak.spi.commit.Validator;
import org.apache.jackrabbit.oak.spi.commit.VisibleValidator;
import org.apache.jackrabbit.oak.spi.security.Context;
import org.apache.jackrabbit.oak.spi.security.authorization.AuthorizationConfiguration;
import org.apache.jackrabbit.oak.spi.security.authorization.accesscontrol.AccessControlConstants;
import org.apache.jackrabbit.oak.spi.security.authorization.restriction.RestrictionProvider;
import org.apache.jackrabbit.oak.spi.security.privilege.PrivilegeBits;
import org.apache.jackrabbit.oak.spi.security.privilege.PrivilegeBitsProvider;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.jackrabbit.util.Text;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class AccessControlValidator
extends DefaultValidator
implements AccessControlConstants {
    private final TreeProvider treeProvider;
    private final Tree parentAfter;
    private final PrivilegeBitsProvider privilegeBitsProvider;
    private final PrivilegeManager privilegeManager;
    private final RestrictionProvider restrictionProvider;
    private final TypePredicate isRepoAccessControllable;
    private final TypePredicate isAccessControllable;
    private final Context ctx;

    AccessControlValidator(@NotNull NodeState parentAfter, @NotNull PrivilegeManager privilegeManager, @NotNull PrivilegeBitsProvider privilegeBitsProvider, @NotNull RestrictionProvider restrictionProvider, @NotNull ProviderCtx providerCtx) {
        this.treeProvider = providerCtx.getTreeProvider();
        this.parentAfter = this.treeProvider.createReadOnlyTree(parentAfter);
        this.privilegeBitsProvider = privilegeBitsProvider;
        this.privilegeManager = privilegeManager;
        this.restrictionProvider = restrictionProvider;
        this.isRepoAccessControllable = new TypePredicate(parentAfter, "rep:RepoAccessControllable");
        this.isAccessControllable = new TypePredicate(parentAfter, "rep:AccessControllable");
        this.ctx = ((AuthorizationConfiguration)providerCtx.getSecurityProvider().getConfiguration(AuthorizationConfiguration.class)).getContext();
    }

    private AccessControlValidator(AccessControlValidator parent, Tree parentAfter) {
        this.treeProvider = parent.treeProvider;
        this.parentAfter = parentAfter;
        this.privilegeBitsProvider = parent.privilegeBitsProvider;
        this.privilegeManager = parent.privilegeManager;
        this.restrictionProvider = parent.restrictionProvider;
        this.isRepoAccessControllable = parent.isRepoAccessControllable;
        this.isAccessControllable = parent.isAccessControllable;
        this.ctx = parent.ctx;
    }

    public void propertyAdded(PropertyState after) throws CommitFailedException {
        if (AccessControlValidator.isAccessControlEntry(this.parentAfter)) {
            this.checkValidAccessControlEntry(this.parentAfter);
        }
        if ("jcr:mixinTypes".equals(after.getName())) {
            AccessControlValidator.checkMixinTypes(this.parentAfter);
        }
    }

    public void propertyChanged(PropertyState before, PropertyState after) throws CommitFailedException {
        if (AccessControlValidator.isAccessControlEntry(this.parentAfter)) {
            this.checkValidAccessControlEntry(this.parentAfter);
        }
        if ("jcr:mixinTypes".equals(after.getName())) {
            AccessControlValidator.checkMixinTypes(this.parentAfter);
        }
    }

    public void propertyDeleted(PropertyState before) {
    }

    public Validator childNodeAdded(String name, NodeState after) throws CommitFailedException {
        Tree treeAfter = (Tree)Preconditions.checkNotNull((Object)this.parentAfter.getChild(name));
        this.checkValidTree(this.parentAfter, treeAfter, after);
        return AccessControlValidator.newValidator(this, treeAfter);
    }

    public Validator childNodeChanged(String name, NodeState before, NodeState after) throws CommitFailedException {
        Tree treeAfter = (Tree)Preconditions.checkNotNull((Object)this.parentAfter.getChild(name));
        this.checkValidTree(this.parentAfter, treeAfter, after);
        return AccessControlValidator.newValidator(this, treeAfter);
    }

    public Validator childNodeDeleted(String name, NodeState before) {
        return null;
    }

    private static Validator newValidator(AccessControlValidator parent, Tree parentAfter) {
        return new VisibleValidator((Validator)new AccessControlValidator(parent, parentAfter), true, true);
    }

    private void checkValidTree(Tree parentAfter, Tree treeAfter, NodeState nodeAfter) throws CommitFailedException {
        if (AccessControlValidator.isPolicy(treeAfter)) {
            this.checkValidPolicy(parentAfter, treeAfter, nodeAfter);
        } else if (AccessControlValidator.isAccessControlEntry(treeAfter)) {
            this.checkValidAccessControlEntry(treeAfter);
        } else if ("rep:Restrictions".equals(TreeUtil.getPrimaryTypeName((Tree)treeAfter))) {
            if (AccessControlValidator.isAccessControlEntry(parentAfter)) {
                this.checkValidRestrictions(parentAfter);
            } else if (!this.ctx.definesTree(parentAfter)) {
                throw AccessControlValidator.accessViolation(2, "Access control entry node expected at " + parentAfter.getPath());
            }
        }
    }

    private static boolean isPolicy(Tree tree) {
        return "rep:ACL".equals(TreeUtil.getPrimaryTypeName((Tree)tree));
    }

    private static boolean isAccessControlEntry(Tree tree) {
        String ntName = TreeUtil.getPrimaryTypeName((Tree)tree);
        return "rep:DenyACE".equals(ntName) || "rep:GrantACE".equals(ntName);
    }

    private void checkValidPolicy(Tree parent, Tree policyTree, NodeState policyNode) throws CommitFailedException {
        Set<String> validPolicyNames;
        if ("rep:repoPolicy".equals(policyTree.getName())) {
            AccessControlValidator.checkValidAccessControlledNode(parent, this.isRepoAccessControllable, this.treeProvider);
            AccessControlValidator.checkValidRepoAccessControlled(parent);
        } else {
            AccessControlValidator.checkValidAccessControlledNode(parent, this.isAccessControllable, this.treeProvider);
        }
        Set<String> set = validPolicyNames = parent.isRoot() ? POLICY_NODE_NAMES : Collections.singleton("rep:policy");
        if (!validPolicyNames.contains(policyTree.getName())) {
            throw AccessControlValidator.accessViolation(3, "Invalid policy name " + policyTree.getName() + " at " + parent.getPath());
        }
        if (!policyNode.hasProperty(":childOrder")) {
            throw AccessControlValidator.accessViolation(4, "Invalid policy node at " + policyTree.getPath() + ": Order of children is not stable.");
        }
        HashSet aceSet = Sets.newHashSet();
        for (Tree child : policyTree.getChildren()) {
            ValidationEntry entry;
            if (!AccessControlValidator.isAccessControlEntry(child) || aceSet.add(entry = this.createAceEntry(parent.getPath(), child))) continue;
            String restrs = String.join((CharSequence)", ", entry.restrictions.stream().map(restriction -> restriction.getProperty().toString()).collect(Collectors.toSet()));
            String msg = String.format("Duplicate ACE '%s' found in policy. (principal = %s, isallow = %b, privileges = %s, restrictions = [%s])", child.getPath(), entry.principalName, entry.isAllow, this.privilegeBitsProvider.getPrivilegeNames(entry.privilegeBits), restrs);
            throw AccessControlValidator.accessViolation(13, msg);
        }
    }

    private static void checkValidAccessControlledNode(@NotNull Tree accessControlledTree, @NotNull TypePredicate requiredMixin, @NotNull TreeProvider treeProvider) throws CommitFailedException {
        if (AC_NODETYPE_NAMES.contains(TreeUtil.getPrimaryTypeName((Tree)accessControlledTree))) {
            throw AccessControlValidator.accessViolation(5, "Access control policy within access control content (" + accessControlledTree.getPath() + ")");
        }
        if (!requiredMixin.test(treeProvider.asNodeState(accessControlledTree))) {
            String msg = "Isolated policy node (" + accessControlledTree.getPath() + "). Parent is not of type " + requiredMixin;
            throw AccessControlValidator.accessViolation(6, msg);
        }
    }

    private void checkValidAccessControlEntry(@NotNull Tree aceNode) throws CommitFailedException {
        Tree parent = aceNode.getParent();
        if (!"rep:ACL".equals(TreeUtil.getPrimaryTypeName((Tree)parent))) {
            throw AccessControlValidator.accessViolation(7, "Isolated access control entry at " + aceNode.getPath());
        }
        AccessControlValidator.checkValidPrincipal(aceNode);
        this.checkValidPrivileges(aceNode);
        this.checkValidRestrictions(aceNode);
    }

    @NotNull
    private static String checkValidPrincipal(@NotNull Tree aceNode) throws CommitFailedException {
        String principalName = TreeUtil.getString((Tree)aceNode, (String)"rep:principalName");
        if (Strings.isNullOrEmpty((String)principalName)) {
            throw AccessControlValidator.accessViolation(8, "Missing principal name at " + aceNode.getPath());
        }
        return principalName;
    }

    private void checkValidPrivileges(@NotNull Tree aceNode) throws CommitFailedException {
        Iterable<String> privilegeNames = AccessControlValidator.getPrivilegeNames(aceNode);
        for (String privilegeName : privilegeNames) {
            try {
                Privilege privilege = this.privilegeManager.getPrivilege(privilegeName);
                if (!privilege.isAbstract()) continue;
                throw AccessControlValidator.accessViolation(11, "Abstract privilege " + privilegeName + " at " + aceNode.getPath());
            }
            catch (AccessControlException e) {
                throw AccessControlValidator.accessViolation(10, "Invalid privilege " + privilegeName + " at " + aceNode.getPath());
            }
            catch (RepositoryException e) {
                throw new IllegalStateException("Failed to read privileges", e);
            }
        }
    }

    @NotNull
    private static Iterable<String> getPrivilegeNames(@NotNull Tree aceNode) throws CommitFailedException {
        Iterable privilegeNames = TreeUtil.getNames((Tree)aceNode, (String)"rep:privileges");
        if (Iterables.isEmpty((Iterable)privilegeNames)) {
            throw AccessControlValidator.accessViolation(9, "Missing privileges at " + aceNode.getPath());
        }
        return privilegeNames;
    }

    private void checkValidRestrictions(@NotNull Tree aceTree) throws CommitFailedException {
        Tree aclTree = (Tree)Preconditions.checkNotNull((Object)aceTree.getParent());
        String aclPath = aclTree.getPath();
        String path = "rep:repoPolicy".equals(Text.getName((String)aclPath)) ? null : Text.getRelativeParent((String)aclPath, (int)1);
        try {
            this.restrictionProvider.validateRestrictions(path, aceTree);
        }
        catch (AccessControlException e) {
            throw new CommitFailedException("AccessControl", 1, "Access control violation", (Throwable)e);
        }
        catch (RepositoryException e) {
            throw new CommitFailedException("Oak", 13, "Internal error", (Throwable)e);
        }
    }

    private static void checkMixinTypes(Tree parentTree) throws CommitFailedException {
        Iterable mixinNames = TreeUtil.getNames((Tree)parentTree, (String)"jcr:mixinTypes");
        if (Iterables.contains((Iterable)mixinNames, (Object)"rep:RepoAccessControllable")) {
            AccessControlValidator.checkValidRepoAccessControlled(parentTree);
        }
    }

    private static void checkValidRepoAccessControlled(@NotNull Tree accessControlledTree) throws CommitFailedException {
        if (!accessControlledTree.isRoot()) {
            throw AccessControlValidator.accessViolation(12, "Only root can store repository level policies (" + accessControlledTree.getPath() + ")");
        }
    }

    @NotNull
    private static CommitFailedException accessViolation(int code, String message) {
        return new CommitFailedException("AccessControl", code, message);
    }

    @NotNull
    private ValidationEntry createAceEntry(@Nullable String path, @NotNull Tree aceTree) throws CommitFailedException {
        String principalName = AccessControlValidator.checkValidPrincipal(aceTree);
        PrivilegeBits privilegeBits = this.privilegeBitsProvider.getBits(AccessControlValidator.getPrivilegeNames(aceTree));
        boolean isAllow = "rep:GrantACE".equals(TreeUtil.getPrimaryTypeName((Tree)aceTree));
        Set restrictions = this.restrictionProvider.readRestrictions(path, aceTree);
        return new ValidationEntry(principalName, privilegeBits, isAllow, restrictions);
    }
}

