/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.cursor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.jackrabbit.oak.api.Result;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.plugins.index.cursor.AbstractCursor;
import org.apache.jackrabbit.oak.spi.query.Cursor;
import org.apache.jackrabbit.oak.spi.query.IndexRow;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.jackrabbit.oak.spi.state.PrefetchNodeStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrefetchCursor
extends AbstractCursor {
    private static final Logger LOG = LoggerFactory.getLogger(PrefetchCursor.class);
    private static final Pattern FUNCTION = Pattern.compile("\\$\\{((\\}|[^}])*)\\}");
    private final Cursor cursor;
    private final PrefetchNodeStore store;
    private final int prefetchCount;
    private final NodeState rootState;
    private Iterator<IndexRow> prefetched;
    private final List<String> prefetchRelative;

    PrefetchCursor(Cursor cursor, PrefetchNodeStore store, int prefetchCount, NodeState rootState, List<String> prefetchRelative) {
        this.cursor = cursor;
        this.store = store;
        this.prefetchCount = prefetchCount;
        this.rootState = rootState;
        this.prefetched = Collections.emptyIterator();
        this.prefetchRelative = prefetchRelative;
    }

    @Override
    public long getSize(Result.SizePrecision precision, long max) {
        return this.cursor.getSize(precision, max);
    }

    public IndexRow next() {
        if (!this.prefetched.hasNext()) {
            ArrayList<IndexRow> rows = new ArrayList<IndexRow>();
            TreeSet<String> paths = new TreeSet<String>();
            for (int i = 0; i < this.prefetchCount && this.cursor.hasNext(); ++i) {
                IndexRow row = this.cursor.next();
                rows.add(row);
                if (row.isVirtualRow()) continue;
                String p = row.getPath();
                if (!PathUtils.isAbsolute((String)p)) {
                    LOG.warn("Unexpected relative path {}", (Object)p);
                    continue;
                }
                this.prefetchRelative(paths, p);
                do {
                    paths.add(p);
                } while (!PathUtils.denotesRoot((String)(p = PathUtils.getParentPath((String)p))));
            }
            this.store.prefetch(paths, this.rootState);
            this.prefetched = rows.iterator();
        }
        return this.prefetched.next();
    }

    public boolean hasNext() {
        return this.prefetched.hasNext() || this.cursor.hasNext();
    }

    private void prefetchRelative(Set<String> target, String p) {
        try {
            for (String r : this.prefetchRelative) {
                String result = PrefetchCursor.resolve(r, p);
                if (result == null) continue;
                target.add(result);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public static String resolve(String relativePath, String path) throws IllegalArgumentException {
        String resolved = PrefetchCursor.applyAndResolvePatterns(relativePath, path);
        if (resolved == null) {
            return null;
        }
        if (PathUtils.isAbsolute((String)resolved)) {
            return resolved;
        }
        return PathUtils.concat((String)path, (String)resolved);
    }

    public static String applyAndResolvePatterns(String relativePath, String path) throws IllegalArgumentException {
        Matcher m = FUNCTION.matcher(relativePath);
        StringBuffer buff = new StringBuffer();
        try {
            while (m.find()) {
                String f = m.group(1);
                if ((f = f.replaceAll("\\\\}", "}")).startsWith("regex(\"") && f.endsWith("\")")) {
                    String regexPattern = f.substring("regex(\"".length(), f.length() - 2);
                    String x = PrefetchCursor.findMatch(path, regexPattern = regexPattern.replaceAll("\\\"", "\""));
                    if (x == null) {
                        return null;
                    }
                    m.appendReplacement(buff, x);
                    continue;
                }
                break;
            }
        }
        catch (IllegalStateException | IndexOutOfBoundsException e) {
            LOG.warn("Can not replace {} match in {}", new Object[]{relativePath, path, e});
            throw new IllegalArgumentException("Can not replace");
        }
        m.appendTail(buff);
        return buff.toString();
    }

    public static String findMatch(String path, String regexPattern) throws IllegalArgumentException {
        try {
            Pattern p = Pattern.compile(regexPattern);
            Matcher m = p.matcher(path);
            if (!m.find()) {
                return null;
            }
            return m.group(1);
        }
        catch (IllegalStateException | IndexOutOfBoundsException | PatternSyntaxException e) {
            LOG.warn("Can not find match in {} pattern {}", new Object[]{path, regexPattern, e});
            throw new IllegalArgumentException("Can not find match", e);
        }
    }
}

