/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document.mongo;

import java.util.Map;
import org.apache.jackrabbit.guava.common.collect.ImmutableMap;
import org.apache.jackrabbit.oak.commons.json.JsonObject;
import org.bson.BsonDocument;
import org.bson.conversions.Bson;

public class MongoDBConfig {
    static final String COLLECTION_COMPRESSION_TYPE = "collectionCompressionType";
    static final String STORAGE_ENGINE = "wiredTiger";
    static final String STORAGE_CONFIG = "configString";

    public static Bson getCollectionStorageOptions(Map<String, String> mongoStorageOptions) {
        String compressionType = mongoStorageOptions.getOrDefault(COLLECTION_COMPRESSION_TYPE, CollectionCompressor.SNAPPY.getName());
        if (CollectionCompressor.isSupportedCompressor(compressionType)) {
            JsonObject root = new JsonObject();
            JsonObject configString = new JsonObject();
            configString.getProperties().put(STORAGE_CONFIG, MongoDBConfig.getCompressionConfig(mongoStorageOptions));
            root.getChildren().put(STORAGE_ENGINE, configString);
            BsonDocument storageOptions = BsonDocument.parse((String)root.toString());
            return storageOptions;
        }
        throw new IllegalArgumentException("Invalid collection compressionType provided: " + compressionType);
    }

    private static String getCompressionConfig(Map<String, String> storageOptions) {
        return "\"block_compressor=" + storageOptions.getOrDefault(COLLECTION_COMPRESSION_TYPE, "snappy") + "\"";
    }

    static enum CollectionCompressor {
        SNAPPY("snappy"),
        ZLIB("zlib"),
        ZSTD("zstd");

        private final String compressionType;
        private static final Map<String, CollectionCompressor> COLLECTION_COMPRESSOR_MAP;

        private CollectionCompressor(String compressionType) {
            this.compressionType = compressionType;
        }

        public String getName() {
            return this.compressionType;
        }

        public static boolean isSupportedCompressor(String compressionType) {
            return COLLECTION_COMPRESSOR_MAP.containsKey(compressionType.toLowerCase());
        }

        static {
            ImmutableMap.Builder builder = new ImmutableMap.Builder();
            for (CollectionCompressor value : CollectionCompressor.values()) {
                builder.put((Object)value.getName().toLowerCase(), (Object)value);
            }
            COLLECTION_COMPRESSOR_MAP = builder.build();
        }
    }
}

