/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.security.authorization.permission;

import org.apache.jackrabbit.guava.common.base.Predicate;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.security.authorization.permission.PermissionEntry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

interface EntryPredicate
extends Predicate<PermissionEntry> {
    @Nullable
    public String getPath();

    default public boolean apply(@Nullable PermissionEntry entry) {
        return entry != null && this.apply(entry, true);
    }

    public boolean apply(@NotNull PermissionEntry var1, boolean var2);

    public static EntryPredicate create() {
        return new EntryPredicate(){

            @Override
            @Nullable
            public String getPath() {
                return null;
            }

            @Override
            public boolean apply(@NotNull PermissionEntry entry, boolean respectParent) {
                return entry.matches();
            }
        };
    }

    public static EntryPredicate create(final @NotNull Tree tree, final @Nullable PropertyState property, boolean respectParent) {
        final Tree parent = !respectParent || tree.isRoot() ? null : tree.getParent();
        final boolean rp = respectParent && parent != null;
        return new EntryPredicate(){

            @Override
            @NotNull
            public String getPath() {
                return tree.getPath();
            }

            @Override
            public boolean apply(@NotNull PermissionEntry entry, boolean respectParent) {
                return entry.matches(tree, property) || (respectParent &= rp) && entry.matches(parent, null);
            }
        };
    }

    public static EntryPredicate create(final @NotNull String path, final boolean isProperty, boolean respectParent) {
        final String parentPath = !respectParent || "/".equals(path) ? null : PathUtils.getParentPath((String)path);
        final boolean rp = respectParent && parentPath != null;
        return new EntryPredicate(){

            @Override
            @NotNull
            public String getPath() {
                return path;
            }

            @Override
            public boolean apply(@NotNull PermissionEntry entry, boolean respectParent) {
                return entry.matches(path, isProperty) || (respectParent &= rp) && entry.matches(parentPath, false);
            }
        };
    }

    public static EntryPredicate create(final @NotNull String path, boolean respectParent) {
        final String parentPath = !respectParent || "/".equals(path) ? null : PathUtils.getParentPath((String)path);
        final boolean rp = respectParent && parentPath != null;
        return new EntryPredicate(){

            @Override
            @NotNull
            public String getPath() {
                return path;
            }

            @Override
            public boolean apply(@NotNull PermissionEntry entry, boolean respectParent) {
                return entry.matches(path) || (respectParent &= rp) && entry.matches(parentPath, false);
            }
        };
    }
}

