/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.query.stats;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import org.gradle.internal.classpath.Instrumented;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryRecorder {
    private static final Logger LOG = LoggerFactory.getLogger(QueryRecorder.class);
    private static final HashMap<String, Integer> RECORD_QUERIES_MAP = new HashMap();
    private static final int QUERIES_MAX = Instrumented.getInteger((String)"oak.query.record", (int)5000, (String)"org.apache.jackrabbit.oak.query.stats.QueryRecorder");

    public static void main(String ... args) throws IOException {
        String line;
        LineNumberReader reader = new LineNumberReader(new BufferedReader(new FileReader(args[0])));
        TreeSet<String> sorted = new TreeSet<String>();
        int lineCount = 0;
        while ((line = reader.readLine()) != null) {
            sorted.add(QueryRecorder.simplify(line));
            ++lineCount;
        }
        reader.close();
        for (String s : sorted) {
            System.out.println(s);
        }
        System.out.println("sorted: " + sorted.size() + " original: " + lineCount);
    }

    public static void record(String query, boolean internal) {
        if (internal) {
            return;
        }
        if (!LOG.isDebugEnabled()) {
            return;
        }
        query = query.replace('\n', ' ');
        query = query.replace('\t', ' ');
        if (LOG.isTraceEnabled()) {
            LOG.trace("query:\t{}", (Object)query);
        }
        query = QueryRecorder.simplifySafely(query);
        QueryRecorder.record(query);
    }

    public static String simplifySafely(String query) {
        try {
            return QueryRecorder.simplify(query);
        }
        catch (Exception e) {
            LOG.trace("failed to simplify {}", (Object)query, (Object)e);
            return query;
        }
    }

    public static String simplify(String query) {
        int pathIndex;
        query = ((String)query).replaceAll("[0-9]+", "1");
        query = ((String)query).replaceAll("'[^']*'", "'x'");
        query = ((String)query).replaceAll("('x')+", "'x'");
        query = ((String)query).replaceAll("\"[^\"]*\"", "\"x\"");
        query = ((String)query).replaceAll("(\"x\")+", "\"x\"");
        query = ((String)query).replaceAll("'x', ", "'x',");
        query = ((String)query).replaceAll("('x','x')+", "'x'");
        query = ((String)query).replaceAll("(?i)(ISDESCENDANTNODE|ISCHILDNODE|ISSAMENODE)\\s*\\(.*,\\s*\\[/[^]]*\\]\\)", "$1('x')");
        query = ((String)query).replaceAll("(?i)(ISDESCENDANTNODE|ISCHILDNODE|ISSAMENODE)\\s*\\(\\[/[^]]*\\]\\)", "$1('x')");
        int startIndex = 0;
        while ((pathIndex = ((String)query).indexOf("/jcr:root/", startIndex)) >= 0) {
            int end;
            startIndex = pathIndex + 1;
            int start = pathIndex + "/jcr:root/".length();
            Object path = ((String)query).substring(start, end = QueryRecorder.getFirstOccurance((String)query, start, " ", "/element(", "/text(", "/*", "/(", "/jcr:deref("));
            int first = ((String)path).indexOf(47);
            if (first > 0 && (first = ((String)path).indexOf(47, first + 1)) > 0) {
                path = ((String)path).substring(0, first + 1) + "...";
            }
            String newQuery = ((String)query).substring(0, pathIndex) + "/jcr:root/" + (String)path + ((String)query).substring(end, ((String)query).length());
            query = newQuery;
        }
        return query;
    }

    static int getFirstOccurance(String text, int start, String ... strings) {
        int first = text.length();
        for (String s : strings) {
            int index = text.indexOf(s, start + 1);
            if (index <= 0 || index >= first) continue;
            first = index;
        }
        return first;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void record(String query) {
        Integer count;
        Object object;
        HashMap<String, Integer> map = RECORD_QUERIES_MAP;
        if (map.size() > QUERIES_MAX) {
            HashMap<String, Integer> old;
            object = map;
            synchronized (object) {
                old = new HashMap<String, Integer>(map);
                map.clear();
            }
            for (Map.Entry entry : old.entrySet()) {
                QueryRecorder.log((String)entry.getKey(), (Integer)entry.getValue());
            }
        }
        object = map;
        synchronized (object) {
            count = map.get(query);
            count = count == null ? 1 : count + 1;
            map.put(query, count);
        }
        if (count == 1 || count % 100 == 0) {
            QueryRecorder.log(query, count);
        }
    }

    private static void log(String query, int count) {
        LOG.debug("count:\t{}\tquery:\t{}", (Object)count, (Object)query);
    }
}

