/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index;

import java.lang.management.ManagementFactory;
import java.time.Duration;
import java.time.Instant;
import java.util.Calendar;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.jackrabbit.util.ISO8601;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RateLimitUtils {
    private static final Logger LOG = LoggerFactory.getLogger(RateLimitUtils.class);
    private static Instant lastJmxBeanCall = Instant.now();
    private static Instant cachedOldestAsyncUpdate = Instant.now();
    private static Instant lastRateLimitCall = Instant.now();

    private RateLimitUtils() {
    }

    public static long rateLimitWrites() {
        Instant now = Instant.now();
        Duration delay = Duration.between(RateLimitUtils.getOldestAsyncIndexUpdate(now), now);
        return RateLimitUtils.rateLimit(now, delay, true);
    }

    static long rateLimit(Instant now, Duration delay, boolean callThreadSleep) {
        long sleep;
        if (delay.getSeconds() < 30L) {
            sleep = 0L;
        } else {
            if (delay.toMinutes() > 60L) {
                LOG.warn("Indexing is delayed for {} minutes", (Object)delay.toMinutes());
            }
            sleep = Duration.between(lastRateLimitCall, now).toMillis();
            sleep = Math.min(sleep, Duration.ofMinutes(1L).toMillis());
            sleep = Math.max(0L, sleep);
            if (callThreadSleep) {
                try {
                    Thread.sleep(sleep);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            now = now.plus(Duration.ofMillis(sleep));
        }
        lastRateLimitCall = now;
        return sleep;
    }

    private static Instant getOldestAsyncIndexUpdate(Instant now) {
        if (Duration.between(lastJmxBeanCall, now).getSeconds() < 1L) {
            return cachedOldestAsyncUpdate;
        }
        lastJmxBeanCall = now;
        Instant oldestAsyncUpdate = now;
        MBeanServer server = ManagementFactory.getPlatformMBeanServer();
        try {
            Set<ObjectName> beanNames = server.queryNames(new ObjectName("org.apache.jackrabbit.oak:type=IndexStats,*"), null);
            for (ObjectName objectName : beanNames) {
                Calendar cal;
                Instant doneInstant;
                Object time = server.getAttribute(objectName, "Done");
                if (time == null || time.toString().isEmpty()) {
                    time = server.getAttribute(objectName, "LastIndexedTime");
                }
                if (time == null || time.toString().isEmpty() || !(doneInstant = Instant.ofEpochMilli((cal = ISO8601.parse((String)time.toString())).getTimeInMillis())).isBefore(oldestAsyncUpdate)) continue;
                oldestAsyncUpdate = doneInstant;
            }
        }
        catch (Exception e) {
            LOG.warn("Could not retrieve the async lane state", (Throwable)e);
        }
        cachedOldestAsyncUpdate = oldestAsyncUpdate;
        return oldestAsyncUpdate;
    }
}

