/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document.mongo;

import org.apache.jackrabbit.oak.plugins.document.mongo.MongoBlob;
import org.bson.BsonReader;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.bson.BsonWriter;
import org.bson.Document;
import org.bson.codecs.Codec;
import org.bson.codecs.CollectibleCodec;
import org.bson.codecs.DecoderContext;
import org.bson.codecs.DocumentCodec;
import org.bson.codecs.EncoderContext;

class MongoBlobCodec
implements CollectibleCodec<MongoBlob> {
    private final Codec<Document> documentCodec = new DocumentCodec();

    MongoBlobCodec() {
    }

    public MongoBlob generateIdIfAbsentFromDocument(MongoBlob document) {
        if (!this.documentHasId(document)) {
            throw new IllegalStateException("MongoBlob must not have generated id");
        }
        return document;
    }

    public boolean documentHasId(MongoBlob document) {
        return document.getId() != null;
    }

    public BsonValue getDocumentId(MongoBlob document) {
        if (!this.documentHasId(document)) {
            throw new IllegalStateException("MongoBlob does not have an id");
        }
        return new BsonString(document.getId());
    }

    public MongoBlob decode(BsonReader reader, DecoderContext decoderContext) {
        Document doc = (Document)this.documentCodec.decode(reader, decoderContext);
        return MongoBlob.fromDocument(doc);
    }

    public void encode(BsonWriter writer, MongoBlob value, EncoderContext encoderContext) {
        Document doc = value.asDocument();
        this.documentCodec.encode(writer, (Object)doc, encoderContext);
    }

    public Class<MongoBlob> getEncoderClass() {
        return MongoBlob.class;
    }
}

