/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document;

import org.apache.jackrabbit.oak.cache.CacheStats;
import org.apache.jackrabbit.oak.commons.json.JsopTokenizer;
import org.apache.jackrabbit.oak.plugins.document.Path;
import org.apache.jackrabbit.oak.plugins.document.RevisionVector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class DiffCache {
    DiffCache() {
    }

    @Nullable
    abstract String getChanges(@NotNull RevisionVector var1, @NotNull RevisionVector var2, @NotNull Path var3, @Nullable Loader var4);

    @NotNull
    abstract Entry newEntry(@NotNull RevisionVector var1, @NotNull RevisionVector var2, boolean var3);

    @NotNull
    abstract Iterable<CacheStats> getStats();

    abstract void invalidateAll();

    static boolean parseJsopDiff(@NotNull String jsop, @NotNull Diff diff) {
        int r;
        if (jsop.trim().isEmpty()) {
            return true;
        }
        JsopTokenizer t = new JsopTokenizer(jsop);
        boolean continueComparison = true;
        block5: while (continueComparison && (r = t.read()) != 0) {
            switch (r) {
                case 43: {
                    String name = t.readString();
                    t.read(58);
                    t.read(123);
                    while (t.read() != 125) {
                    }
                    continueComparison = diff.childNodeAdded(name);
                    continue block5;
                }
                case 45: {
                    String name = t.readString();
                    continueComparison = diff.childNodeDeleted(name);
                    continue block5;
                }
                case 94: {
                    String name = t.readString();
                    t.read(58);
                    t.read(123);
                    t.read(125);
                    continueComparison = diff.childNodeChanged(name);
                    continue block5;
                }
            }
            throw new IllegalArgumentException("jsonDiff: illegal token '" + t.getToken() + "' at pos: " + t.getLastPos() + " " + jsop);
        }
        return continueComparison;
    }

    static interface Diff {
        public boolean childNodeAdded(String var1);

        public boolean childNodeChanged(String var1);

        public boolean childNodeDeleted(String var1);
    }

    static interface Loader {
        public String call();
    }

    static interface Entry {
        public void append(@NotNull Path var1, @NotNull String var2);

        public boolean done();
    }
}

