/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment.standby.client;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import org.apache.jackrabbit.oak.api.Blob;
import org.apache.jackrabbit.oak.commons.IOUtils;
import org.apache.jackrabbit.oak.segment.SegmentBlob;
import org.apache.jackrabbit.oak.segment.standby.client.BlobProcessor;
import org.apache.jackrabbit.oak.segment.standby.client.BlobTypeUnknownException;
import org.apache.jackrabbit.oak.segment.standby.client.BlobWriteException;
import org.apache.jackrabbit.oak.spi.blob.BlobStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RemoteBlobProcessor
implements BlobProcessor {
    private static final Logger logger = LoggerFactory.getLogger(RemoteBlobProcessor.class);
    private final BlobStore blobStore;
    private final BlobDownloader blobDownloader;

    RemoteBlobProcessor(BlobStore blobStore, BlobDownloader blobDownloader) {
        this.blobStore = blobStore;
        this.blobDownloader = blobDownloader;
    }

    @Override
    public void processBinary(Blob b) throws InterruptedException {
        if (!(b instanceof SegmentBlob)) {
            throw new BlobTypeUnknownException();
        }
        this.fetchBinary((SegmentBlob)b);
    }

    private void fetchBinary(SegmentBlob blob) throws InterruptedException {
        if (this.shouldFetchBinary(blob)) {
            this.fetchAndStoreBlob(blob.getBlobId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean shouldFetchBinary(SegmentBlob blob) {
        InputStream data;
        String reference;
        String blobId = blob.getBlobId();
        if (blobId == null) {
            return false;
        }
        try {
            reference = blob.getReference();
        }
        catch (Exception e) {
            logger.warn("Unable to read a reference for blob {}", (Object)blobId, (Object)e);
            reference = null;
        }
        if (reference != null) {
            return false;
        }
        try {
            data = this.blobStore.getInputStream(blobId);
        }
        catch (Exception e) {
            logger.warn("Unable to open a stream for blob {}, the blob will be downloaded", (Object)blobId, (Object)e);
            return true;
        }
        if (data == null) {
            return true;
        }
        try {
            data.read();
        }
        catch (Exception e) {
            logger.warn("Unable to read the content for blob {}, the blob will be downloaded", (Object)blobId, (Object)e);
            boolean bl = true;
            return bl;
        }
        finally {
            IOUtils.closeQuietly((Closeable)data);
        }
        return false;
    }

    private void fetchAndStoreBlob(String blobId) throws InterruptedException {
        try (InputStream in = this.downloadBlob(blobId);){
            this.writeBlob(blobId, in);
        }
        catch (IOException e) {
            throw new BlobWriteException(blobId, e);
        }
    }

    private void writeBlob(String blobId, InputStream stream) {
        try {
            this.blobStore.writeBlob(stream);
        }
        catch (IOException e) {
            throw new BlobWriteException(blobId, e);
        }
    }

    private InputStream downloadBlob(String blobId) throws InterruptedException {
        return this.blobDownloader.downloadBlob(blobId);
    }

    static interface BlobDownloader {
        public InputStream downloadBlob(String var1) throws InterruptedException;
    }
}

