/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment;

import java.io.InputStream;
import java.util.List;
import org.apache.jackrabbit.guava.common.base.Charsets;
import org.apache.jackrabbit.guava.common.base.Preconditions;
import org.apache.jackrabbit.guava.common.io.ByteStreams;
import org.apache.jackrabbit.oak.commons.Buffer;
import org.apache.jackrabbit.oak.segment.BlockRecord;
import org.apache.jackrabbit.oak.segment.ListRecord;
import org.apache.jackrabbit.oak.segment.RecordId;
import org.apache.jackrabbit.oak.segment.SegmentStore;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SegmentStream
extends InputStream {
    static final int BLOCK_SIZE = 4096;
    private final RecordId recordId;
    private final Buffer inline;
    private final ListRecord blocks;
    private final long length;
    private long position = 0L;
    private long mark = 0L;

    @Nullable
    public static RecordId getRecordIdIfAvailable(InputStream stream, SegmentStore store) {
        if (stream instanceof SegmentStream) {
            SegmentStream sStream = (SegmentStream)stream;
            RecordId id = sStream.recordId;
            if (sStream.position == 0L && id.getSegmentId().sameStore(store)) {
                return id;
            }
        }
        return null;
    }

    SegmentStream(RecordId recordId, ListRecord blocks, long length) {
        this.recordId = (RecordId)Preconditions.checkNotNull((Object)recordId);
        this.inline = null;
        this.blocks = (ListRecord)Preconditions.checkNotNull((Object)blocks);
        Preconditions.checkArgument((length >= 0L ? 1 : 0) != 0);
        this.length = length;
    }

    SegmentStream(RecordId recordId, Buffer inline, int length) {
        this.recordId = (RecordId)Preconditions.checkNotNull((Object)recordId);
        this.inline = inline.duplicate();
        this.blocks = null;
        this.length = length;
    }

    List<RecordId> getBlockIds() {
        if (this.blocks == null) {
            return null;
        }
        return this.blocks.getEntries();
    }

    public long getLength() {
        return this.length;
    }

    public String getString() {
        if (this.inline != null) {
            return this.inline.decode(Charsets.UTF_8).toString();
        }
        if (this.length > Integer.MAX_VALUE) {
            throw new IllegalStateException("Too long value: " + this.length);
        }
        try (SegmentStream stream = new SegmentStream(this.recordId, this.blocks, this.length);){
            byte[] data = new byte[(int)this.length];
            ByteStreams.readFully((InputStream)stream, (byte[])data);
            String string = new String(data, Charsets.UTF_8);
            return string;
        }
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public synchronized void mark(int readLimit) {
        this.mark = this.position;
    }

    @Override
    public synchronized void reset() {
        this.position = this.mark;
    }

    @Override
    public int read() {
        byte[] b = new byte[1];
        if (this.read(b, 0, 1) != -1) {
            return b[0] & 0xFF;
        }
        return -1;
    }

    @Override
    public int read(@NotNull byte[] b, int off, int len) {
        Preconditions.checkNotNull((Object)b);
        Preconditions.checkPositionIndexes((int)off, (int)(off + len), (int)b.length);
        if (len == 0) {
            return 0;
        }
        if (this.position == this.length) {
            return -1;
        }
        if (this.position + (long)len > this.length) {
            len = (int)(this.length - this.position);
        }
        if (this.inline != null) {
            this.inline.position((int)this.position);
            this.inline.get(b, off, len);
        } else {
            int blockIndex = (int)(this.position / 4096L);
            int blockOffset = (int)(this.position % 4096L);
            int blockCount = (blockOffset + len + 4096 - 1) / 4096;
            int remaining = len;
            List<RecordId> ids = this.blocks.getEntries(blockIndex, blockCount);
            RecordId previousId = ids.get(0);
            int consecutiveBlocks = 1;
            for (int i = 1; i <= ids.size(); ++i) {
                int n;
                RecordId id = null;
                if (i < ids.size()) {
                    id = ids.get(i);
                }
                assert (id == null || previousId != null);
                if (id != null && id.getSegmentId().equals(previousId.getSegmentId()) && id.getRecordNumber() == previousId.getRecordNumber() + consecutiveBlocks * 4096) {
                    ++consecutiveBlocks;
                    continue;
                }
                int blockSize = Math.min(blockOffset + remaining, consecutiveBlocks * 4096);
                BlockRecord block = new BlockRecord(previousId, blockSize);
                Preconditions.checkState((block.read(blockOffset, b, off, n = blockSize - blockOffset) == n ? 1 : 0) != 0);
                off += n;
                remaining -= n;
                previousId = id;
                consecutiveBlocks = 1;
                blockOffset = 0;
            }
            Preconditions.checkState((remaining == 0 ? 1 : 0) != 0);
        }
        this.position += (long)len;
        return len;
    }

    @Override
    public long skip(long n) {
        if (this.position + n > this.length) {
            n = this.length - this.position;
        } else if (this.position + n < 0L) {
            n = -this.position;
        }
        this.position += n;
        return n;
    }

    @Override
    public int available() {
        if (this.inline != null) {
            return (int)(this.length - this.position);
        }
        return 0;
    }

    @Override
    public void close() {
        this.position = this.length;
    }
}

