/*
 * Decompiled with CFR 0.152.
 */
package com.drew.imaging.heif;

import com.drew.imaging.heif.HeifHandler;
import com.drew.lang.SequentialReader;
import com.drew.lang.StreamReader;
import com.drew.metadata.heif.HeifDirectory;
import com.drew.metadata.heif.boxes.Box;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class HeifReader {
    private static final Set<String> ACCEPTABLE_PRE_META_BOX_TYPES = new HashSet<String>(Arrays.asList("ftyp", "meta"));

    public void extract(InputStream inputStream, HeifHandler<?> handler) {
        try {
            boolean markSupported = false;
            if (inputStream.markSupported()) {
                markSupported = true;
                inputStream.mark(inputStream.available() + 1);
            }
            StreamReader reader = new StreamReader(inputStream);
            reader.setMotorolaByteOrder(true);
            this.processTopLevelBoxes(inputStream, reader, -1L, handler, markSupported);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void processTopLevelBoxes(InputStream inputStream, SequentialReader reader, long atomEnd, HeifHandler<?> handler, boolean markSupported) throws IOException {
        HeifDirectory heifDirectory;
        boolean foundMetaBox = false;
        boolean needToReset = false;
        try {
            while (atomEnd == -1L || reader.getPosition() < atomEnd) {
                Box box = new Box(reader);
                if (!foundMetaBox && !ACCEPTABLE_PRE_META_BOX_TYPES.contains(box.type)) {
                    needToReset = true;
                }
                if ("meta".equalsIgnoreCase(box.type)) {
                    foundMetaBox = true;
                }
                handler = this.processBox(reader, box, handler);
            }
        }
        catch (IOException box) {
            // empty catch block
        }
        if (needToReset && markSupported) {
            inputStream.reset();
            reader = new StreamReader(inputStream);
            this.processBoxes(reader, -1L, handler);
        } else if (needToReset && (heifDirectory = handler.metadata.getFirstDirectoryOfType(HeifDirectory.class)) != null) {
            heifDirectory.addError("Unable to extract Exif data because inputStream was not resettable and 'meta' was not first box");
        }
    }

    private HeifHandler<?> processBoxes(SequentialReader reader, long atomEnd, HeifHandler<?> handler) {
        try {
            while (atomEnd == -1L || reader.getPosition() < atomEnd) {
                Box box = new Box(reader);
                handler = this.processBox(reader, box, handler);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return handler;
    }

    private HeifHandler<?> processBox(SequentialReader reader, Box box, HeifHandler<?> handler) throws IOException {
        if (handler.shouldAcceptContainer(box)) {
            handler.processContainer(box, reader);
            handler = this.processBoxes(reader, box.size + reader.getPosition() - 8L, handler);
        } else if (handler.shouldAcceptBox(box)) {
            handler = handler.processBox(box, reader.getBytes((int)box.size - 8));
        } else if (box.size > 1L) {
            reader.skip(box.size - 8L);
        }
        return handler;
    }
}

