/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.kmelia.notification;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.silverpeas.components.kmelia.notification.AbstractKmeliaFolderUserNotification;
import org.silverpeas.core.admin.ProfiledObjectId;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.admin.user.model.UserDetail;
import org.silverpeas.core.node.model.NodeDetail;
import org.silverpeas.core.notification.user.client.constant.NotifAction;

public class KmeliaTopicUserNotification
extends AbstractKmeliaFolderUserNotification {
    private final String alertType;

    public KmeliaTopicUserNotification(NodeDetail node, NotifAction action, String alertType) {
        super(node, action);
        this.alertType = alertType;
    }

    protected String getBundleSubjectKey() {
        if (NotifAction.CREATE.equals((Object)this.getAction())) {
            return "kmelia.notif.subject.folder.create";
        }
        return "kmelia.notif.subject.folder.update";
    }

    protected Collection<String> getUserIdsToNotify() {
        String[] users;
        boolean haveRights = ((NodeDetail)this.getResource()).haveRights();
        String rightsDependOn = ((NodeDetail)this.getResource()).getRightsDependsOn();
        NodeDetail fatherDetail = this.getNodeHeader(((NodeDetail)this.getResource()).getFatherPK());
        if (fatherDetail != null) {
            haveRights = fatherDetail.haveRights();
            rightsDependOn = fatherDetail.getRightsDependsOn();
        }
        if ((users = !haveRights ? this.getEitherAllOrAdmins() : this.getUsersWithModificationRights(rightsDependOn)) == null) {
            return Collections.emptyList();
        }
        return Arrays.asList(users);
    }

    private String[] getUsersWithModificationRights(String rightsDependOn) {
        String[] users;
        ArrayList<String> profileNames = new ArrayList<String>();
        profileNames.add("admin");
        profileNames.add("publisher");
        profileNames.add("writer");
        if (this.alertType.equals("All")) {
            profileNames.add("user");
            users = this.getOrganisationController().getUsersIdsByRoleNames(this.getComponentInstanceId(), ProfiledObjectId.fromNode((String)rightsDependOn), profileNames);
        } else {
            users = this.alertType.equals("Publisher") ? this.getOrganisationController().getUsersIdsByRoleNames(this.getComponentInstanceId(), ProfiledObjectId.fromNode((String)rightsDependOn), profileNames) : null;
        }
        return users;
    }

    private String[] getEitherAllOrAdmins() {
        String[] users;
        if ("All".equals(this.alertType)) {
            UserDetail[] userDetails = (UserDetail[])this.getOrganisationController().getAllUsers(this.getComponentInstanceId());
            if (userDetails != null) {
                users = new String[userDetails.length];
                int i = 0;
                for (UserDetail userDetail : userDetails) {
                    users[i++] = userDetail.getId();
                }
            } else {
                users = null;
            }
        } else if ("Publisher".equals(this.alertType)) {
            ArrayList<String> profileNames = new ArrayList<String>();
            profileNames.add("admin");
            profileNames.add("publisher");
            profileNames.add("writer");
            users = this.getOrganisationController().getUsersIdsByRoleNames(this.getComponentInstanceId(), profileNames);
        } else {
            users = null;
        }
        return users;
    }

    protected String getSenderName() {
        return User.getById((String)this.getSender()).getDisplayedName();
    }

    protected String getTemplateFileName() {
        if (NotifAction.CREATE.equals((Object)this.getAction())) {
            return "notificationCreateTopic";
        }
        return "notificationUpdateTopic";
    }
}

