/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.security.authorization.accesscontrol;

import java.security.Principal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.security.AccessControlEntry;
import javax.jcr.security.AccessControlException;
import javax.jcr.security.Privilege;
import org.apache.jackrabbit.api.security.authorization.PrivilegeManager;
import org.apache.jackrabbit.guava.common.base.Preconditions;
import org.apache.jackrabbit.guava.common.collect.Iterables;
import org.apache.jackrabbit.guava.common.collect.Lists;
import org.apache.jackrabbit.oak.namepath.NamePathMapper;
import org.apache.jackrabbit.oak.spi.security.authorization.accesscontrol.ACE;
import org.apache.jackrabbit.oak.spi.security.authorization.accesscontrol.AbstractAccessControlList;
import org.apache.jackrabbit.oak.spi.security.authorization.restriction.Restriction;
import org.apache.jackrabbit.oak.spi.security.authorization.restriction.RestrictionDefinition;
import org.apache.jackrabbit.oak.spi.security.privilege.PrivilegeBits;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class ACL
extends AbstractAccessControlList {
    private static final Logger log = LoggerFactory.getLogger(ACL.class);
    private final List<ACE> entries = new ArrayList<ACE>();

    ACL(@Nullable String oakPath, @Nullable List<ACE> entries, @NotNull NamePathMapper namePathMapper) {
        super(oakPath, namePathMapper);
        if (entries != null) {
            this.entries.addAll(entries);
        }
    }

    @NotNull
    abstract ACE createACE(@NotNull Principal var1, @NotNull PrivilegeBits var2, boolean var3, @NotNull Set<Restriction> var4) throws RepositoryException;

    abstract boolean checkValidPrincipal(@Nullable Principal var1) throws AccessControlException;

    @NotNull
    abstract PrivilegeManager getPrivilegeManager();

    @NotNull
    abstract PrivilegeBits getPrivilegeBits(@NotNull Privilege[] var1);

    @NotNull
    public List<ACE> getEntries() {
        return this.entries;
    }

    public void removeAccessControlEntry(AccessControlEntry ace) throws RepositoryException {
        ACE entry = ACL.checkACE(ace);
        if (!this.entries.remove(entry)) {
            throw new AccessControlException("Cannot remove AccessControlEntry " + ace);
        }
    }

    public boolean addEntry(@NotNull Principal principal, @NotNull Privilege[] privileges, boolean isAllow, @Nullable Map<String, Value> restrictions, @Nullable Map<String, Value[]> mvRestrictions) throws RepositoryException {
        if (privileges == null || privileges.length == 0) {
            throw new AccessControlException("Privileges may not be null nor an empty array");
        }
        for (Privilege p : privileges) {
            Privilege pv = this.getPrivilegeManager().getPrivilege(p.getName());
            if (!pv.isAbstract()) continue;
            throw new AccessControlException("Privilege " + p + " is abstract.");
        }
        if (!this.checkValidPrincipal(principal)) {
            return false;
        }
        Set<Restriction> rs = this.validateRestrictions(restrictions == null ? Collections.emptyMap() : restrictions, mvRestrictions == null ? Collections.emptyMap() : mvRestrictions);
        ACE entry = this.createACE(principal, this.getPrivilegeBits(privileges), isAllow, rs);
        if (this.entries.contains(entry)) {
            log.debug("Entry is already contained in policy -> no modification.");
            return false;
        }
        return this.internalAddEntry(entry);
    }

    public void orderBefore(@NotNull AccessControlEntry srcEntry, @Nullable AccessControlEntry destEntry) throws RepositoryException {
        int index;
        ACE dest;
        ACE src = ACL.checkACE(srcEntry);
        ACE aCE = dest = destEntry == null ? null : ACL.checkACE(destEntry);
        if (src.equals((Object)dest)) {
            log.debug("'srcEntry' equals 'destEntry' -> no reordering required.");
            return;
        }
        int n = index = dest == null ? this.entries.size() - 1 : this.entries.indexOf(dest);
        if (index < 0) {
            throw new AccessControlException("'destEntry' not contained in this AccessControlList.");
        }
        if (!this.entries.remove(src)) {
            throw new AccessControlException("srcEntry not contained in this AccessControlList");
        }
        this.entries.add(index, src);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ACL: ").append(this.getPath()).append("; ACEs: ");
        for (AccessControlEntry accessControlEntry : this.entries) {
            sb.append(accessControlEntry.toString()).append(';');
        }
        return sb.toString();
    }

    private static ACE checkACE(AccessControlEntry entry) throws AccessControlException {
        if (!(entry instanceof ACE)) {
            throw new AccessControlException("Invalid access control entry.");
        }
        return (ACE)entry;
    }

    private boolean internalAddEntry(@NotNull ACE entry) throws RepositoryException {
        String principalName = entry.getPrincipal().getName();
        Set restrictions = entry.getRestrictions();
        ArrayList subList = Lists.newArrayList((Iterable)Iterables.filter(this.entries, ace -> principalName.equals(((ACE)Preconditions.checkNotNull((Object)ace)).getPrincipal().getName()) && restrictions.equals(ace.getRestrictions())));
        boolean addEntry = true;
        for (ACE existing : subList) {
            PrivilegeBits existingBits = PrivilegeBits.getInstance((PrivilegeBits[])new PrivilegeBits[]{existing.getPrivilegeBits()});
            PrivilegeBits entryBits = entry.getPrivilegeBits();
            if (entry.isAllow() == existing.isAllow()) {
                if (existingBits.includes(entryBits)) {
                    return false;
                }
                existingBits.add(entryBits);
                int index = this.entries.indexOf(existing);
                this.entries.remove(existing);
                this.entries.add(index, this.createACE(existing, existingBits));
                addEntry = false;
                continue;
            }
            PrivilegeBits updated = PrivilegeBits.getInstance((PrivilegeBits[])new PrivilegeBits[]{existingBits}).diff(entryBits);
            if (updated.isEmpty()) {
                this.entries.remove(existing);
                continue;
            }
            if (updated.includes(existingBits)) continue;
            int index = this.entries.indexOf(existing);
            this.entries.remove(existing);
            this.entries.add(index, this.createACE(existing, updated));
        }
        if (addEntry) {
            this.entries.add(entry);
        }
        return true;
    }

    private ACE createACE(@NotNull ACE existing, @NotNull PrivilegeBits newPrivilegeBits) throws RepositoryException {
        return this.createACE(existing.getPrincipal(), newPrivilegeBits, existing.isAllow(), existing.getRestrictions());
    }

    @NotNull
    private Set<Restriction> validateRestrictions(@NotNull Map<String, Value> restrictions, @NotNull Map<String, Value[]> mvRestrictions) throws RepositoryException {
        Iterable mandatoryDefs = Iterables.filter((Iterable)this.getRestrictionProvider().getSupportedRestrictions(this.getOakPath()), RestrictionDefinition::isMandatory);
        for (RestrictionDefinition def : mandatoryDefs) {
            String string = this.getNamePathMapper().getJcrName(def.getName());
            boolean mandatoryPresent = def.getRequiredType().isArray() ? mvRestrictions.containsKey(string) : restrictions.containsKey(string);
            if (mandatoryPresent) continue;
            throw new AccessControlException("Mandatory restriction " + string + " is missing.");
        }
        HashSet<Restriction> rs = new HashSet<Restriction>();
        for (Map.Entry<String, Value> entry : restrictions.entrySet()) {
            String oakName = this.getNamePathMapper().getOakName(entry.getKey());
            rs.add(this.getRestrictionProvider().createRestriction(this.getOakPath(), oakName, entry.getValue()));
        }
        for (Map.Entry<String, Value> entry : mvRestrictions.entrySet()) {
            String oakName = this.getNamePathMapper().getOakName(entry.getKey());
            rs.add(this.getRestrictionProvider().createRestriction(this.getOakPath(), oakName, (Value[])entry.getValue()));
        }
        return rs;
    }
}

