/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment.standby.codec;

import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOutboundHandlerAdapter;
import io.netty.channel.ChannelPromise;
import java.io.InputStream;
import org.apache.jackrabbit.oak.segment.standby.codec.ChunkedBlobStream;
import org.apache.jackrabbit.oak.segment.standby.codec.GetBlobResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetBlobResponseEncoder
extends ChannelOutboundHandlerAdapter {
    private static final Logger log = LoggerFactory.getLogger(GetBlobResponseEncoder.class);
    private final int blobChunkSize;

    public GetBlobResponseEncoder(int blobChunkSize) {
        this.blobChunkSize = blobChunkSize;
    }

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        if (msg instanceof GetBlobResponse) {
            GetBlobResponse response = (GetBlobResponse)msg;
            log.debug("Sending blob {} to client {}", (Object)response.getBlobId(), (Object)response.getClientId());
            String clientId = response.getClientId();
            String blobId = response.getBlobId();
            long length = response.getLength();
            InputStream in = response.getInputStream();
            ctx.writeAndFlush((Object)new ChunkedBlobStream(clientId, blobId, length, in, this.blobChunkSize), promise);
        } else {
            ctx.write(msg, promise);
        }
    }
}

