/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.resourcesmanager.model;

import java.io.Serializable;
import java.util.Objects;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.Table;
import org.silverpeas.components.resourcesmanager.model.Reservation;
import org.silverpeas.components.resourcesmanager.model.ReservedResourcePk;
import org.silverpeas.components.resourcesmanager.model.Resource;
import org.silverpeas.core.persistence.datasource.model.jpa.BasicJpaEntity;

@Entity
@Table(name="sc_resources_reservedresource")
@NamedQueries(value={@NamedQuery(name="reservedResource.findAllResourcesForReservation", query="SELECT DISTINCT reservedResource.resource FROM ReservedResource reservedResource WHERE reservedResource.id.reservationId = :reservationId"), @NamedQuery(name="reservedResource.findAllReservedResources", query="SELECT DISTINCT reservedResource.resource FROM ReservedResource reservedResource WHERE reservedResource.reservation.id <> :reservationIdToSkip AND reservedResource.status <> 'R'AND reservedResource.resource.id.id IN :aimedResourceIds AND reservedResource.reservation.beginDate < :endPeriod AND reservedResource.reservation.endDate > :startPeriod "), @NamedQuery(name="reservedResource.findAllReservedResourcesWithProblem", query="SELECT DISTINCT reservedResource FROM ReservedResource reservedResource WHERE reservedResource.reservation.id <> :currentReservationId AND reservedResource.status <> 'R'AND reservedResource.resource.id.id IN :futureReservedResourceIds AND reservedResource.reservation.beginDate < :endPeriod AND reservedResource.reservation.endDate > :startPeriod "), @NamedQuery(name="reservedResource.findAllReservedResourcesForReservation", query="SELECT DISTINCT reservedResource FROM ReservedResource reservedResource WHERE reservedResource.reservation.id = :currentReservationId"), @NamedQuery(name="reservedResource.deleteAllReservedResourcesForReservation", query="DELETE FROM ReservedResource reservedResource WHERE reservedResource.id.reservationId = :currentReservationId"), @NamedQuery(name="reservedResource.deleteAllReservedResourcesForResource", query="DELETE FROM ReservedResource reservedResource WHERE reservedResource.id.resourceId = :currentResourceId"), @NamedQuery(name="reservedResource.deleteAllReservedResourcesForComponentInstance", query="DELETE FROM ReservedResource reservedResource WHERE reservedResource.reservation IN (SELECT reservation FROM Reservation reservation WHERE reservation.instanceId = :instanceId)"), @NamedQuery(name="reservedResource.findAllReservedResourcesOfReservation", query="SELECT DISTINCT reservedResource FROM ReservedResource reservedResource WHERE reservedResource.id.reservationId = :currentReservationId")})
public class ReservedResource
extends BasicJpaEntity<ReservedResource, ReservedResourcePk>
implements Serializable {
    private static final long serialVersionUID = -4233541745596218664L;
    @Column(name="status")
    private String status;
    @ManyToOne(optional=false)
    @JoinColumn(name="resourceId", updatable=false, insertable=false, referencedColumnName="id")
    private Resource resource;
    @ManyToOne(optional=false)
    @JoinColumn(name="reservationId", updatable=false, insertable=false, referencedColumnName="id")
    private Reservation reservation;

    public void setReservedResourceId(String resourceId, String reservationId) {
        this.setId(resourceId + ":" + reservationId);
    }

    public Reservation getReservation() {
        return this.reservation;
    }

    public void setReservation(Reservation reservation) {
        this.reservation = reservation;
    }

    private String[] getStringIds() {
        return this.getId().split(":");
    }

    public long getReservationId() {
        return Long.parseLong(this.getStringIds()[1]);
    }

    public Resource getResource() {
        return this.resource;
    }

    public void setResource(Resource resource) {
        this.resource = resource;
    }

    public long getResourceId() {
        return Long.parseLong(this.getStringIds()[0]);
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public boolean isValidated() {
        return "V".equals(this.status);
    }

    public boolean isRefused() {
        return "R".equals(this.status);
    }

    public boolean isValidationRequired() {
        return "A".equals(this.status);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ReservedResource other = (ReservedResource)obj;
        return Objects.equals(this.status, other.status);
    }

    public int hashCode() {
        int hash = 7;
        hash = 11 * hash + (this.getId() != null ? this.getId().hashCode() : 0);
        hash = 11 * hash + (this.status != null ? this.status.hashCode() : 0);
        return hash;
    }

    public String toString() {
        return "ReservedResource{reservedResourcePk=" + this.getId() + ", status=" + this.status + "}";
    }
}

